/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.delete;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.business.internal.navigation.MappingDefinitionFinder;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RetargetAction;

public class DeleteFromDiagramAction
extends RetargetAction
implements IObjectActionDelegate {
    private ISelection selection;

    public DeleteFromDiagramAction() {
        super("", "");
    }

    public DeleteFromDiagramAction(String text, String toolTipText, String id, ImageDescriptor image) {
        super(id, text);
        this.setImageDescriptor(image);
        this.setToolTipText(toolTipText);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
            LinkedList minimizedSelection = Lists.newLinkedList(Arrays.asList(structuredSelection.toArray()));
            Iterator iterSelection = minimizedSelection.iterator();
            DDiagramEditor diagramEditor = null;
            CompositeTransactionalCommand deleteCC = null;
            while (iterSelection.hasNext()) {
                Object nextSelected = iterSelection.next();
                if (!(nextSelected instanceof EditPart)) continue;
                EditPart editPart = (EditPart)nextSelected;
                if (diagramEditor == null) {
                    diagramEditor = (DDiagramEditor)((EditPart)nextSelected).getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
                    deleteCC = new CompositeTransactionalCommand(this.getEditingDomain(diagramEditor), DiagramUIActionsMessages.DeleteFromDiagram_ActionLabelText);
                }
                GroupRequest deleteRequest = null;
                deleteRequest = editPart instanceof NoteEditPart || editPart instanceof TextEditPart ? new GroupRequest((Object)"delete") : new GroupRequest((Object)"deleteFromDiagram");
                Command curCommand = editPart.getCommand((Request)deleteRequest);
                if (curCommand == null) continue;
                deleteCC.compose((IUndoableOperation)new CommandProxy(curCommand));
            }
            if (!deleteCC.isEmpty()) {
                ((IDiagramWorkbenchPart)diagramEditor).getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy(deleteCC));
            }
        }
    }

    private TransactionalEditingDomain getEditingDomain(DDiagramEditor editor) {
        return (TransactionalEditingDomain)editor.getAdapter(EditingDomain.class);
    }

    public void runWithEvent(Event event) {
        super.runWithEvent(event);
        this.run();
    }

    public void run() {
        this.selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        this.run((IAction)this);
    }

    public void selectionChanged(IAction action, ISelection s) {
        this.selection = s;
        if (action != null) {
            action.setEnabled(this.shouldBeEnabled(s));
        }
    }

    public boolean shouldBeEnabled(ISelection s) {
        Iterable<? extends IGraphicalEditPart> parts = this.filterSelection(s, IGraphicalEditPart.class);
        return DeleteFromDiagramAction.shouldBeEnabledForEditParts(parts);
    }

    public static boolean shouldBeEnabledForEditParts(Iterable<? extends IGraphicalEditPart> selectedParts) {
        Predicate<IGraphicalEditPart> isEditModeEnabledPredicate = new Predicate<IGraphicalEditPart>(){

            public boolean apply(IGraphicalEditPart input) {
                return input.isEditModeEnabled();
            }
        };
        if (Iterables.all(selectedParts, (Predicate)isEditModeEnabledPredicate) && !Iterables.all(selectedParts, (Predicate)Predicates.instanceOf(IDiagramNameEditPart.class))) {
            return DeleteFromDiagramAction.shouldBeEnabled(DeleteFromDiagramAction.getSelectedEObject(selectedParts));
        }
        return false;
    }

    public static Iterable<EObject> getSelectedEObject(Iterable<? extends IGraphicalEditPart> selectedParts) {
        return Iterables.transform(selectedParts, (Function)new Function<IGraphicalEditPart, EObject>(){

            public EObject apply(IGraphicalEditPart from) {
                return from.resolveSemanticElement();
            }
        });
    }

    public static boolean shouldBeEnabled(Iterable<EObject> selectedEObject) {
        boolean result = true;
        MappingDefinitionFinder defFinder = new MappingDefinitionFinder();
        for (EObject eObject : selectedEObject) {
            if (eObject == null) continue;
            EObject definition = defFinder.getDefinition(eObject);
            if (definition instanceof DiagramDescription) {
                result = false;
                break;
            }
            if (!(definition instanceof DiagramElementMapping) || !(eObject instanceof DDiagramElement) || !new DiagramElementMappingQuery((DiagramElementMapping)definition).isSynchronizedAndCreateElement((DDiagramElement)eObject)) continue;
            result = false;
            break;
        }
        return result;
    }

    private Iterable<? extends IGraphicalEditPart> filterSelection(ISelection s, Class<? extends IGraphicalEditPart> class1) {
        if (s instanceof StructuredSelection) {
            return Iterables.filter((Iterable)((StructuredSelection)s).toList(), class1);
        }
        return Lists.newArrayList();
    }

    public void dispose() {
        this.selection = null;
        super.dispose();
    }
}

