/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.util;

import java.util.Iterator;
import org.eclipse.gef.EditPart;

public final class EditPartTools {
    private EditPartTools() {
    }

    public static EditPart getEditPartOfType(EditPart root, Class<?> editPartType) {
        if (root == null || editPartType == null) {
            throw new IllegalArgumentException("root or editPartType is null");
        }
        EditPart result = null;
        if (editPartType.isInstance(root)) {
            result = root;
        }
        if (result == null) {
            Iterator iterChildren = root.getChildren().iterator();
            while (iterChildren.hasNext() && result == null) {
                result = EditPartTools.getEditPartOfType((EditPart)iterChildren.next(), editPartType);
            }
        }
        return result;
    }

    public static <T extends EditPart> T getParentOfType(EditPart aChild, Class<T> type) {
        EditPart result = null;
        EditPart current = aChild;
        while (result == null && current != null) {
            if (type.isInstance(current)) {
                result = (EditPart)type.cast(current);
                continue;
            }
            current = current.getParent();
        }
        return (T)result;
    }
}

