/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.WeakHashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.svg.InferringNamespaceContext;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.svg.SVGUtils;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.svg.SimpleImageTranscoder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGFigure
extends Figure {
    private String uri;
    private boolean failedToLoadDocument;
    private boolean specifyCanvasWidth = true;
    private boolean specifyCanvasHeight = true;
    private SimpleImageTranscoder transcoder;
    protected static WeakHashMap<String, Document> documentsMap = new WeakHashMap();

    public final String getURI() {
        return this.uri;
    }

    public final void setURI(String uri) {
        this.setURI(uri, true);
    }

    public void setURI(String uri, boolean loadOnDemand) {
        this.uri = uri;
        this.transcoder = null;
        this.failedToLoadDocument = false;
        if (loadOnDemand) {
            this.loadDocument();
        }
    }

    private void loadDocument() {
        this.transcoder = null;
        this.failedToLoadDocument = true;
        if (this.uri == null) {
            return;
        }
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
        try {
            Document document;
            String documentKey = this.getDocumentKey();
            if (documentsMap.containsKey(documentKey)) {
                document = documentsMap.get(documentKey);
            } else {
                document = factory.createDocument(this.uri);
                documentsMap.put(documentKey, document);
            }
            this.transcoder = new SimpleImageTranscoder(document);
            this.failedToLoadDocument = false;
        }
        catch (IOException e) {
            DiagramPlugin.getDefault().logError("Error loading SVG file", (Throwable)e);
        }
    }

    protected final Document getDocument() {
        if (this.failedToLoadDocument) {
            return null;
        }
        if (this.transcoder == null) {
            this.loadDocument();
        }
        return this.transcoder == null ? null : this.transcoder.getDocument();
    }

    protected String getDocumentKey() {
        return this.uri;
    }

    public final boolean checkContentAvailable() {
        return this.getDocument() != null;
    }

    private XPath getXPath() {
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new InferringNamespaceContext(this.getDocument().getDocumentElement()));
        return xpath;
    }

    protected final NodeList getNodes(String query) {
        Document document = this.getDocument();
        if (document != null) {
            try {
                return (NodeList)this.getXPath().evaluate(query, document, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected Color getColor(Element element, String attributeName) {
        if (this.getDocument() == null || this.getDocument() != element.getOwnerDocument()) {
            return null;
        }
        Color color = null;
        BridgeContext ctx = this.transcoder.initCSSEngine();
        try {
            color = SVGUtils.toSWTColor(element, attributeName);
        }
        finally {
            if (ctx != null) {
                ctx.dispose();
            }
        }
        return color;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        Image image = null;
        try {
            Rectangle r = this.getClientArea();
            this.transcoder.setCanvasSize(this.specifyCanvasWidth ? r.width : -1, this.specifyCanvasHeight ? r.height : -1);
            this.updateRenderingHints(graphics);
            BufferedImage awtImage = this.transcoder.getBufferedImage();
            if (awtImage != null) {
                image = SVGFigure.toSWT((Device)Display.getCurrent(), awtImage);
                graphics.drawImage(image, r.x, r.y);
            }
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
    }

    protected void updateRenderingHints(Graphics graphics) {
        int aa = -1;
        try {
            aa = graphics.getAntialias();
        }
        catch (Exception exception) {}
        Object aaHint = aa == 1 ? RenderingHints.VALUE_ANTIALIAS_ON : (aa == 0 ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        if (this.transcoder.getRenderingHints().get(RenderingHints.KEY_ANTIALIASING) != aaHint) {
            this.transcoder.getRenderingHints().put(RenderingHints.KEY_ANTIALIASING, aaHint);
            this.transcoder.contentChanged();
        }
        aa = -1;
        try {
            aa = graphics.getTextAntialias();
        }
        catch (Exception exception) {}
        aaHint = aa == 1 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : (aa == 0 ? RenderingHints.VALUE_TEXT_ANTIALIAS_OFF : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        if (this.transcoder.getRenderingHints().get(RenderingHints.KEY_TEXT_ANTIALIASING) != aaHint) {
            this.transcoder.getRenderingHints().put(RenderingHints.KEY_TEXT_ANTIALIASING, aaHint);
            this.transcoder.contentChanged();
        }
    }

    protected static Image toSWT(Device device, BufferedImage awtImage) {
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData swtImageData = new ImageData(awtImage.getWidth(), awtImage.getHeight(), 24, palette);
        int scansize = (awtImage.getWidth() * 3 + 3) * 4 / 4;
        WritableRaster alphaRaster = awtImage.getAlphaRaster();
        byte[] alphaBytes = new byte[awtImage.getWidth()];
        int y = 0;
        while (y < awtImage.getHeight()) {
            int[] buff = awtImage.getRGB(0, y, awtImage.getWidth(), 1, null, 0, scansize);
            swtImageData.setPixels(0, y, awtImage.getWidth(), buff, 0);
            if (alphaRaster != null) {
                int[] alpha = alphaRaster.getPixels(0, y, awtImage.getWidth(), 1, (int[])null);
                int i = 0;
                while (i < awtImage.getWidth()) {
                    alphaBytes[i] = (byte)alpha[i];
                    ++i;
                }
                swtImageData.setAlphas(0, y, awtImage.getWidth(), alphaBytes, 0);
            }
            ++y;
        }
        return new Image(device, swtImageData);
    }

    public final Rectangle2D getAreaOfInterest() {
        this.getDocument();
        return this.transcoder == null ? null : this.transcoder.getCanvasAreaOfInterest();
    }

    public void setAreaOfInterest(Rectangle2D value) {
        this.getDocument();
        if (this.transcoder != null) {
            this.transcoder.setCanvasAreaOfInterest(value);
        }
        this.repaint();
    }

    public final boolean isSpecifyCanvasWidth() {
        return this.specifyCanvasWidth;
    }

    public void setSpecifyCanvasWidth(boolean specifyCanvasWidth) {
        this.specifyCanvasWidth = specifyCanvasWidth;
        this.contentChanged();
    }

    public final boolean isSpecifyCanvasHeight() {
        return this.specifyCanvasHeight;
    }

    public void setSpecifyCanvasHeight(boolean specifyCanvasHeight) {
        this.specifyCanvasHeight = specifyCanvasHeight;
        this.contentChanged();
    }

    public void contentChanged() {
        this.getDocument();
        if (this.transcoder != null) {
            this.transcoder.contentChanged();
        }
        this.repaint();
    }

    protected SimpleImageTranscoder getTranscoder() {
        return this.transcoder;
    }

    protected boolean getSpecifyCanvasWidth() {
        return this.specifyCanvasWidth;
    }

    protected boolean getSpecifyCanvasHeight() {
        return this.specifyCanvasHeight;
    }
}

