/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.ui.internal.refresh.SynchronizeDDiagramElementStylePropertiesCommand;
import org.eclipse.sirius.diagram.ui.internal.refresh.diagram.ViewPropertiesSynchronizer;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class FontFormatUpdater
extends ResourceSetListenerImpl {
    private static final NotificationFilter FEATURES_TO_REFACTOR_FILTER = NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic()))).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold()).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic()))).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontHeight())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontColor()));

    public FontFormatUpdater(TransactionalEditingDomain domain) {
        super(FEATURES_TO_REFACTOR_FILTER);
        domain.addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        FontStyle fontStyle;
        CompoundCommand cc = new CompoundCommand();
        HashMap<FontStyle, HashSet<EStructuralFeature>> fontStyleFeatureChanges = new HashMap<FontStyle, HashSet<EStructuralFeature>>();
        for (Notification notification : event.getNotifications()) {
            if (!(notification.getNotifier() instanceof FontStyle) || !(notification.getFeature() instanceof EStructuralFeature)) continue;
            fontStyle = (FontStyle)notification.getNotifier();
            EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
            HashSet<EStructuralFeature> featureChanges = (HashSet<EStructuralFeature>)fontStyleFeatureChanges.get(fontStyle);
            if (featureChanges == null) {
                featureChanges = new HashSet<EStructuralFeature>();
                fontStyleFeatureChanges.put(fontStyle, featureChanges);
            }
            featureChanges.add(feature);
        }
        for (Map.Entry entry : fontStyleFeatureChanges.entrySet()) {
            DDiagramElement dDiagramElement;
            org.eclipse.sirius.viewpoint.Style style;
            fontStyle = (FontStyle)entry.getKey();
            Set features = (Set)entry.getValue();
            View view = (View)fontStyle.eContainer();
            if (!(view.getElement() instanceof DDiagramElement) || features.isEmpty() || !this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)(style = (dDiagramElement = (DDiagramElement)view.getElement()).getStyle()), fontStyle, features)) continue;
            Set<String> featureNames = this.getFeatureNames(features);
            if (style instanceof EdgeStyle) {
                Command addCustomFeaturesCmd;
                EdgeStyle edgeStyle = (EdgeStyle)style;
                if (edgeStyle.getBeginLabelStyle() != null) {
                    featureNames.addAll((Collection<String>)edgeStyle.getBeginLabelStyle().getCustomFeatures());
                    addCustomFeaturesCmd = SetCommand.create((EditingDomain)this.getTarget(), (Object)edgeStyle.getBeginLabelStyle(), (Object)ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES, featureNames);
                    cc.append(addCustomFeaturesCmd);
                }
                if (edgeStyle.getCenterLabelStyle() != null) {
                    featureNames.addAll((Collection<String>)edgeStyle.getCenterLabelStyle().getCustomFeatures());
                    addCustomFeaturesCmd = SetCommand.create((EditingDomain)this.getTarget(), (Object)edgeStyle.getCenterLabelStyle(), (Object)ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES, featureNames);
                    cc.append(addCustomFeaturesCmd);
                }
                if (edgeStyle.getEndLabelStyle() != null) {
                    featureNames.addAll((Collection<String>)edgeStyle.getEndLabelStyle().getCustomFeatures());
                    addCustomFeaturesCmd = SetCommand.create((EditingDomain)this.getTarget(), (Object)edgeStyle.getEndLabelStyle(), (Object)ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES, featureNames);
                    cc.append(addCustomFeaturesCmd);
                }
            } else {
                featureNames.addAll((Collection<String>)style.getCustomFeatures());
                Command addCustomFeaturesCmd = SetCommand.create((EditingDomain)this.getTarget(), (Object)style, (Object)ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES, featureNames);
                cc.append(addCustomFeaturesCmd);
            }
            cc.append((Command)new SynchronizeDDiagramElementStylePropertiesCommand(this.getTarget(), view));
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private boolean isViewFontStylePropertiesDifferentOfGMFOne(Customizable viewpointStyle, FontStyle gmfFontStyle, Set<EStructuralFeature> gmfStyleFeatures) {
        boolean isViewFontStylePropertiesDifferentOfGMFOne;
        block4: {
            block3: {
                isViewFontStylePropertiesDifferentOfGMFOne = false;
                if (!(viewpointStyle instanceof EdgeStyle)) break block3;
                EdgeStyle edgeStyle = (EdgeStyle)viewpointStyle;
                if (edgeStyle.getBeginLabelStyle() != null) {
                    isViewFontStylePropertiesDifferentOfGMFOne = this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)edgeStyle.getBeginLabelStyle(), gmfFontStyle, gmfStyleFeatures);
                }
                if (!isViewFontStylePropertiesDifferentOfGMFOne && edgeStyle.getCenterLabelStyle() != null) {
                    isViewFontStylePropertiesDifferentOfGMFOne = this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)edgeStyle.getCenterLabelStyle(), gmfFontStyle, gmfStyleFeatures);
                }
                if (isViewFontStylePropertiesDifferentOfGMFOne || edgeStyle.getEndLabelStyle() == null) break block4;
                isViewFontStylePropertiesDifferentOfGMFOne = this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)edgeStyle.getEndLabelStyle(), gmfFontStyle, gmfStyleFeatures);
                break block4;
            }
            for (EStructuralFeature gmfStyleFeature : gmfStyleFeatures) {
                EStructuralFeature viewpointStyleFeature = ViewPropertiesSynchronizer.GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.get(gmfStyleFeature);
                if (!(viewpointStyleFeature instanceof EAttribute) || !viewpointStyle.eClass().getEAllStructuralFeatures().contains((Object)viewpointStyleFeature)) continue;
                Object viewpointStyleProperty = viewpointStyle.eGet(viewpointStyleFeature);
                Object gmfStyleProperty = this.convertToSiriusPropertyValue((Style)gmfFontStyle, gmfStyleFeature);
                if (viewpointStyleProperty == null || viewpointStyleProperty.equals(gmfStyleProperty)) continue;
                isViewFontStylePropertiesDifferentOfGMFOne = true;
                break;
            }
        }
        return isViewFontStylePropertiesDifferentOfGMFOne;
    }

    private Object convertToSiriusPropertyValue(Style gmfStyle, EStructuralFeature gmfStyleAttribute) {
        Object gmfStylePropertyValue = gmfStyle.eGet(gmfStyleAttribute);
        if (gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__BOLD || gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__ITALIC) {
            FontStyle gmfFontStyle = (FontStyle)gmfStyle;
            gmfStylePropertyValue = gmfFontStyle.isBold() && gmfFontStyle.isItalic() ? FontFormat.BOLD_ITALIC_LITERAL : (gmfFontStyle.isBold() ? FontFormat.BOLD_LITERAL : (gmfFontStyle.isItalic() ? FontFormat.ITALIC_LITERAL : FontFormat.NORMAL_LITERAL));
        }
        return gmfStylePropertyValue;
    }

    private Set<String> getFeatureNames(Set<EStructuralFeature> features) {
        LinkedHashSet<String> featureNames = new LinkedHashSet<String>();
        for (EStructuralFeature feature : features) {
            EStructuralFeature eStructuralFeature;
            String featureName = feature.getName();
            if (this.isFeatureOfNotationPackage(feature) && (eStructuralFeature = ViewPropertiesSynchronizer.GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.get(feature)) != null) {
                featureName = eStructuralFeature.getName();
            }
            featureNames.add(featureName);
        }
        return featureNames;
    }

    private boolean isFeatureOfNotationPackage(EStructuralFeature feature) {
        boolean isFeatureOfNotationPackage = false;
        isFeatureOfNotationPackage = feature.getEContainingClass().getEPackage() == NotationPackage.eINSTANCE;
        return isFeatureOfNotationPackage;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }
}

