/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INotableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.ISiriusEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.SelectionCommandAppender;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusContainerDropPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeListViewNodeListCompartmentItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.canonicals.DumnySiriusCanonicalEditPolicy;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.tool.MappingBasedToolDescription;

public abstract class AbstractDNodeListCompartmentEditPart
extends ListCompartmentEditPart
implements INotableEditPart,
ISurfaceEditPart,
ISiriusEditPart {
    private boolean isSupportingViewActions = false;
    private Comparator mappingComparator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            EObject eObj;
            if (!(arg0 instanceof View) || !(arg1 instanceof View)) {
                throw new IllegalArgumentException();
            }
            View view0 = (View)arg0;
            View view1 = (View)arg1;
            EObject element0 = view0.getElement();
            EObject element1 = view1.getElement();
            if (element0 instanceof DMappingBased && element1 instanceof DMappingBased && (eObj = AbstractDNodeListCompartmentEditPart.this.resolveSemanticElement()) instanceof DNodeList) {
                DNodeList container = (DNodeList)eObj;
                EList allMappings = container.getActualMapping().getAllNodeMappings();
                RepresentationElementMapping origin0 = ((DMappingBased)element0).getMapping();
                RepresentationElementMapping origin1 = ((DMappingBased)element1).getMapping();
                return allMappings.indexOf(origin0) - allMappings.indexOf(origin1);
            }
            return 0;
        }
    };
    private Comparator<View> indexComparator = new Comparator<View>(){

        @Override
        public int compare(View o1, View o2) {
            EObject semantic = AbstractDNodeListCompartmentEditPart.this.resolveSemanticElement();
            if (semantic instanceof DNodeList) {
                EObject sem1 = ViewUtil.resolveSemanticElement((View)o1);
                EObject sem2 = ViewUtil.resolveSemanticElement((View)o2);
                if (sem1 instanceof DNodeListElement && sem2 instanceof DNodeListElement) {
                    return ((DNodeList)semantic).getNodes().indexOf((Object)sem1) - ((DNodeList)semantic).getNodes().indexOf((Object)sem2);
                }
            }
            return 0;
        }
    };

    public AbstractDNodeListCompartmentEditPart(View view) {
        super((EObject)view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeListViewNodeListCompartmentItemSemanticEditPolicy());
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new SiriusContainerDropPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new DumnySiriusCanonicalEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new NodeCreationEditPolicy());
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
    }

    public boolean isSupportingViewActions() {
        return this.isSupportingViewActions;
    }

    public void setIsSupportingViewActions(boolean supportsViewActions) {
        this.isSupportingViewActions = supportsViewActions;
    }

    protected boolean hasModelChildrenChanged(Notification evt) {
        return false;
    }

    public IFigure createFigure() {
        ResizableCompartmentFigure result = (ResizableCompartmentFigure)super.createFigure();
        result.setTitleVisibility(false);
        result.setToolTip(null);
        IFigure contentPane = result.getContentPane();
        if (contentPane != null && contentPane.getBorder() instanceof MarginBorder) {
            Insets insets = contentPane.getBorder().getInsets((IFigure)result);
            Insets legacyBorderCompensation = new Insets(0, -1, -1, -1);
            contentPane.setBorder((Border)new MarginBorder(insets.getAdded(legacyBorderCompensation)));
        }
        return result;
    }

    protected void setRatio(Double ratio) {
        if (this.getFigure().getParent() != null && this.getFigure().getParent().getLayoutManager() instanceof ConstrainedToolbarLayout) {
            super.setRatio(ratio);
        }
    }

    protected List<?> getModelChildren() {
        ArrayList modelChildren = new ArrayList(super.getModelChildren());
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        Collections.sort(modelChildren, this.indexComparator);
        Collections.sort(modelChildren, this.mappingComparator);
        return modelChildren;
    }

    public boolean canAttachNote() {
        return true;
    }

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    public List getPrimaryEditParts() {
        ArrayList<ConnectionEditPart> connections = new ArrayList<ConnectionEditPart>();
        Object diagramEditPart = this.getViewer().getEditPartRegistry().get(this.getDiagramView());
        List shapes = this.getChildren();
        HashSet connectableEditParts = new HashSet(shapes);
        Iterator iter = shapes.iterator();
        while (iter.hasNext()) {
            this.getBorderItemEditParts((EditPart)iter.next(), connectableEditParts);
        }
        if (diagramEditPart instanceof DiagramEditPart) {
            for (ConnectionEditPart connection : ((DiagramEditPart)diagramEditPart).getConnections()) {
                if (!connectableEditParts.contains(connection.getSource()) && !connectableEditParts.contains(connection.getTarget())) continue;
                connections.add(connection);
            }
        }
        if (connections.size() > 0 || shapes.size() > 0) {
            ArrayList<ConnectionEditPart> primaryEditParts = new ArrayList<ConnectionEditPart>();
            primaryEditParts.addAll(shapes);
            primaryEditParts.addAll(connections);
            return primaryEditParts;
        }
        return Collections.EMPTY_LIST;
    }

    private void getBorderItemEditParts(EditPart parent, Set retval) {
        for (EditPart child : parent.getChildren()) {
            if (child instanceof IBorderItemEditPart) {
                retval.add(child);
                retval.addAll(child.getChildren());
            }
            this.getBorderItemEditParts(child, retval);
        }
    }

    public void refresh() {
        super.refresh();
        Iterable children = Iterables.filter((Iterable)this.getChildren(), EditPart.class);
        for (EditPart childEditPart : children) {
            childEditPart.refresh();
        }
    }

    public Command getCommand(Request _request) {
        Command command;
        RequestQuery requestQuery = new RequestQuery(_request);
        if (requestQuery.isNoteCreationRequest() || requestQuery.isTextCreationRequest() || requestQuery.isNoteDropRequest() || requestQuery.isTextDropRequest()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (_request instanceof CreateRequest && ((CreateRequest)_request).getNewObject() instanceof MappingBasedToolDescription && (command = super.getCommand(_request)) != null) {
            return SelectionCommandAppender.addSelectionCommand(command, (GraphicalEditPart)this);
        }
        return super.getCommand(_request);
    }
}

