/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SiriusBaseItemSemanticEditPolicy;

public class DEdgeCreateCommand
extends CreateElementCommand {
    private final EObject source;
    private final EObject target;
    private DDiagram container;

    public DEdgeCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super((CreateElementRequest)request);
        this.source = source;
        this.target = target;
        if (request.getContainmentFeature() == null) {
            this.setContainmentFeature(DiagramPackage.eINSTANCE.getDDiagram_OwnedDiagramElements());
        }
        EObject element = source;
        while (element != null) {
            if (element instanceof DDiagram) {
                this.container = (DDiagram)element;
                super.setElementToEdit((EObject)this.container);
                break;
            }
            element = element.eContainer();
        }
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof EdgeTarget)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof EdgeTarget)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return SiriusBaseItemSemanticEditPolicy.LinkConstraints.canCreateDEdge_4001(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected EObject doDefaultElementCreation() {
        DEdge newElement = DiagramFactory.eINSTANCE.createDEdge();
        this.getContainer().getOwnedDiagramElements().add((Object)newElement);
        newElement.setSourceNode(this.getSource());
        newElement.setTargetNode(this.getTarget());
        return newElement;
    }

    protected EClass getEClassToEdit() {
        return DiagramPackage.eINSTANCE.getDDiagram();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        return super.doExecuteWithResult(monitor, info);
    }

    protected ConfigureRequest createConfigureRequest() {
        ConfigureRequest request = super.createConfigureRequest();
        request.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        request.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        return request;
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected EdgeTarget getSource() {
        return (EdgeTarget)this.source;
    }

    protected EdgeTarget getTarget() {
        return (EdgeTarget)this.target;
    }

    public DDiagram getContainer() {
        return this.container;
    }
}

