/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.query.NotifierQuery;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.part.DDiagramHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.listener.IChangeListener;
import org.eclipse.sirius.tools.api.command.listener.TriggerOperation;
import org.eclipse.ui.IEditorPart;

public final class SelectionCommandAppender {
    static TriggerOperation selectionOfCreatedElementsTriggerOperation;

    private SelectionCommandAppender() {
    }

    public static Command addSelectionCommand(Command command, GraphicalEditPart editPart) {
        DDiagram currentDDiagram = DDiagramHelper.findParentDDiagram((IGraphicalEditPart)editPart);
        if (currentDDiagram != null) {
            return SelectionCommandAppender.decorateCommandWithSelectionOfCreatedElements(command, (Notifier)currentDDiagram);
        }
        return SelectionCommandAppender.decorateCommandWithSelectionOfCreatedElements(command, (Notifier)editPart.getEditingDomain().getResourceSet());
    }

    private static Command decorateCommandWithSelectionOfCreatedElements(Command command, Notifier notifier) {
        final Option optionalListener = new NotifierQuery(notifier).getAdapter(IChangeListener.class);
        CompoundCommand cc = new CompoundCommand(command.getLabel());
        if (optionalListener.some()) {
            ((IChangeListener)optionalListener.get()).setTriggerOperation(SelectionCommandAppender.getSelectionOfCreatedElementsTriggerOperation());
            cc.add(new Command(){

                public void execute() {
                    ((IChangeListener)optionalListener.get()).activate();
                }
            });
        }
        cc.add(command);
        if (optionalListener.some()) {
            cc.add(new Command(){

                public void execute() {
                    ((IChangeListener)optionalListener.get()).deactivate();
                    if (!((IChangeListener)optionalListener.get()).isActivated()) {
                        ((IChangeListener)optionalListener.get()).launchTriggerOperation();
                    }
                }
            });
        }
        return cc;
    }

    private static TriggerOperation getSelectionOfCreatedElementsTriggerOperation() {
        if (selectionOfCreatedElementsTriggerOperation == null) {
            selectionOfCreatedElementsTriggerOperation = new TriggerOperation(){

                public void run(Collection<Object> createdElements, Collection<Object> modifiedElements, Collection<Object> deletedElements) {
                    if (createdElements == null || createdElements.isEmpty()) {
                        return;
                    }
                    ArrayList<EditPart> editPartsToSelect = new ArrayList<EditPart>();
                    for (Object object : createdElements) {
                        Option<EditPart> targetEditPart;
                        if (!(object instanceof DDiagramElement) || !(targetEditPart = SelectionCommandAppender.getEditPart((DDiagramElement)object)).some()) continue;
                        editPartsToSelect.add((EditPart)targetEditPart.get());
                    }
                    IEditorPart editor = EclipseUIUtil.getActiveEditor();
                    if (!editPartsToSelect.isEmpty() && editor instanceof DiagramEditor) {
                        SiriusDiagramEditorUtil.selectWithoutRevealElementsInDiagram((IDiagramWorkbenchPart)((DiagramEditor)editor), editPartsToSelect);
                    }
                }
            };
        }
        return selectionOfCreatedElementsTriggerOperation;
    }

    protected static Option<EditPart> getEditPart(DDiagramElement dDiagramElement) {
        Map editPartRegistry;
        EditPart targetEditPart;
        Option result = Options.newNone();
        View view = null;
        Collection inverseReferences = new EObjectQuery((EObject)dDiagramElement).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
        for (EObject object : inverseReferences) {
            if (!(object instanceof View)) continue;
            view = (View)object;
            break;
        }
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (view != null && editor instanceof DiagramEditor && (targetEditPart = (EditPart)(editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(view)) != null) {
            result = Options.newSome((Object)targetEditPart);
        }
        return result;
    }
}

