/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Shape;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.ui.business.internal.edit.helpers.LabelAlignmentHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramContainerEditPartOperation;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GradientRoundedRectangle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerFigureDesc;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.LabelAlignment;
import org.eclipse.sirius.viewpoint.RGBValues;

public final class DiagramListEditPartOperation {
    private DiagramListEditPartOperation() {
    }

    public static void handleNotificationEvent(IDiagramListEditPart self, Notification notification) {
    }

    public static void refreshVisuals(IDiagramListEditPart self) {
        DDiagramElement diagElement = self.resolveDiagramElement();
        if (diagElement instanceof DNodeList) {
            RGBValues rgb;
            int borderSize;
            DNodeList list = (DNodeList)diagElement;
            ((Shape)self.getPrimaryShape()).setLineWidth(list.getLineWidth());
            if (list.getLineWidth() == 0) {
                ((Shape)self.getPrimaryShape()).setOutline(false);
            }
            if (self.getBackgroundFigure() == null && list.getOwnedStyle() != null && self.getBackgroundFigure() != null) {
                self.getFigure().add(self.getBackgroundFigure(), 0);
            }
            ContainerStyle style = list.getOwnedStyle();
            ViewNodeContainerFigureDesc primaryShape = self.getPrimaryShape();
            int n = borderSize = style == null ? 0 : style.getBorderSize();
            if (borderSize == 0) {
                borderSize = 1;
            }
            if (borderSize > 0) {
                if (primaryShape instanceof Shape) {
                    ((Shape)primaryShape).setLineWidth(borderSize);
                } else if (primaryShape instanceof NodeFigure) {
                    ((NodeFigure)primaryShape).setLineWidth(borderSize);
                }
                if (primaryShape != null && primaryShape.getBorder() instanceof LineBorder) {
                    ((LineBorder)primaryShape.getBorder()).setWidth(borderSize);
                } else if (primaryShape != null && primaryShape.getBorder() instanceof MarginBorder) {
                    primaryShape.setBorder((Border)new MarginBorder(borderSize + 5 - 1, borderSize, borderSize, borderSize));
                }
            }
            if (style instanceof FlatContainerStyle && (rgb = ((FlatContainerStyle)style).getForegroundColor()) != null && primaryShape instanceof GradientRoundedRectangle) {
                ((GradientRoundedRectangle)primaryShape).setGradientColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
                ((GradientRoundedRectangle)primaryShape).setCornerDimensions(DiagramContainerEditPartOperation.getCornerDimension(self));
            }
        }
        if (diagElement != null) {
            self.setTooltipText(diagElement.getTooltipText());
            DiagramListEditPartOperation.refreshLabelAlignment(self, diagElement);
        }
    }

    private static void refreshLabelAlignment(IDiagramListEditPart self, DDiagramElement diagElement) {
        IFigure secondChild;
        IFigure firstChild;
        IFigure fig;
        LabelAlignment alignment = LabelAlignmentHelper.getLabelAlignementFor(diagElement);
        if (alignment != null && (fig = self.getFigure()).getChildren().size() > 0 && (firstChild = (IFigure)fig.getChildren().get(0)).getChildren().size() > 0 && (secondChild = (IFigure)firstChild.getChildren().get(0)) != null && secondChild.getLayoutManager() instanceof ConstrainedToolbarLayout) {
            ConstrainedToolbarLayout ctl = (ConstrainedToolbarLayout)secondChild.getLayoutManager();
            ctl.setMinorAlignment(LabelAlignmentHelper.getAsCTLMinorAlignment(alignment));
        }
    }

    public static void refreshForegroundColor(IDiagramListEditPart self) {
        RGBValues borderColor;
        DNodeList list;
        ContainerStyle ownedStyle;
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DNodeList && (ownedStyle = (list = (DNodeList)eObj).getOwnedStyle()) != null && ownedStyle instanceof FlatContainerStyle && (borderColor = ((FlatContainerStyle)ownedStyle).getBorderColor()) != null) {
            self.getFigure().setForegroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(borderColor));
        }
    }

    public static void refreshBackgroundColor(IDiagramListEditPart self) {
        EObject eObj = self.resolveSemanticElement();
        if (eObj instanceof DNodeList) {
            DNodeList list = (DNodeList)eObj;
            RGBValues rgb = null;
            ContainerStyle ownedStyle = list.getOwnedStyle();
            if (ownedStyle instanceof FlatContainerStyle) {
                rgb = ((FlatContainerStyle)ownedStyle).getBackgroundColor();
            } else if (ownedStyle instanceof ShapeContainerStyle) {
                rgb = ((ShapeContainerStyle)ownedStyle).getBackgroundColor();
            }
            if (rgb != null) {
                self.getFigure().setBackgroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(rgb));
            }
        }
    }

    public static void refreshFont(IDiagramListEditPart self) {
        if (!self.getChildren().isEmpty()) {
            Object secondChild;
            Object firstChild = self.getChildren().get(0);
            if (firstChild instanceof IDiagramNameEditPart) {
                DiagramNameEditPartOperation.refreshFont((IDiagramNameEditPart)firstChild);
            }
            if ((secondChild = self.getChildren().get(1)) instanceof CompartmentEditPart) {
                for (Object listEP : ((CompartmentEditPart)secondChild).getChildren()) {
                    if (!(listEP instanceof AbstractDiagramNameEditPart)) continue;
                    DiagramNameEditPartOperation.refreshFont((AbstractDiagramNameEditPart)listEP);
                }
            }
        }
    }
}

