/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Proxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractBorderedDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.AbstractDiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DefaultDirectEditOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.edit.internal.validators.ResizeValidator;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SpecificBorderItemSelectionEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.canonicals.DumnySiriusCanonicalEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewLocationHint;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AirDefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.anchor.AnchorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.NoCopyDragEditPartsTrackerEx;
import org.eclipse.swt.graphics.Color;

public abstract class AbstractDiagramNodeEditPart
extends AbstractBorderedDiagramElementEditPart
implements IDiagramNodeEditPart {
    private Color bgColor;

    public AbstractDiagramNodeEditPart(View view) {
        super(view);
    }

    protected void handleNotificationEvent(Notification notification) {
        EObject element;
        IStyleEditPart styleEditPart = this.getStyleEditPart();
        if (styleEditPart != null && (element = ((IGraphicalEditPart)styleEditPart).resolveSemanticElement()) != null && element.eResource() != null) {
            styleEditPart.refresh();
        }
        if ((element = this.resolveSemanticElement()) != null && element.eResource() != null && this.getParent() != null) {
            this.refresh();
        }
        super.handleNotificationEvent(notification);
        AbstractDiagramNodeEditPartOperation.handleNotificationEvent(this, notification);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        AbstractDiagramNodeEditPartOperation.createDefaultEditPolicies(this);
        this.installEditPolicy("Canonical", (EditPolicy)new DumnySiriusCanonicalEditPolicy());
    }

    public void refresh() {
        EObject element = this.resolveSemanticElement();
        if (element != null && this.getMetamodelType().isInstance(element)) {
            super.refresh();
            this.refreshVisuals();
            Iterable children = Iterables.filter((Iterable)this.getChildren(), EditPart.class);
            for (EditPart childEditPart : children) {
                childEditPart.refresh();
            }
        }
    }

    protected List getModelChildren() {
        DNode node;
        ArrayList modelChildren = Lists.newArrayList((Iterable)super.getModelChildren());
        DiagramElementEditPartOperation.removeInvisibleElements(modelChildren);
        DDiagramElement diagramElement = this.resolveDiagramElement();
        if (diagramElement instanceof DNode && ((node = (DNode)diagramElement).getStyle() != null && ((NodeStyle)node.getStyle()).getLabelPosition() == LabelPosition.NODE_LITERAL || StringUtil.isEmpty((String)node.getName()))) {
            DiagramNodeEditPartOperation.removeLabel(this, modelChildren);
        }
        return modelChildren;
    }

    protected Command getPortCreationCommand(Command originalCommand, CreateViewRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Create View");
        compositeCommand.compose((IUndoableOperation)new CommandProxy(originalCommand));
        Iterator iterDescriptor = request.getViewDescriptors().iterator();
        LayoutUtils.prepareFigureForDummyAdds(this.getBorderedFigure().getBorderItemContainer());
        while (iterDescriptor.hasNext()) {
            EObject containerSemanticElement;
            Object createdElement;
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iterDescriptor.next();
            IAdaptable adapt = viewDescriptor.getElementAdapter();
            if (!(adapt instanceof Proxy) || !((createdElement = ((Proxy)adapt).getRealObject()) instanceof DNode) || !((DNode)(containerSemanticElement = this.resolveSemanticElement())).getActualMapping().getAllBorderedNodeMappings().contains((Object)((DNode)createdElement).getActualMapping())) continue;
            Rectangle bounds = PortLayoutHelper.getBounds(this, (DNode)createdElement, viewDescriptor, (DDiagramElement)containerSemanticElement);
            viewDescriptor.setPersisted(true);
            compositeCommand.compose((IUndoableOperation)new SetBoundsCommand(this.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, bounds));
            compositeCommand.compose((IUndoableOperation)SiriusLayoutDataManager.INSTANCE.getAddAdapterMakerCommand(this.getEditingDomain(), (IAdaptable)viewDescriptor));
        }
        LayoutUtils.releaseDummys(this.getBorderedFigure().getBorderItemContainer());
        return new ICommandProxy(compositeCommand.reduce());
    }

    protected Command getResizeBorderItemCommand(ChangeBoundsRequest request) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        boolean valid = true;
        EObject semanticElement = this.resolveSemanticElement();
        ResizeValidator resizeValidator = new ResizeValidator(request);
        valid = resizeValidator.validate();
        if (valid && this.getMetamodelType().isInstance(semanticElement)) {
            for (Object next : request.getEditParts()) {
                DNode viewNode;
                boolean collapsed;
                IGraphicalEditPart graphicalEditPart;
                EObject semantic;
                if (!(next instanceof IGraphicalEditPart) || !((semantic = (graphicalEditPart = (IGraphicalEditPart)next).resolveSemanticElement()) instanceof DNode)) continue;
                Dimension dimension = new Dimension();
                Point position = new Point();
                if (graphicalEditPart.getNotationView() instanceof Node && ((Node)graphicalEditPart.getNotationView()).getLayoutConstraint() instanceof Size) {
                    Size size = (Size)((Node)graphicalEditPart.getNotationView()).getLayoutConstraint();
                    dimension.width = size.getWidth();
                    dimension.height = size.getHeight();
                }
                if (graphicalEditPart.getNotationView() instanceof Node && ((Node)graphicalEditPart.getNotationView()).getLayoutConstraint() instanceof Location) {
                    Location location = (Location)((Node)graphicalEditPart.getNotationView()).getLayoutConstraint();
                    position.x = location.getX();
                    position.y = location.getY();
                }
                if (!((collapsed = new DDiagramElementQuery((DDiagramElement)(viewNode = (DNode)semantic)).isIndirectlyCollapsed()) || viewNode.getResizeKind() != ResizeKind.NSEW_LITERAL && viewNode.getResizeKind() != ResizeKind.NORTH_SOUTH_LITERAL)) {
                    dimension.height = (int)((double)dimension.height + (double)request.getSizeDelta().height / this.getZoomManager().getZoom());
                    switch (request.getResizeDirection()) {
                        case 1: 
                        case 9: 
                        case 17: {
                            position.y = (int)((double)position.y - (double)request.getSizeDelta().height / this.getZoomManager().getZoom());
                            break;
                        }
                    }
                }
                if (!(collapsed || viewNode.getResizeKind() != ResizeKind.NSEW_LITERAL && viewNode.getResizeKind() != ResizeKind.EAST_WEST_LITERAL)) {
                    dimension.width = (int)((double)dimension.width + (double)request.getSizeDelta().width / this.getZoomManager().getZoom());
                    switch (request.getResizeDirection()) {
                        case 8: 
                        case 9: 
                        case 12: {
                            position.x = (int)((double)position.x - (double)request.getSizeDelta().width / this.getZoomManager().getZoom());
                            break;
                        }
                    }
                }
                SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "Resize", (IAdaptable)new EObjectAdapter((EObject)graphicalEditPart.getNotationView()), new Rectangle(position, dimension));
                cmd = new ICommandProxy((ICommand)setBoundsCommand);
            }
        }
        return cmd;
    }

    @Override
    public void refreshFigure() {
        DiagramNodeEditPartOperation.refreshFigure(this);
    }

    protected void setBackgroundColor(Color color) {
        if (this.bgColor != color) {
            this.bgColor = color;
            super.setBackgroundColor(color);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        DiagramNodeEditPartOperation.refreshVisuals(this);
    }

    protected void refreshFont() {
        super.refreshFont();
        DiagramNodeEditPartOperation.refreshFont(this);
    }

    protected void performDirectEditRequest(Request request) {
        if (this.getChildren().isEmpty() || !(this.getChildren().get(0) instanceof IDiagramNameEditPart) || this.getNodeLabel() == null) {
            DefaultDirectEditOperation.performDirectEditRequest(this, request, this.getNodeLabel());
        } else {
            super.performDirectEditRequest(request);
        }
    }

    public void performRequest(Request request) {
        if (request instanceof DirectEditRequest || "direct edit".equals(request.getType())) {
            this.performDirectEditRequest(request);
        } else {
            super.performRequest(request);
        }
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ConnectionAnchor result = null;
        if (request instanceof CreateConnectionRequest && this.getMainFigure() instanceof AirDefaultSizeNodeFigure) {
            AnchorProvider anchorProvider;
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            StyleConfiguration configuration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(this.resolveDiagramElement().getDiagramElementMapping(), this.resolveDiagramElement().getStyle());
            if (configuration != null && createConnectionRequest.getLocation() != null && (anchorProvider = configuration.getAnchorProvider()) != null) {
                result = ((AirDefaultSizeNodeFigure)this.getMainFigure()).createAnchor(anchorProvider, new PrecisionPoint(createConnectionRequest.getLocation()));
            }
        }
        if (result == null && request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("sourceConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("sourceConnectionAnchorLocation");
                result = this.getNodeFigure().getSourceConnectionAnchorAt(realLocation);
            }
        }
        if (result != null) {
            return result;
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        ConnectionAnchor result = null;
        if (request instanceof CreateConnectionRequest && this.getMainFigure() instanceof AirDefaultSizeNodeFigure && !(((CreateConnectionRequest)request).getSourceEditPart() instanceof NoteEditPart)) {
            AnchorProvider anchorProvider;
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            StyleConfiguration configuration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(this.resolveDiagramElement().getDiagramElementMapping(), this.resolveDiagramElement().getStyle());
            if (configuration != null && createConnectionRequest.getLocation() != null && (anchorProvider = configuration.getAnchorProvider()) != null) {
                result = ((AirDefaultSizeNodeFigure)this.getMainFigure()).createAnchor(anchorProvider, new PrecisionPoint(createConnectionRequest.getLocation()));
            }
        }
        if (result == null && request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("targetConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("targetConnectionAnchorLocation");
                result = this.getNodeFigure().getTargetConnectionAnchorAt(realLocation);
            }
        }
        if (result != null) {
            return result;
        }
        return super.getTargetConnectionAnchor(request);
    }

    public Command getCommand(Request request) {
        UnexecutableCommand result = null;
        RequestQuery requestQuery = new RequestQuery(request);
        if (requestQuery.isNoteCreationRequest() || requestQuery.isTextCreationRequest() || requestQuery.isNoteDropRequest() || requestQuery.isTextDropRequest()) {
            result = UnexecutableCommand.INSTANCE;
        } else {
            Command selectionCmd = CommonEditPartOperation.appendSelectionCommand(super.getCommand(request), (GraphicalEditPart)this);
            result = CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, selectionCmd);
        }
        return result;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        SpecificBorderItemSelectionEditPolicy result = new SpecificBorderItemSelectionEditPolicy();
        ResizableEditPolicy ep = (ResizableEditPolicy)result;
        DDiagramElement dde = this.resolveDiagramElement();
        if (dde instanceof DNode) {
            DiagramNodeEditPartOperation.updateResizeKind(ep, (DNode)dde);
        }
        return result;
    }

    public DragTracker getDragTracker(Request request) {
        return new NoCopyDragEditPartsTrackerEx((EditPart)this);
    }
}

