/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.view;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.ConnectorStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.business.internal.view.AbstractEdgeLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLabelLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;

public class EdgeLayoutData
extends AbstractEdgeLayoutData {
    private PointList pointList;
    private String sourceTerminal;
    private Point sourceRefPoint;
    private String targetTerminal;
    private Point targetRefPoint;
    private Routing routing;
    private EdgeLabelLayoutData edgeLabelLayoutData;
    private LayoutData edgeSourceLayoutData;
    private LayoutData edgeTargetLayoutData;

    public EdgeLayoutData(LayoutData parent, DEdge target, Edge gmfEdge) {
        super(parent, target, gmfEdge);
    }

    public EdgeLayoutData(LayoutData edgeSourceLayoutData, LayoutData edgeTargetLayoutData) {
        super(null, null, null);
        this.edgeSourceLayoutData = edgeSourceLayoutData;
        this.edgeTargetLayoutData = edgeTargetLayoutData;
    }

    @Override
    protected void init(Edge gmfEdge) {
        ConnectionEditPart connectionEditPart;
        ConnectorStyle connectorStyle = (ConnectorStyle)gmfEdge.getStyle(NotationPackage.eINSTANCE.getConnectorStyle());
        if (connectorStyle != null) {
            this.routing = connectorStyle.getRouting();
        }
        if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
            this.sourceTerminal = ((IdentityAnchor)gmfEdge.getSourceAnchor()).getId();
        }
        if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
            this.targetTerminal = ((IdentityAnchor)gmfEdge.getTargetAnchor()).getId();
        }
        if ((connectionEditPart = (ConnectionEditPart)this.getRoot().getViewer().getEditPartRegistry().get(gmfEdge)) != null) {
            PolylineConnectionEx polylineConnectionEx = (PolylineConnectionEx)connectionEditPart.getFigure();
            polylineConnectionEx.getConnectionRouter().route((Connection)polylineConnectionEx);
            this.sourceRefPoint = polylineConnectionEx.getSourceAnchor().getReferencePoint();
            polylineConnectionEx.translateToRelative((Translatable)this.sourceRefPoint);
            this.targetRefPoint = polylineConnectionEx.getTargetAnchor().getReferencePoint();
            polylineConnectionEx.translateToRelative((Translatable)this.targetRefPoint);
            this.pointList = polylineConnectionEx.getPoints().getCopy();
            this.pointList.translate(this.getRoot().getMoveDelta());
            this.sourceRefPoint.translate(this.getRoot().getMoveDelta());
            this.targetRefPoint.translate(this.getRoot().getMoveDelta());
        }
        this.edgeLabelLayoutData = new EdgeLabelLayoutData(this.getParent(), this.getTarget(), gmfEdge);
    }

    public EdgeLayoutData getData(DEdge edge) {
        return !this.isConsume() && this.getTarget().equals(edge) ? this : null;
    }

    public PointList getPointList() {
        return this.pointList;
    }

    public Point getSourceRefPoint() {
        return this.sourceRefPoint;
    }

    public Point getTargetRefPoint() {
        return this.targetRefPoint;
    }

    public Routing getRouting() {
        return this.routing;
    }

    public String getSourceTerminal() {
        return this.sourceTerminal;
    }

    public String getTargetTerminal() {
        return this.targetTerminal;
    }

    public EdgeLabelLayoutData getEdgeLabelLayoutData() {
        return this.edgeLabelLayoutData;
    }

    @Override
    protected boolean isConsume() {
        return super.isConsume() && this.getEdgeLabelLayoutData().isConsume();
    }

    public LayoutData getEdgeSourceLayoutData() {
        return this.edgeSourceLayoutData;
    }

    public LayoutData getEdgeTargetLayoutData() {
        return this.edgeTargetLayoutData;
    }

    public void setPointList(PointList pointList) {
        this.pointList = pointList;
    }

    public void setSourceTerminal(String sourceTerminal) {
        this.sourceTerminal = sourceTerminal;
    }

    public void setSourceRefPoint(Point sourceRefPoint) {
        this.sourceRefPoint = sourceRefPoint;
    }

    public void setTargetTerminal(String targetTerminal) {
        this.targetTerminal = targetTerminal;
    }

    public void setTargetRefPoint(Point targetRefPoint) {
        this.targetRefPoint = targetRefPoint;
    }

    public void setRouting(Routing routing) {
        this.routing = routing;
    }
}

