/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.migration.AbstractRepresentationsFileMigrationParticipant;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.business.api.query.DDiagramGraphicalQuery;
import org.eclipse.sirius.diagram.ui.business.internal.migration.DiagramRepresentationsFileMigrationParticipantV650;
import org.eclipse.sirius.diagram.ui.business.internal.migration.DiagramRepresentationsFileMigrationParticipantV670;
import org.eclipse.sirius.diagram.ui.business.internal.migration.DiagramRepresentationsFileMigrationParticipantV680;
import org.eclipse.sirius.diagram.ui.business.internal.migration.DiagramRepresentationsFileMigrationParticipantV690;
import org.eclipse.sirius.diagram.ui.business.internal.migration.DiagramRepresentationsFileMigrationParticipantV700;
import org.eclipse.sirius.diagram.ui.business.internal.migration.DiagramRepresentationsFileMigrationParticipantV801;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.osgi.framework.Version;

public class DiagramRepresentationsFileMigrationParticipant
extends AbstractRepresentationsFileMigrationParticipant {
    private static final Version MIGRATION_VERSION = DiagramRepresentationsFileMigrationParticipantV801.MIGRATION_VERSION;
    private static final Version ALREADY_MIGRATED_VERSION = new Version("6.5.3");
    private static final Version NOT_MIGRATED_VERSION = new Version("6.6.0");

    public void postLoad(DAnalysis dAnalysis, Version loadedVersion) {
        List<Diagram> diagrams;
        List<Diagram> diagramsToMove;
        super.postLoad(dAnalysis, loadedVersion);
        if (loadedVersion.compareTo(DiagramRepresentationsFileMigrationParticipantV650.MIGRATION_VERSION) < 0 && !(diagramsToMove = DiagramRepresentationsFileMigrationParticipantV650.getDiagramsAtRoot(dAnalysis)).isEmpty()) {
            new DiagramRepresentationsFileMigrationParticipantV650().moveGMFDiagramsFromRoot(dAnalysis, diagramsToMove);
        }
        if (!(loadedVersion.compareTo(DiagramRepresentationsFileMigrationParticipantV670.MIGRATION_VERSION) >= 0 || loadedVersion.compareTo(ALREADY_MIGRATED_VERSION) >= 0 && loadedVersion.compareTo(NOT_MIGRATED_VERSION) < 0 || (diagrams = this.getGMFDiagrams(dAnalysis)).isEmpty())) {
            DiagramRepresentationsFileMigrationParticipantV670 diagramRepresentationsFileMigrationParticipantV670 = new DiagramRepresentationsFileMigrationParticipantV670();
            diagramRepresentationsFileMigrationParticipantV670.migrateLabelConstraintFromBoundsToLocation(diagrams);
            diagramRepresentationsFileMigrationParticipantV670.migrateGMFBoundsOfBorderedNodes(diagrams);
        }
        if (loadedVersion.compareTo(DiagramRepresentationsFileMigrationParticipantV680.MIGRATION_VERSION) < 0 && !(diagrams = this.getGMFDiagrams(dAnalysis)).isEmpty()) {
            DiagramRepresentationsFileMigrationParticipantV680 diagramRepresentationsFileMigrationParticipantV680 = new DiagramRepresentationsFileMigrationParticipantV680();
            diagramRepresentationsFileMigrationParticipantV680.migrateCompartmentsWithLayoutConstraints(diagrams);
            diagramRepresentationsFileMigrationParticipantV680.migrateEdgeLabelLocationToBounds(diagrams);
        }
        if (loadedVersion.compareTo(DiagramRepresentationsFileMigrationParticipantV690.MIGRATION_VERSION) < 0) {
            diagrams = this.getGMFDiagrams(dAnalysis);
            DiagramRepresentationsFileMigrationParticipantV690 diagramRepresentationsFileMigrationParticipantV690 = new DiagramRepresentationsFileMigrationParticipantV690();
            diagramRepresentationsFileMigrationParticipantV690.migrateEdgeRoutingStyle(this.getGMFDiagrams(dAnalysis));
            diagramRepresentationsFileMigrationParticipantV690.migrateVisibilityInconsistenciesBetweenGMFNodeAndDDiagramElement(diagrams);
        }
        if (loadedVersion.compareTo(DiagramRepresentationsFileMigrationParticipantV801.MIGRATION_VERSION) < 0 && !(diagrams = this.getGMFDiagrams(dAnalysis)).isEmpty()) {
            new DiagramRepresentationsFileMigrationParticipantV801().migrateLabelVisibilityInconsistency(diagrams);
        }
    }

    public Version getMigrationVersion() {
        return MIGRATION_VERSION;
    }

    public List<Diagram> getGMFDiagrams(DAnalysis dAnalysis) {
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        for (DView view : dAnalysis.getOwnedViews()) {
            for (DRepresentation representation : view.getOwnedRepresentations()) {
                DDiagramGraphicalQuery query;
                Option<Diagram> option;
                if (!(representation instanceof DDiagram) || !(option = (query = new DDiagramGraphicalQuery((DDiagram)representation)).getAssociatedGMFDiagram()).some()) continue;
                diagrams.add((Diagram)option.get());
            }
        }
        return diagrams;
    }

    public EClassifier getType(EPackage ePackage, String name, String loadedVersion) {
        DiagramRepresentationsFileMigrationParticipantV690 representationsFileMigrationParticipantV690;
        EClassifier classifier;
        if (Version.parseVersion((String)loadedVersion).compareTo(DiagramRepresentationsFileMigrationParticipantV690.MIGRATION_VERSION) < 0 && (classifier = (representationsFileMigrationParticipantV690 = new DiagramRepresentationsFileMigrationParticipantV690()).getType(ePackage, name)) != null) {
            return classifier;
        }
        return super.getType(ePackage, name, loadedVersion);
    }

    public Object getValue(EObject object, EStructuralFeature feature, Object value, String loadedVersion) {
        DiagramRepresentationsFileMigrationParticipantV700 representationsFileMigrationParticipantV700;
        Object result;
        if (Version.parseVersion((String)loadedVersion).compareTo(DiagramRepresentationsFileMigrationParticipantV700.MIGRATION_VERSION) < 0 && (result = (representationsFileMigrationParticipantV700 = new DiagramRepresentationsFileMigrationParticipantV700()).getValue(object, feature, value)) != null) {
            return result;
        }
        return super.getValue(object, feature, value, loadedVersion);
    }
}

