/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.dialect;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.swt.graphics.Image;

public class HierarchyLabelProvider
extends LabelProvider {
    private static final String DELIMITER = " > ";
    private ILabelProvider wrappedProvider;

    public HierarchyLabelProvider(ILabelProvider wrappedLabelProvider) {
        this.wrappedProvider = wrappedLabelProvider;
    }

    public Image getImage(Object element) {
        return this.wrappedProvider != null ? this.wrappedProvider.getImage(element) : super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof EObject && this.isClassOfDescriptionPackageOrSubPackage(((EObject)element).eClass())) {
            EObject eObject = (EObject)element;
            String text = this.getLabel(eObject);
            EObject container = eObject.eContainer();
            while (container != null) {
                text = String.valueOf(this.getLabel(container)) + DELIMITER + text;
                container = container.eContainer();
            }
            return text;
        }
        return this.wrappedProvider != null ? this.wrappedProvider.getText(element) : super.getText(element);
    }

    private boolean isClassOfDescriptionPackageOrSubPackage(EClass eClass) {
        boolean isClassOfDescriptionPackageOrSubPackage = false;
        EPackage ePackage = eClass.getEPackage();
        while (!isClassOfDescriptionPackageOrSubPackage && ePackage != null) {
            isClassOfDescriptionPackageOrSubPackage = ePackage == DescriptionPackage.eINSTANCE;
            ePackage = ePackage.getESuperPackage();
        }
        return isClassOfDescriptionPackageOrSubPackage;
    }

    private String getLabel(EObject eObject) {
        String label = "Element whithout name";
        label = eObject instanceof IdentifiedElement ? new IdentifiedElementQuery((IdentifiedElement)eObject).getLabel() : (eObject instanceof RepresentationExtensionDescription ? ((RepresentationExtensionDescription)eObject).getName() : this.wrappedProvider.getText((Object)eObject));
        return label;
    }
}

