/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.command;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.description.tool.ReconnectionKind;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.ext.base.Option;

public class SiriusSetConnectionAnchorsCommand
extends SetConnectionAnchorsCommand {
    private List<Edge> reconnectionTargetEdges;
    private View reconnectionTarget;
    private ReconnectionKind reconnectionKind;

    public SiriusSetConnectionAnchorsCommand(TransactionalEditingDomain editingDomain, String label, View reconnectionTarget, List<Edge> reconnectionTargetEdges, ReconnectionKind reconnectionKind) {
        super(editingDomain, label);
        this.reconnectionTarget = reconnectionTarget;
        this.reconnectionTargetEdges = new ArrayList<Edge>(reconnectionTargetEdges);
        assert (reconnectionKind == ReconnectionKind.RECONNECT_SOURCE_LITERAL || reconnectionKind == ReconnectionKind.RECONNECT_TARGET_LITERAL) : "reconnectionKind must be ReconnectionKind.RECONNECT_SOURCE or ReconnectionKind.RECONNECT_TARGET";
        this.reconnectionKind = reconnectionKind;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult commandResult = CommandResult.newOKCommandResult();
        if (this.getEdgeAdaptor() != null) {
            commandResult = super.doExecuteWithResult(progressMonitor, info);
        } else {
            Edge edge = this.getEdge();
            assert (edge != null) : "Null edge in SetConnectionAnchorsCommand";
            if (edge == null) {
                String message = "The semantic model was not correctly updated by the reconnect tool, the diagram part of the reconnect cannot be done";
                commandResult = CommandResult.newErrorCommandResult((String)message);
                DiagramPlugin.getDefault().logWarning(message);
            } else {
                Option<IdentityAnchor> optionalSourceBortherAnchor = new EdgeQuery(edge).getSourceAnchorOfFirstBrotherWithSameSource();
                if (optionalSourceBortherAnchor.some()) {
                    this.setNewSourceTerminal(((IdentityAnchor)optionalSourceBortherAnchor.get()).getId());
                }
                this.updateSourceAnchor(edge);
                Option<IdentityAnchor> optionalTargetBortherAnchor = new EdgeQuery(edge).getTargetAnchorOfFirstBrotherWithSameTarget();
                if (optionalTargetBortherAnchor.some()) {
                    this.setNewTargetTerminal(((IdentityAnchor)optionalTargetBortherAnchor.get()).getId());
                }
                this.updateTargetAnchor(edge);
            }
        }
        return commandResult;
    }

    private void updateSourceAnchor(Edge edge) {
        if (this.getNewSourceTerminal() != null) {
            if (this.getNewSourceTerminal().length() == 0) {
                edge.setSourceAnchor(null);
            } else {
                IdentityAnchor a = (IdentityAnchor)edge.getSourceAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(this.getNewSourceTerminal());
                edge.setSourceAnchor((Anchor)a);
            }
        }
    }

    private void updateTargetAnchor(Edge edge) {
        if (this.getNewTargetTerminal() != null) {
            if (this.getNewTargetTerminal().length() == 0) {
                edge.setTargetAnchor(null);
            } else {
                IdentityAnchor a = (IdentityAnchor)edge.getTargetAnchor();
                if (a == null) {
                    a = NotationFactory.eINSTANCE.createIdentityAnchor();
                }
                a.setId(this.getNewTargetTerminal());
                edge.setTargetAnchor((Anchor)a);
            }
        }
    }

    private Edge getEdge() {
        Edge edge = null;
        if (this.reconnectionKind == ReconnectionKind.RECONNECT_SOURCE_LITERAL) {
            final ArrayList sourceEdges = new ArrayList(this.reconnectionTarget.getSourceEdges());
            Iterables.removeAll(sourceEdges, this.reconnectionTargetEdges);
            Predicate<Edge> notToReconnectingEdge = new Predicate<Edge>(){

                public boolean apply(Edge input) {
                    return !sourceEdges.contains(input.getTarget());
                }
            };
            if (sourceEdges.isEmpty() && this.reconnectionTarget.getElement() instanceof AbstractDNode) {
                AbstractDNode abstractDNode = (AbstractDNode)this.reconnectionTarget.getElement();
                EList borderedNodes = abstractDNode.getOwnedBorderedNodes();
                if (!borderedNodes.isEmpty()) {
                    DNode borderedNode = (DNode)borderedNodes.get(borderedNodes.size() - 1);
                    Collection inverseReferences = new EObjectQuery((EObject)borderedNode).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
                    Node nodeSource = (Node)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)inverseReferences, Node.class));
                    ArrayList sourceEdgesOfBorderedNode = new ArrayList(nodeSource.getSourceEdges());
                    edge = (Edge)Iterables.getOnlyElement((Iterable)Iterables.filter(sourceEdgesOfBorderedNode, (Predicate)notToReconnectingEdge));
                }
            } else {
                edge = (Edge)Iterables.getOnlyElement((Iterable)Iterables.filter(sourceEdges, (Predicate)notToReconnectingEdge));
            }
        } else {
            final ArrayList targetEdges = new ArrayList(this.reconnectionTarget.getTargetEdges());
            Iterables.removeAll(targetEdges, this.reconnectionTargetEdges);
            Predicate<Edge> notFromReconnectingEdge = new Predicate<Edge>(){

                public boolean apply(Edge input) {
                    return !targetEdges.contains(input.getSource());
                }
            };
            if (targetEdges.isEmpty() && this.reconnectionTarget.getElement() instanceof AbstractDNode) {
                AbstractDNode abstractDNode = (AbstractDNode)this.reconnectionTarget.getElement();
                EList borderedNodes = abstractDNode.getOwnedBorderedNodes();
                if (!borderedNodes.isEmpty()) {
                    DNode borderedNode = (DNode)borderedNodes.get(borderedNodes.size() - 1);
                    Collection inverseReferences = new EObjectQuery((EObject)borderedNode).getInverseReferences(NotationPackage.eINSTANCE.getView_Element());
                    Node nodeTarget = (Node)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)inverseReferences, Node.class));
                    ArrayList targetEdgesOfBorderedNode = new ArrayList(nodeTarget.getTargetEdges());
                    edge = (Edge)Iterables.getOnlyElement((Iterable)Iterables.filter(targetEdgesOfBorderedNode, (Predicate)notFromReconnectingEdge));
                }
            } else {
                edge = (Edge)Iterables.getOnlyElement((Iterable)Iterables.filter(targetEdges, (Predicate)notFromReconnectingEdge));
            }
        }
        return edge;
    }
}

