/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.query;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class ViewQuery {
    public static final Set<EAttribute> CUSTOMIZABLE_GMF_EXCLUSIVE_STYLE_ATTRIBUTES = new LinkedHashSet<EAttribute>();
    public static final Set<EAttribute> CUSTOMIZABLE_GMF_STYLE_ATTRIBUTES = new LinkedHashSet<EAttribute>();
    protected View view;

    static {
        for (EClassifier notationEClassifier : NotationPackage.eINSTANCE.getEClassifiers()) {
            EClass notationEClass;
            if (!(notationEClassifier instanceof EClass) || !NotationPackage.Literals.STYLE.isSuperTypeOf(notationEClass = (EClass)notationEClassifier)) continue;
            for (EAttribute eAttribute : notationEClass.getEAttributes()) {
                if (eAttribute == NotationPackage.Literals.DESCRIPTION_STYLE__DESCRIPTION) continue;
                if (!ViewQuery.isStylePropertyExistingInSiriusStyleModel(eAttribute)) {
                    CUSTOMIZABLE_GMF_EXCLUSIVE_STYLE_ATTRIBUTES.add(eAttribute);
                }
                CUSTOMIZABLE_GMF_STYLE_ATTRIBUTES.add(eAttribute);
            }
        }
    }

    public ViewQuery(View view) {
        this.view = view;
    }

    private static boolean isStylePropertyExistingInSiriusStyleModel(EAttribute eAttribute) {
        boolean isStylePropertyExistingInSiriusStyleModel = eAttribute == NotationPackage.Literals.FONT_STYLE__BOLD || eAttribute == NotationPackage.Literals.FONT_STYLE__ITALIC || eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_COLOR || eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_HEIGHT || eAttribute == NotationPackage.Literals.FILL_STYLE__FILL_COLOR || eAttribute == NotationPackage.Literals.ROUTING_STYLE__ROUTING || eAttribute == NotationPackage.Literals.LINE_STYLE__LINE_COLOR;
        return isStylePropertyExistingInSiriusStyleModel;
    }

    public boolean isCustomized() {
        boolean isCustomized = false;
        for (Object obj : this.view.getStyles()) {
            if (!(obj instanceof Style)) continue;
            Style style = (Style)obj;
            for (EAttribute eAttribute : style.eClass().getEAllAttributes()) {
                if (!CUSTOMIZABLE_GMF_EXCLUSIVE_STYLE_ATTRIBUTES.contains(eAttribute)) continue;
                Object currentValue = style.eGet((EStructuralFeature)eAttribute);
                Object defaultValue = this.getDefaultValue(eAttribute);
                if ((currentValue == null || currentValue.equals(defaultValue)) && (currentValue != null || defaultValue == null)) continue;
                isCustomized = true;
                break;
            }
            if (isCustomized) break;
        }
        if (!isCustomized && (this.view instanceof Shape || this.view instanceof Connector)) {
            for (EAttribute eAttribute : this.view.eClass().getEAllAttributes()) {
                if (!NotationPackage.Literals.STYLE.isSuperTypeOf(eAttribute.getEContainingClass()) || !CUSTOMIZABLE_GMF_STYLE_ATTRIBUTES.contains(eAttribute)) continue;
                Object currentValue = this.view.eGet((EStructuralFeature)eAttribute);
                Object defaultValue = this.getDefaultValue(eAttribute);
                if ((currentValue == null || currentValue.equals(defaultValue)) && (currentValue != null || defaultValue == null)) continue;
                isCustomized = true;
                break;
            }
        }
        return isCustomized;
    }

    public Object getDefaultValue(EAttribute eAttribute) {
        Object defaultValue = null;
        IPreferenceStore preferenceStore = (IPreferenceStore)DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT.getPreferenceStore();
        if (eAttribute == NotationPackage.Literals.FONT_STYLE__BOLD) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = (fontData.getStyle() & 1) != 0;
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__ITALIC) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = (fontData.getStyle() & 2) != 0;
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_COLOR) {
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.fontColor");
            defaultValue = (int)FigureUtilities.RGBToInteger((RGB)fontRGB);
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_NAME) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = fontData.getName();
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_NAME) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = fontData.getName();
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_HEIGHT) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = fontData.getHeight();
        } else if (eAttribute == NotationPackage.Literals.LINE_STYLE__LINE_COLOR) {
            RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.lineColor");
            if (ViewType.NOTE.equals(this.view.getType())) {
                lineRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.noteLineColor");
            }
            defaultValue = (int)FigureUtilities.RGBToInteger((RGB)lineRGB);
        } else if (eAttribute == NotationPackage.Literals.FILL_STYLE__FILL_COLOR) {
            RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.fillColor");
            if (ViewType.NOTE.equals(this.view.getType())) {
                fillRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.noteFillColor");
            }
            defaultValue = (int)FigureUtilities.RGBToInteger((RGB)fillRGB);
        } else if (eAttribute == NotationPackage.Literals.FILL_STYLE__TRANSPARENCY) {
            defaultValue = eAttribute.getDefaultValue();
            if (ViewType.NOTE.equals(this.view.getType())) {
                defaultValue = 0;
            }
        } else if (eAttribute == NotationPackage.Literals.LINE_STYLE__LINE_WIDTH) {
            defaultValue = eAttribute.getDefaultValue();
            if (ViewType.NOTE.equals(this.view.getType())) {
                defaultValue = 1;
            }
        } else {
            defaultValue = eAttribute.getDefaultValue();
        }
        return defaultValue;
    }

    public boolean isForNameEditPart() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        boolean result = type == 5002 || type == 5001 || type == 5003;
        result = result || type == 5010;
        result = result || type == 5006 || type == 5005;
        result = result || type == 5007 || type == 5004;
        result = result || type == 6001 || type == 6003;
        result = result || type == 6002;
        return result;
    }

    public boolean isForEdgeNameEditPart() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        boolean result = type == 6001;
        result = result || type == 6003;
        result = result || type == 6002;
        return result;
    }

    public boolean isForNameEditPartOnBorder() {
        DStylizable dStylizable;
        boolean result = false;
        if (this.isForNameEditPart() && this.view.getElement() instanceof DStylizable && (dStylizable = (DStylizable)this.view.getElement()).getStyle() instanceof NodeStyle && LabelPosition.BORDER_LITERAL.equals((Object)((NodeStyle)dStylizable.getStyle()).getLabelPosition())) {
            result = true;
        }
        return result;
    }
}

