/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.clipboard.IClipboardAdditionalData;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.DiagramsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.InsertDiagramCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;

public class DiagramPasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    protected static final String DIAGRAM_WITH_NO_OWNER = "DIAGRAM_WITH_NO_OWNER";
    private static IPasteStrategy instance = new DiagramPasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    @Override
    public String getLabel() {
        return "Diagram Strategy";
    }

    @Override
    public String getID() {
        return "org.eclipse.papyrus.infra.gmfdiag.common.DiagramStrategy";
    }

    @Override
    public String getDescription() {
        return "Copy Diagrams in model explorer";
    }

    @Override
    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        CompoundCommand compoundCommand = new CompoundCommand("Copy all Diagrams");
        Map internalClipboardToTargetCopy = papyrusClipboard.getInternalClipboardToTargetCopy();
        Map additionalDataMap = papyrusClipboard.getAdditionalDataForStrategy(this.getID());
        if (additionalDataMap != null) {
            Object additionalData = additionalDataMap.get(DIAGRAM_WITH_NO_OWNER);
            if (additionalData instanceof DiagramClipboardAdditionalData) {
                DiagramClipboardAdditionalData diagramClipboardAdditionnalData = (DiagramClipboardAdditionalData)additionalData;
                Collection<Diagram> duplicateDiagrams = diagramClipboardAdditionnalData.getDuplicatedDiagrams(internalClipboardToTargetCopy);
                for (Diagram diagram : duplicateDiagrams) {
                    InsertDiagramCommand command = new InsertDiagramCommand((TransactionalEditingDomain)domain, "Insert a diagram with no source owner", diagram, targetOwner);
                    compoundCommand.append((Command)command);
                }
            }
            for (Object object : papyrusClipboard) {
                EObject target = papyrusClipboard.getTragetCopyFromInternalClipboardCopy(object);
                if (target == null || !(target instanceof EObject) || !((additionalData = additionalDataMap.get(object)) instanceof DiagramClipboardAdditionalData)) continue;
                DiagramClipboardAdditionalData diagramClipboardAdditionalData = (DiagramClipboardAdditionalData)additionalData;
                Collection<Diagram> diagrams = diagramClipboardAdditionalData.getDuplicatedDiagrams(internalClipboardToTargetCopy);
                for (Diagram diagram : diagrams) {
                    InsertDiagramCommand command = new InsertDiagramCommand((TransactionalEditingDomain)domain, "InsertDiagramCommand", diagram, target);
                    compoundCommand.append((Command)command);
                }
            }
        }
        if (compoundCommand.getCommandList().isEmpty()) {
            return null;
        }
        return compoundCommand;
    }

    @Override
    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    @Override
    public void prepare(PapyrusClipboard<Object> papyrusClipboard, Collection<EObject> selection) {
        HashMap<Object, DiagramClipboardAdditionalData> mapCopyToClipboardAdditionalData = new HashMap<Object, DiagramClipboardAdditionalData>();
        Map sourceToInternalClipboard = papyrusClipboard.getSourceToInternalClipboard();
        List<Diagram> extractSelectedWithoutOwner = this.extractDiagramWithoutOwner(selection);
        if (extractSelectedWithoutOwner != null && !extractSelectedWithoutOwner.isEmpty()) {
            DiagramClipboardAdditionalData diagramAdditionnalData = new DiagramClipboardAdditionalData(extractSelectedWithoutOwner, sourceToInternalClipboard);
            mapCopyToClipboardAdditionalData.put(DIAGRAM_WITH_NO_OWNER, diagramAdditionnalData);
        }
        Iterator iterator = papyrusClipboard.iterateOnSource();
        while (iterator.hasNext()) {
            ResourceSet resourceSet;
            EObject eObjectSource = (EObject)iterator.next();
            List<Diagram> associatedDiagrams = DiagramsUtil.getAssociatedDiagrams(eObjectSource, resourceSet = eObjectSource.eResource().getResourceSet());
            if (associatedDiagrams == null) continue;
            DiagramClipboardAdditionalData diagramAdditionnalData = new DiagramClipboardAdditionalData(associatedDiagrams, sourceToInternalClipboard);
            Object copy = papyrusClipboard.getCopyFromSource(eObjectSource);
            mapCopyToClipboardAdditionalData.put(copy, diagramAdditionnalData);
        }
        papyrusClipboard.pushAdditionalData(this.getID(), mapCopyToClipboardAdditionalData);
    }

    protected List<Diagram> extractDiagramWithoutOwner(Collection<EObject> selection) {
        ArrayList<Diagram> diagramWithoutOwnerInSelection = new ArrayList<Diagram>();
        if (selection != null) {
            for (EObject eObject : selection) {
                Diagram diagram;
                EObject element;
                if (!(eObject instanceof Diagram) || selection.contains(element = (diagram = (Diagram)eObject).getElement())) continue;
                diagramWithoutOwnerInSelection.add(diagram);
            }
        }
        return diagramWithoutOwnerInSelection;
    }

    protected class DiagramClipboardAdditionalData
    implements IClipboardAdditionalData {
        protected Collection<Diagram> diagrams;

        public DiagramClipboardAdditionalData(Collection<Diagram> diagrams, Map<? extends EObject, ? extends EObject> alreadyCopied) {
            this.diagrams = this.duplicateDiagrams(diagrams, alreadyCopied);
        }

        public Collection<Diagram> getDuplicatedDiagrams(Map<? extends EObject, ? extends EObject> alreadyCopied) {
            return this.duplicateDiagrams(this.diagrams, alreadyCopied);
        }

        protected Collection<Diagram> duplicateDiagrams(Collection<Diagram> diagrams, Map<? extends EObject, ? extends EObject> alreadyCopied) {
            ArrayList<Diagram> duplicatedDiagrams = new ArrayList<Diagram>();
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.putAll(alreadyCopied);
            for (Diagram diagram : diagrams) {
                copier.copy((EObject)diagram);
                copier.copyReferences();
                EObject copy = (EObject)copier.get((Object)diagram);
                if (!(copy instanceof Diagram)) continue;
                duplicatedDiagrams.add((Diagram)copy);
            }
            return duplicatedDiagrams;
        }
    }
}

