/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.shape;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.SVGPostProcessor;
import org.w3c.dom.svg.SVGDocument;

public class SVGPostProcessorImpl
implements SVGPostProcessor {
    protected final List<SVGPostProcessor> processors = new LinkedList<SVGPostProcessor>();

    public SVGPostProcessorImpl() {
        this.loadPostProcessors();
    }

    protected void loadPostProcessors() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.gmfdiag.common.svgPostProcessors");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object postProcessorObject = e.createExecutableExtension("implementation");
                if (!(postProcessorObject instanceof SVGPostProcessor)) {
                    Activator.log.warn(String.format("Plug-in %s contributed an invalid SVG post-processor: %s", e.getContributor(), e.getAttribute("implementation")));
                } else {
                    this.processors.add((SVGPostProcessor)postProcessorObject);
                }
            }
            catch (Throwable t) {
                Activator.log.error(String.format("Plug-in %s contributed an invalid SVG post-processor", e.getContributor()), t);
            }
            ++n2;
        }
    }

    @Override
    public void postProcess(EObject view, SVGDocument document) {
        for (SVGPostProcessor processor : this.processors) {
            processor.postProcess(view, document);
        }
    }
}

