/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.service.shape;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.handler.IRefreshHandlerPart;
import org.eclipse.papyrus.infra.gmfdiag.common.handler.RefreshHandler;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.GetAllShapeProvidersOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.GetShapeProviderByIdentifierOperation;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.IShapeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.SVGPostProcessor;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public abstract class AbstractShapeProvider
extends AbstractProvider
implements IShapeProvider,
IRefreshHandlerPart {
    protected static final String NAME = "name";
    protected static final String ID = "id";
    protected static final String DESCRIPTION = "description";
    protected String bundleId;
    protected String name;
    protected String id;
    protected String description;
    private WeakHashMap<Resource, Map<String, String>> relativePaths;
    private Map<String, SVGDocument> cache;

    public AbstractShapeProvider() {
        RefreshHandler.register(this);
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean provides(IOperation operation) {
        return operation instanceof GetAllShapeProvidersOperation || operation instanceof GetShapeProviderByIdentifierOperation;
    }

    @Override
    public void setConfiguration(IConfigurationElement element) {
        this.name = element.getAttribute(NAME);
        this.id = element.getAttribute(ID);
        this.description = element.getAttribute(DESCRIPTION);
        this.bundleId = element.getContributor().getName();
    }

    protected synchronized SVGDocument getSVGDocument(EObject view, String location) {
        if (this.relativePaths == null) {
            this.relativePaths = new WeakHashMap();
        }
        String canonical = this.getCanonicalURI(view, location);
        return this.getSVGDocument(canonical);
    }

    protected synchronized SVGDocument getSVGDocument(String location) {
        if (this.cache == null) {
            this.cache = new HashMap<String, SVGDocument>();
        }
        if (this.cache.containsKey(location)) {
            return this.cache.get(location);
        }
        SVGDocument doc = this.doGetSVGDocument(location);
        this.cache.put(location, doc);
        return doc;
    }

    private SVGDocument doGetSVGDocument(String location) {
        int extensionIndex = location.lastIndexOf(46);
        if (extensionIndex == 0) {
            return null;
        }
        String fileExtension = location.substring(extensionIndex);
        if (!fileExtension.equalsIgnoreCase(".svg")) {
            return null;
        }
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        try {
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
            Document doc = f.createDocument(location);
            SVGDocument svgDocument = (SVGDocument)doc;
            return svgDocument;
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    private String getCanonicalURI(EObject model, String uri) {
        String canonical;
        if (uri.startsWith("platform:/")) {
            return uri;
        }
        Map<String, String> resMap = this.relativePaths.get(model.eResource());
        if (resMap == null) {
            resMap = new HashMap<String, String>();
            this.relativePaths.put(model.eResource(), resMap);
        }
        if ((canonical = resMap.get(uri)) != null) {
            return canonical;
        }
        URI resURI = model.eResource().getURI();
        if (!resURI.isPlatform()) {
            return null;
        }
        StringBuilder builder = new StringBuilder("platform:/");
        String[] segments = resURI.segments();
        int i = 0;
        while (i < segments.length - 1) {
            builder.append(segments[i]);
            builder.append("/");
            ++i;
        }
        builder.append(uri);
        canonical = builder.toString();
        resMap.put(uri, canonical);
        return canonical;
    }

    protected RenderedImage renderSVGDocument(EObject view, SVGDocument document) throws IOException {
        this.postProcess(view, document);
        String svgAsText = this.toString(document);
        byte[] buffer = svgAsText.getBytes();
        return RenderedImageFactory.getInstance((byte[])buffer);
    }

    protected void postProcess(EObject view, SVGDocument document) {
        SVGPostProcessor.instance.postProcess(view, document);
    }

    protected String toString(SVGDocument domDocument) throws IOException {
        StringWriter writer = new StringWriter();
        DOMUtilities.writeDocument((Document)domDocument, (Writer)writer);
        return writer.toString();
    }

    @Override
    public synchronized void refresh(IEditorPart editorPart) {
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.relativePaths != null) {
            this.relativePaths.clear();
        }
    }
}

