/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.model;

import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.resource.BadArgumentExcetion;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;
import org.eclipse.papyrus.infra.core.resource.IEMFModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;

public class NotationModel
extends EMFLogicalModel
implements IModel {
    public static final String NOTATION_FILE_EXTENSION = "notation";
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.core.resource.notation.NotationModel";

    protected String getModelFileExtension() {
        return NOTATION_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public void addDiagram(Diagram newDiagram) {
        this.getResource().getContents().add((Object)newDiagram);
    }

    public boolean isControlled(Resource resource) {
        for (Resource resourceInModelSet : this.modelSet.getResources()) {
            EObject eObject;
            IModel iModel;
            if (!resource.getURI().trimFileExtension().equals(resourceInModelSet.getURI().trimFileExtension()) || this.isRelatedResource(resourceInModelSet) || resourceInModelSet.getContents().isEmpty() || !((iModel = this.modelSet.getModelFor((Object)(eObject = (EObject)resourceInModelSet.getContents().get(0)))) instanceof IEMFModel) || !((IEMFModel)iModel).isControlled(resourceInModelSet)) continue;
            return true;
        }
        return false;
    }

    public void handle(Resource resource) {
        super.handle(resource);
        if (resource == null) {
            return;
        }
        if (!this.isRelatedResource(resource)) {
            URIConverter converter;
            URI notationURI = resource.getURI().trimFileExtension().appendFileExtension(NOTATION_FILE_EXTENSION);
            ResourceSet resourceSet = this.getResourceSet();
            if (resourceSet != null && resourceSet.getURIConverter() != null && (converter = resourceSet.getURIConverter()).exists(notationURI, Collections.emptyMap())) {
                this.getResourceSet().getResource(notationURI, true);
            }
        }
    }

    public Diagram getDiagram(String diagramName) throws NotFoundException, BadArgumentExcetion {
        if (diagramName == null || diagramName.length() == 0) {
            throw new BadArgumentExcetion("Diagram name should not be null and size should be >0.");
        }
        for (EObject element : this.getResource().getContents()) {
            Diagram diagram;
            if (!(element instanceof Diagram) || !diagramName.equals((diagram = (Diagram)element).getName())) continue;
            return diagram;
        }
        throw new NotFoundException("No Diagram named '" + diagramName + "' can be found in Model.");
    }
}

