/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomStringStyleObservableList;

public class MaskLabelHelper {
    public static Collection<String> getMaskValues(View view) {
        if (view.getNamedStyle(NotationPackage.eINSTANCE.getStringListValueStyle(), "maskLabel") != null) {
            CustomStringStyleObservableList values = new CustomStringStyleObservableList(view, EMFHelper.resolveEditingDomain((EObject)view), "maskLabel");
            HashSet<String> result = new HashSet<String>((Collection<String>)((Object)values));
            values.dispose();
            return result;
        }
        return null;
    }

    public static void setMaskValues(View view, Collection<String> masks) {
        CustomStringStyleObservableList values = new CustomStringStyleObservableList(view, EMFHelper.resolveEditingDomain((EObject)view), "maskLabel");
        if (!values.isEmpty()) {
            values.clear();
        }
        values.addAll(masks);
        values.commit(null);
        values.dispose();
    }

    public static void unsetMaskValues(final View view) {
        final NamedStyle style = view.getNamedStyle(NotationPackage.eINSTANCE.getStringListValueStyle(), "maskLabel");
        if (style == null) {
            return;
        }
        TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((EObject)view);
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "Restore default label configuration"){

            protected void doExecute() {
                view.getStyles().remove((Object)style);
            }
        });
    }
}

