/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.helper;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.ui.IEditorPart;

public class DiagramHelper {
    private static boolean needsRefresh = false;

    public static void refresh(EditPart editPart, boolean recursive) {
        editPart.refresh();
        if (recursive) {
            for (EditPart childEditPart : editPart.getChildren()) {
                DiagramHelper.refresh(childEditPart, true);
            }
        }
    }

    public static void refresh(DiagramEditPart diagramEditPart, boolean recursive) {
        diagramEditPart.refresh();
        if (recursive) {
            LinkedList childrenToRefresh = new LinkedList(diagramEditPart.getChildren());
            for (EditPart childEditPart : childrenToRefresh) {
                DiagramHelper.refresh(childEditPart, true);
            }
            LinkedList connectionsToRefresh = new LinkedList(diagramEditPart.getConnections());
            for (EditPart childEditPart : connectionsToRefresh) {
                DiagramHelper.refresh(childEditPart, true);
            }
        }
    }

    public static void refresh(IEditorPart editorPart) {
        List visibleEditorParts = null;
        if (editorPart instanceof IMultiDiagramEditor) {
            ServicesRegistry servicesRegistry = (ServicesRegistry)editorPart.getAdapter(ServicesRegistry.class);
            if (servicesRegistry != null) {
                try {
                    ISashWindowsContainer container = ServiceUtils.getInstance().getISashWindowsContainer((Object)servicesRegistry);
                    visibleEditorParts = container.getVisibleIEditorParts();
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        } else {
            visibleEditorParts = Collections.singletonList(editorPart);
        }
        if (visibleEditorParts != null) {
            for (IEditorPart visiblePart : visibleEditorParts) {
                DiagramEditor diagramEditor;
                DiagramEditPart topEditPart;
                if (!(visiblePart instanceof DiagramEditor) || (topEditPart = (diagramEditor = (DiagramEditor)visiblePart).getDiagramEditPart()) == null) continue;
                DiagramHelper.refresh(topEditPart, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshDiagrams() {
        Class<DiagramHelper> clazz = DiagramHelper.class;
        synchronized (DiagramHelper.class) {
            if (!needsRefresh) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            needsRefresh = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            IMultiDiagramEditor[] editors = EditorUtils.getMultiDiagramEditors();
            if (editors == null || editors.length < 1) {
                return;
            }
            IMultiDiagramEditor[] iMultiDiagramEditorArray = editors;
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IMultiDiagramEditor activeMultiEditor = iMultiDiagramEditorArray[n2];
                DiagramHelper.refresh((IEditorPart)activeMultiEditor);
                ++n2;
            }
            return;
        }
    }

    public static synchronized void setNeedsRefresh() {
        needsRefresh = true;
    }
}

