/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.handler;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.handler.IRefreshHandlerPart;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.ui.IEditorPart;

public class RefreshHandler
extends AbstractHandler {
    private static Collection<WeakReference<IRefreshHandlerPart>> PARTS = new LinkedList<WeakReference<IRefreshHandlerPart>>();

    public static synchronized void register(IRefreshHandlerPart refresher) {
        PARTS.add(new WeakReference<IRefreshHandlerPart>(refresher));
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor;
        try {
            activeEditor = (IEditorPart)ServiceUtilsForHandlers.getInstance().getService(IMultiDiagramEditor.class, (Object)event);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
        this.callRefresherHooks(activeEditor);
        DiagramHelper.refresh(activeEditor);
        return null;
    }

    private synchronized void callRefresherHooks(IEditorPart activeEditor) {
        Iterator<WeakReference<IRefreshHandlerPart>> iterator = PARTS.iterator();
        while (iterator.hasNext()) {
            WeakReference<IRefreshHandlerPart> wr = iterator.next();
            IRefreshHandlerPart part = (IRefreshHandlerPart)wr.get();
            if (part != null) {
                part.refresh(activeEditor);
                continue;
            }
            iterator.remove();
        }
    }
}

