/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.editparts.AbstractBorderEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeIconlDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.MaskManagedNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.locator.ExternalLabelPositionLocator;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.policies.CustomDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.policies.CustomGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.policies.CustomPortItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.component.custom.edit.policies.PortLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.component.custom.figure.nodes.PortFigure;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PortAppliedStereotypeEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PortNameEditPart;
import org.eclipse.papyrus.uml.diagram.component.edit.policies.PortItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.component.part.UMLVisualIDRegistry;
import org.eclipse.swt.graphics.Color;

public class PortEditPart
extends AbstractBorderEditPart {
    public static final int VISUAL_ID = 3069;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public PortEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", this.getPrimaryDragEditPolicy());
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new PortItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomPortItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new CustomGraphicalNodeEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeIconlDisplayEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PortLayoutEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new CustomDiagramDragDropEditPolicy());
        this.installEditPolicy("ConnectionLabelsPolicy", (EditPolicy)new ShowHideLabelEditPolicy());
        this.installEditPolicy("MaskManagedLabelPolicy", (EditPolicy)new MaskManagedNodeEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (UMLVisualIDRegistry.getVisualID(childView)) {
                    case 5006: 
                    case 5007: {
                        return new BorderItemSelectionEditPolicy(){

                            protected List<?> createSelectionHandles() {
                                MoveHandle mh = new MoveHandle((GraphicalEditPart)this.getHost());
                                mh.setBorder(null);
                                return Collections.singletonList(mh);
                            }
                        };
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected void handleNotificationEvent(Notification event) {
        if (NotationPackage.eINSTANCE.getView_Visible().equals(event.getFeature())) {
            Object notifier = event.getNotifier();
            EList modelChildren = ((View)this.getModel()).getChildren();
            if (!(notifier instanceof Edge) && modelChildren.contains(event.getNotifier())) {
                return;
            }
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new PortFigure();
        return this.primaryShape;
    }

    public PortFigure getPrimaryShape() {
        return (PortFigure)this.primaryShape;
    }

    protected void addBorderItem(IFigure borderItemContainer, IBorderItemEditPart borderItemEditPart) {
        if (borderItemEditPart instanceof PortAppliedStereotypeEditPart) {
            BorderItemLocator locator = new BorderItemLocator(this.getMainFigure(), 4);
            locator.setBorderItemOffset(new Dimension(-20, -20));
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else if (borderItemEditPart instanceof PortNameEditPart) {
            ExternalLabelPositionLocator locator = new ExternalLabelPositionLocator(this.getMainFigure());
            borderItemContainer.add(borderItemEditPart.getFigure(), (Object)locator);
        } else {
            super.addBorderItem(borderItemContainer, borderItemEditPart);
        }
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(20, 20);
        return result;
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof IPapyrusNodeFigure) {
            ((IPapyrusNodeFigure)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5006));
    }
}

