/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.custom.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.uml.diagram.component.custom.command.CreateLollipopPortCommand;
import org.eclipse.papyrus.uml.diagram.component.custom.ui.InterfaceManagerDialog;
import org.eclipse.papyrus.uml.diagram.component.edit.parts.PortEditPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;

public class DisplayInterfaceMDialog
extends InterfaceManagerDialog {
    protected HashSet<Interface> displayedRequiredInterface = new HashSet();
    protected HashSet<Interface> displayedProvidedInterface = new HashSet();
    protected PortEditPart portEditPart = null;
    protected HashMap<Interface, GraphicalEditPart> initialList = new HashMap();

    public DisplayInterfaceMDialog(Shell parentShell, PortEditPart portEditPart) {
        super(parentShell, (Port)portEditPart.resolveSemanticElement());
        this.portEditPart = portEditPart;
        this.selectorLabelProvider = new DisplayedSelectorLabelProvider();
        this.initDisplayInterfaceList();
    }

    protected void initDisplayInterfaceList() {
        if (this.portEditPart.getSourceConnections().size() > 0) {
            for (Object currentConnection : this.portEditPart.getSourceConnections()) {
                ConnectionEditPart connection = (ConnectionEditPart)currentConnection;
                EObjectValueStyle valueStyle = (EObjectValueStyle)((View)connection.getModel()).getStyle(NotationPackage.eINSTANCE.getEObjectValueStyle());
                if (valueStyle == null) continue;
                if (valueStyle.getName().equals("REQUIRED")) {
                    this.displayedRequiredInterface.add((Interface)((GraphicalEditPart)connection.getTarget()).resolveSemanticElement());
                } else {
                    this.displayedProvidedInterface.add((Interface)((GraphicalEditPart)connection.getTarget()).resolveSemanticElement());
                }
                this.initialList.put((Interface)((GraphicalEditPart)connection.getTarget()).resolveSemanticElement(), (GraphicalEditPart)connection.getTarget());
            }
        }
    }

    @Override
    public org.eclipse.gef.commands.Command getCommand() {
        CompoundCommand cmd = new CompoundCommand();
        org.eclipse.gef.commands.Command supCmd = super.getCommand();
        if (supCmd.canExecute()) {
            cmd.add(super.getCommand());
        }
        cmd.add(this.createDisplayedInterfaceCommand());
        return cmd;
    }

    @Override
    protected void createEditors() {
        Composite parent = (Composite)this.getDialogArea();
        Composite subComposite = new Composite(parent, 0);
        subComposite.setLayout((Layout)new FormLayout());
        Button Displaybutton = new Button(subComposite, 8);
        Displaybutton.setText("Display seletected Interface");
        DisplayInterfaceListener displayInterfaceListener = new DisplayInterfaceListener();
        Displaybutton.addSelectionListener((SelectionListener)displayInterfaceListener);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 700);
        Displaybutton.setLayoutData((Object)formData);
        Button RemoveDisplaybutton = new Button(subComposite, 8);
        RemoveDisplaybutton.setText(" Do not Display selected Interface");
        RemoveDisplayInterfaceListener removeDisplayInterfaceListener = new RemoveDisplayInterfaceListener();
        RemoveDisplaybutton.addSelectionListener((SelectionListener)removeDisplayInterfaceListener);
        formData = new FormData();
        formData.left = new FormAttachment(0, 500);
        RemoveDisplaybutton.setLayoutData((Object)formData);
        super.createEditors();
    }

    protected org.eclipse.gef.commands.Command createDisplayedInterfaceCommand() {
        HashMap<Interface, GraphicalEditPart> viewToRemove = new HashMap<Interface, GraphicalEditPart>();
        HashSet<Interface> requiredInterfaceToDisplay = new HashSet<Interface>();
        HashSet<Interface> providedInterfaceToDisplay = new HashSet<Interface>();
        for (Interface currentInterface : this.displayedProvidedInterface) {
            if (this.initialList.keySet().contains(currentInterface)) continue;
            providedInterfaceToDisplay.add(currentInterface);
        }
        for (Interface currentInterface : this.displayedRequiredInterface) {
            if (this.initialList.keySet().contains(currentInterface)) continue;
            requiredInterfaceToDisplay.add(currentInterface);
        }
        for (Interface currentInterface : this.initialList.keySet()) {
            if (this.displayedRequiredInterface.contains(currentInterface) || this.displayedProvidedInterface.contains(currentInterface)) continue;
            viewToRemove.put(currentInterface, this.initialList.get(currentInterface));
        }
        CompoundCommand cmd = new CompoundCommand();
        CreateLollipopPortCommand comd = new CreateLollipopPortCommand(this.portEditPart.getEditingDomain(), providedInterfaceToDisplay, requiredInterfaceToDisplay, this.portEditPart);
        cmd.add((org.eclipse.gef.commands.Command)new EMFtoGEFCommandWrapper((Command)comd));
        if (viewToRemove.values().size() > 0) {
            cmd.add(this.deleteDisplayInterface(viewToRemove.values()));
        }
        return cmd;
    }

    protected org.eclipse.gef.commands.Command deleteDisplayInterface(Collection<GraphicalEditPart> editPartToRemove) {
        CompoundCommand cmd = new CompoundCommand();
        GroupRequest deleteViewRequest = new GroupRequest((Object)"delete");
        for (GraphicalEditPart editPart : editPartToRemove) {
            cmd.add(editPart.getCommand((Request)deleteViewRequest));
        }
        return cmd;
    }

    class DisplayInterfaceListener
    extends SelectionAdapter {
        DisplayInterfaceListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            Object o;
            IStructuredSelection selection = (IStructuredSelection)DisplayInterfaceMDialog.this.providedEditor.getSelectedElementsViewer().getSelection();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                DisplayInterfaceMDialog.this.displayedProvidedInterface.add((Interface)o);
                ++n2;
            }
            selection = (IStructuredSelection)DisplayInterfaceMDialog.this.requiredEditor.getSelectedElementsViewer().getSelection();
            objectArray = selection.toArray();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                DisplayInterfaceMDialog.this.displayedRequiredInterface.add((Interface)o);
                ++n2;
            }
            DisplayInterfaceMDialog.this.providedEditor.getSelectedElementsViewer().refresh();
            DisplayInterfaceMDialog.this.requiredEditor.getSelectedElementsViewer().refresh();
        }
    }

    public class DisplayedSelectorLabelProvider
    extends InterfaceManagerDialog.SelectorLabelProvider {
        private static final String ICONS_OBJ16_LOLLIPOP_GIF = "icons/obj16/lollipop.gif";

        public DisplayedSelectorLabelProvider() {
            super(DisplayInterfaceMDialog.this);
        }

        protected Image getImage(EObject element) {
            if (DisplayInterfaceMDialog.this.displayedRequiredInterface.contains(element) || DisplayInterfaceMDialog.this.displayedProvidedInterface.contains(element)) {
                return Activator.getDefault().getImage("org.eclipse.papyrus.uml.diagram.component", ICONS_OBJ16_LOLLIPOP_GIF);
            }
            return super.getImage(element);
        }
    }

    class RemoveDisplayInterfaceListener
    extends SelectionAdapter {
        RemoveDisplayInterfaceListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            Object o;
            IStructuredSelection selection = (IStructuredSelection)DisplayInterfaceMDialog.this.providedEditor.getSelectedElementsViewer().getSelection();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                DisplayInterfaceMDialog.this.displayedProvidedInterface.remove((Interface)o);
                ++n2;
            }
            selection = (IStructuredSelection)DisplayInterfaceMDialog.this.requiredEditor.getSelectedElementsViewer().getSelection();
            objectArray = selection.toArray();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                DisplayInterfaceMDialog.this.displayedRequiredInterface.remove((Interface)o);
                ++n2;
            }
            DisplayInterfaceMDialog.this.providedEditor.getSelectedElementsViewer().refresh();
            DisplayInterfaceMDialog.this.requiredEditor.getSelectedElementsViewer().refresh();
        }
    }
}

