/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies.AbstractTimelineLayoutPolicy;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.LifelineUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.MessageUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.OccurrenceSpecificationUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLViewProvider;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageKind;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;

public final class DropUtils {
    private DropUtils() {
    }

    public static ICommand getDropMessageCommand(Message message, View dropTarget, EditPartViewer viewer) {
        if (message.getMessageKind() == MessageKind.LOST_LITERAL) {
            return DropUtils.getDropLostMessageCommand(message, dropTarget, viewer);
        }
        if (message.getMessageKind() == MessageKind.FOUND_LITERAL) {
            return DropUtils.getDropFoundMessageCommand(message, dropTarget, viewer);
        }
        MessageEnd sendEvent = message.getSendEvent();
        MessageEnd receiveEvent = message.getReceiveEvent();
        if (sendEvent == null || receiveEvent == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ArrayList<View> sourceViews = new ArrayList<View>(CrossReferencerUtil.getCrossReferencingViews((EObject)sendEvent, (String)"PapyrusUMLTimingDiagram"));
        ArrayList<View> targetViews = new ArrayList<View>(CrossReferencerUtil.getCrossReferencingViews((EObject)receiveEvent, (String)"PapyrusUMLTimingDiagram"));
        DropUtils.filterMessageSourceOrTargetViews(sourceViews);
        DropUtils.filterMessageSourceOrTargetViews(targetViews);
        if (sourceViews.size() != 1 || targetViews.size() != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        View sourceView = (View)sourceViews.get(0);
        View targetView = (View)targetViews.get(0);
        if (sourceView == null || sourceView.getDiagram() == null || targetView == null || targetView.getDiagram() == null) {
            return UnexecutableCommand.INSTANCE;
        }
        View interactionView = ViewUtils.findSuperViewWithId(dropTarget, 2);
        if (interactionView == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!ViewUtils.isContained(sourceView, interactionView) || !ViewUtils.isContained(targetView, interactionView)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (ViewUtils.containsConnectorFor(dropTarget, (EObject)message)) {
            return UnexecutableCommand.INSTANCE;
        }
        return DropUtils.createMessageConnectionView(message, viewer, sourceView, targetView);
    }

    private static ICommand getDropLostMessageCommand(Message message, View dropTarget, EditPartViewer viewer) {
        MessageEnd sendEvent = message.getSendEvent();
        if (sendEvent == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return DropUtils.getDropLostOrFoundMessage(message, dropTarget, viewer, sendEvent);
    }

    private static ICommand getDropFoundMessageCommand(Message message, View dropTarget, EditPartViewer viewer) {
        MessageEnd receiveEvent = message.getReceiveEvent();
        if (receiveEvent == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return DropUtils.getDropLostOrFoundMessage(message, dropTarget, viewer, receiveEvent);
    }

    private static ICommand getDropLostOrFoundMessage(Message message, View dropTarget, EditPartViewer viewer, MessageEnd endEvent) {
        List endViews = DiagramEditPartsUtil.findViews((EObject)endEvent, (EditPartViewer)viewer);
        DropUtils.filterMessageSourceOrTargetViews(endViews);
        if (endViews.size() != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        View endView = (View)endViews.get(0);
        View interactionView = ViewUtils.findSuperViewWithId(dropTarget, 2);
        View lifelineView = ViewUtils.findSuperViewWithId(endView, 19);
        if (lifelineView == null) {
            lifelineView = ViewUtils.findSuperViewWithId(endView, 20);
        }
        if (interactionView == null || lifelineView == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!ViewUtils.isContained(endView, interactionView)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (ViewUtils.containsConnectorFor(dropTarget, (EObject)message)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (message.getMessageKind() == MessageKind.LOST_LITERAL) {
            return DropUtils.createMessageConnectionView(message, viewer, endView, lifelineView);
        }
        return DropUtils.createMessageConnectionView(message, viewer, lifelineView, endView);
    }

    private static ICommand createMessageConnectionView(Message message, EditPartViewer viewer, View sourceView, View targetView) {
        IElementType elementType = MessageUtils.getElementType(message);
        String semanticHint = ((IHintedType)elementType).getSemanticHint();
        CreateConnectionViewRequest.ConnectionViewDescriptor connectionViewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)elementType, semanticHint, -1, true, PreferencesHint.USE_DEFAULTS);
        EObjectAdapter sourceViewAdapter = new EObjectAdapter((EObject)sourceView);
        EObjectAdapter targetViewAdapter = new EObjectAdapter((EObject)targetView);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)message);
        CommonDeferredCreateConnectionViewCommand createConnectionViewCommand = new CommonDeferredCreateConnectionViewCommand(editingDomain, semanticHint, (IAdaptable)sourceViewAdapter, (IAdaptable)targetViewAdapter, viewer, PreferencesHint.USE_DEFAULTS, connectionViewDescriptor, null);
        createConnectionViewCommand.setElement((EObject)message);
        return createConnectionViewCommand;
    }

    private static void filterMessageSourceOrTargetViews(List<View> views) {
        ListIterator<View> listIterator = views.listIterator();
        while (listIterator.hasNext()) {
            View view = listIterator.next();
            int visualID = UMLVisualIDRegistry.getVisualID(view);
            if (OccurrenceSpecificationUtils.isOccurrenceSpecificationEditPart(visualID) || visualID == 69) continue;
            listIterator.remove();
        }
    }

    public static ICommand getDropLinkedNodeInLifelineCommand(final EObject droppedElement, Collection<EObject> linkedElements, View dropTarget, EditPartViewer viewer, final IDropLinkedNodeInLifelineAction<? extends EObject> dropAction) {
        View interactionView = ViewUtils.findSuperViewWithId(dropTarget, 2);
        if (interactionView == null || ViewUtils.containsViewFor(interactionView, droppedElement)) {
            return UnexecutableCommand.INSTANCE;
        }
        final HashSet<View> targetLifelines = new HashSet<View>();
        for (EObject eObject : linkedElements) {
            if (!(eObject instanceof InteractionFragment)) continue;
            InteractionFragment interactionFragment = (InteractionFragment)eObject;
            EList covereds = interactionFragment.getCovereds();
            for (Lifeline lifeline : covereds) {
                List lifelineViews = DiagramEditPartsUtil.findViews((EObject)lifeline, (EditPartViewer)viewer);
                for (View lifelineView : lifelineViews) {
                    if (!LifelineUtils.isLifelineView(lifelineView) || !ViewUtils.isContained(lifelineView, interactionView)) continue;
                    targetLifelines.add(lifelineView);
                }
            }
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)interactionView);
        CompositeCommand compositeCommand = new CompositeCommand(Messages.DropUtils_DropElement);
        compositeCommand.add((IUndoableOperation)new AbstractTransactionalCommand(editingDomain, Messages.DropUtils_DropElement, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                for (View targetLifeline : targetLifelines) {
                    View compartmentView = ViewUtils.findChildTimelineCompartmentView(targetLifeline);
                    dropAction.drop(droppedElement, compartmentView);
                }
                return CommandResult.newOKCommandResult();
            }
        });
        for (View targetLifeline : targetLifelines) {
            EditPart lifelineEditPart = (EditPart)viewer.getEditPartRegistry().get(targetLifeline);
            EditPart compartmentEditPart = LifelineUtils.getLifelineCompartment(lifelineEditPart);
            compositeCommand.add((IUndoableOperation)new CommandProxy(compartmentEditPart.getCommand(AbstractTimelineLayoutPolicy.UPDATE_LAYOUT_REQUEST)));
        }
        return compositeCommand;
    }

    public static ICommand getDropTimeObservationCommand(TimeObservation timeObservation, View dropTarget, EditPartViewer viewer) {
        NamedElement event = timeObservation.getEvent();
        return DropUtils.getDropLinkedNodeInLifelineCommand((EObject)timeObservation, Collections.singletonList(event), dropTarget, viewer, new DropTimeObservationAction());
    }

    public static ICommand getDropTimeConstraintCommand(TimeConstraint timeConstraint, View dropTarget, EditPartViewer viewer) {
        ArrayList<EObject> linkedElements = new ArrayList<EObject>();
        linkedElements.addAll((Collection<EObject>)timeConstraint.getConstrainedElements());
        return DropUtils.getDropLinkedNodeInLifelineCommand((EObject)timeConstraint, linkedElements, dropTarget, viewer, new DropTimeConstraintAction());
    }

    public static ICommand getDropDurationObservationCommand(DurationObservation durationObservation, View dropTarget, EditPartViewer viewer) {
        ArrayList<EObject> linkedElements = new ArrayList<EObject>();
        linkedElements.addAll((Collection<EObject>)durationObservation.getEvents());
        return DropUtils.getDropLinkedNodeInLifelineCommand((EObject)durationObservation, linkedElements, dropTarget, viewer, new DropDurationObservationAction());
    }

    public static ICommand getDropDurationConstraintCommand(DurationConstraint durationConstraint, View dropTarget, EditPartViewer viewer) {
        ArrayList<EObject> linkedElements = new ArrayList<EObject>();
        linkedElements.addAll((Collection<EObject>)durationConstraint.getConstrainedElements());
        return DropUtils.getDropLinkedNodeInLifelineCommand((EObject)durationConstraint, linkedElements, dropTarget, viewer, new DropDurationConstraintAction());
    }

    public static ICommand getDropGeneralOrderingCommand(GeneralOrdering generalOrdering, View dropTarget, EditPartViewer viewer) {
        ArrayList<EObject> linkedElements = new ArrayList<EObject>();
        linkedElements.add((EObject)generalOrdering.getBefore());
        linkedElements.add((EObject)generalOrdering.getAfter());
        return DropUtils.getDropLinkedNodeInLifelineCommand((EObject)generalOrdering, linkedElements, dropTarget, viewer, new DropGeneralOrderingAction());
    }

    public static ICommand getDropGateCommand(final Gate gate, View dropTarget, EditPartViewer viewer) {
        final Node interactionView = (Node)ViewUtils.findSuperViewWithId(dropTarget, 2);
        if (interactionView == null || ViewUtils.containsViewFor((View)interactionView, (EObject)gate)) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)interactionView);
        CompositeCommand compositeCommand = new CompositeCommand(Messages.DropUtils_DropGate);
        compositeCommand.add((IUndoableOperation)new CommandProxy((Command)new RefreshCommandForUndo((GraphicalEditPart)viewer.getRootEditPart())));
        compositeCommand.add((IUndoableOperation)new AbstractTransactionalCommand(editingDomain, Messages.DropUtils_DropGate, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Node gateNode = new UMLViewProvider().createGate_69((EObject)gate, (View)interactionView, -1, true, PreferencesHint.USE_DEFAULTS);
                try {
                    int index = ((Interaction)gate.eContainer()).getFormalGates().indexOf((Object)gate);
                    Location loc = NotationFactory.eINSTANCE.createLocation();
                    loc.setX(-10);
                    loc.setY(30 + index * 20);
                    gateNode.setLayoutConstraint((LayoutConstraint)loc);
                }
                catch (Exception e) {
                    Activator.log.error("Couldn't layout dropped Gates", (Throwable)e);
                }
                return CommandResult.newOKCommandResult();
            }
        });
        compositeCommand.add((IUndoableOperation)new CommandProxy((Command)new RefreshCommandForDo((GraphicalEditPart)viewer.getRootEditPart())));
        return compositeCommand;
    }

    protected static class DropDurationConstraintAction
    implements IDropLinkedNodeInLifelineAction<DurationConstraint> {
        protected DropDurationConstraintAction() {
        }

        @Override
        public void drop(DurationConstraint durationConstraint, View compartmentView) {
            Node durationConstraintNode = new UMLViewProvider().createDurationConstraint_18((EObject)durationConstraint, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
            if (durationConstraintNode != null) {
                Bounds bounds = NotationFactory.eINSTANCE.createBounds();
                bounds.setY(5);
                durationConstraintNode.setLayoutConstraint((LayoutConstraint)bounds);
            }
        }
    }

    protected static class DropDurationObservationAction
    implements IDropLinkedNodeInLifelineAction<DurationObservation> {
        protected DropDurationObservationAction() {
        }

        @Override
        public void drop(DurationObservation durationObservation, View compartmentView) {
            Node durationObservationNode = new UMLViewProvider().createDurationObservation_17((EObject)durationObservation, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
            if (durationObservationNode != null) {
                Location loc = NotationFactory.eINSTANCE.createLocation();
                loc.setX(0);
                loc.setY(40);
                durationObservationNode.setLayoutConstraint((LayoutConstraint)loc);
            }
        }
    }

    protected static class DropGeneralOrderingAction
    implements IDropLinkedNodeInLifelineAction<GeneralOrdering> {
        protected DropGeneralOrderingAction() {
        }

        @Override
        public void drop(GeneralOrdering generalOrdering, View compartmentView) {
            Node generalOrderingNode = new UMLViewProvider().createGeneralOrdering_67((EObject)generalOrdering, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
            if (generalOrderingNode != null) {
                Bounds bounds = NotationFactory.eINSTANCE.createBounds();
                bounds.setY(30);
                generalOrderingNode.setLayoutConstraint((LayoutConstraint)bounds);
            }
        }
    }

    protected static class DropTimeConstraintAction
    implements IDropLinkedNodeInLifelineAction<TimeConstraint> {
        protected DropTimeConstraintAction() {
        }

        @Override
        public void drop(TimeConstraint timeConstraint, View compartmentView) {
            Node timeConstraintNode = new UMLViewProvider().createTimeConstraint_15((EObject)timeConstraint, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
            if (timeConstraintNode != null) {
                Bounds bounds = NotationFactory.eINSTANCE.createBounds();
                bounds.setY(40);
                timeConstraintNode.setLayoutConstraint((LayoutConstraint)bounds);
            }
        }
    }

    protected static class DropTimeObservationAction
    implements IDropLinkedNodeInLifelineAction<TimeObservation> {
        protected DropTimeObservationAction() {
        }

        @Override
        public void drop(TimeObservation timeObservation, View compartmentView) {
            Node timeObservationNode = new UMLViewProvider().createTimeObservation_16((EObject)timeObservation, compartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
            if (timeObservationNode != null) {
                Location loc = NotationFactory.eINSTANCE.createLocation();
                loc.setX(0);
                loc.setY(40);
                timeObservationNode.setLayoutConstraint((LayoutConstraint)loc);
            }
        }
    }

    private static interface IDropLinkedNodeInLifelineAction<T extends EObject> {
        public void drop(T var1, View var2);
    }
}

