/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;

public class TimeRulerVisibilityRefreshEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public static final String ROLE = "TimeRulerVisibilityRefreshRole";
    private View timeRulerCompartmentView;

    public void activate() {
        this.timeRulerCompartmentView = this.getListenedView();
        if (this.timeRulerCompartmentView == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)this.timeRulerCompartmentView, (NotificationListener)this);
        this.refreshFigure();
    }

    public void deactivate() {
        if (this.timeRulerCompartmentView == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)this.timeRulerCompartmentView, (NotificationListener)this);
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (editingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)editingDomain);
        }
        return null;
    }

    protected View getListenedView() {
        View view = this.getView();
        if (view != null) {
            return ViewUtils.findTimeRulerCompartmentView(view);
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }

    public void notifyChanged(Notification notification) {
        Object feature;
        if (notification.getEventType() == 1 && (feature = notification.getFeature()) == NotationPackage.eINSTANCE.getView_Visible()) {
            this.refreshFigure();
        }
    }

    public void refreshFigure() {
        boolean visible = this.getListenedView().isVisible();
        IFigure figure = ((IGraphicalEditPart)this.getHost()).getFigure();
        LifelineFigure lifelineFigure = FigureUtils.findChildFigureInstance(figure, LifelineFigure.class);
        lifelineFigure.setDisplayTimeRuler(visible);
    }
}

