/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.layout.FreeFormLayoutEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.node.InteractionRectangleFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CompactLifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CrossFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.FullLifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.SmallSquareFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.layouts.FillLayout;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.EditPartUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TickUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FreeTimeRulerCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionEditPartTN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.TickEditPart;

public class CustomFreeTimeRulerCompartmentEditPart
extends FreeTimeRulerCompartmentEditPart {
    public CustomFreeTimeRulerCompartmentEditPart(View view) {
        super(view);
    }

    @Override
    public IFigure createFigure() {
        ResizableCompartmentFigure result = (ResizableCompartmentFigure)super.createFigure();
        result.setTitleVisibility(false);
        result.setBorder(null);
        result.getScrollPane().setBorder(null);
        result.setLayoutManager((LayoutManager)new FreeFormLayoutEx(){

            public void layout(IFigure container) {
                try {
                    CustomFreeTimeRulerCompartmentEditPart.this.layoutTicks(container);
                }
                catch (Exception e) {
                    Activator.log.error("Error in ticks layout", (Throwable)e);
                }
            }
        });
        return result;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        ((ResizableCompartmentFigure)this.getFigure()).getScrollPane().setScrollBarVisibility(0);
        this.refreshBounds();
    }

    public boolean isSelectable() {
        return false;
    }

    protected void layoutTicks(IFigure container) {
        EditPart editPart;
        EditPartViewer viewer = this.getRoot().getViewer();
        Map visualPartMap = viewer.getVisualPartMap();
        InteractionRectangleFigure interactionFigure = FigureUtils.findParentFigureInstance(container, InteractionRectangleFigure.class);
        List<SmallSquareFigure> osFigures = FigureUtils.findChildFigureInstances((IFigure)interactionFigure, SmallSquareFigure.class);
        List<CrossFigure> destructionOSFigures = FigureUtils.findChildFigureInstances((IFigure)interactionFigure, CrossFigure.class);
        ArrayList<EditPart> osEditParts = new ArrayList<EditPart>();
        for (SmallSquareFigure smallSquareFigure : osFigures) {
            editPart = (EditPart)visualPartMap.get(FigureUtils.findParentFigureInstance((IFigure)smallSquareFigure, BorderedNodeFigure.class));
            if (editPart == null) continue;
            osEditParts.add(editPart);
        }
        for (CrossFigure crossFigure : destructionOSFigures) {
            editPart = (EditPart)visualPartMap.get(FigureUtils.findParentFigureInstance((IFigure)crossFigure, BorderedNodeFigure.class));
            if (editPart == null) continue;
            osEditParts.add(editPart);
        }
        if (!(container.getParent().getLayoutManager() instanceof FillLayout)) {
            container.getParent().setLayoutManager((LayoutManager)new FillLayout());
        }
        List list = container.getChildren();
        int i = 0;
        while (i < list.size()) {
            IFigure child = (IFigure)list.get(i);
            List<BorderedNodeFigure> marks = FigureUtils.findChildFigureInstances(child, BorderedNodeFigure.class);
            for (BorderedNodeFigure verticalMarkFigure : marks) {
                boolean compactLifeline = FigureUtils.findParentFigureInstance((IFigure)verticalMarkFigure, CompactLifelineFigure.class) != null;
                boolean fullLifeline = FigureUtils.findParentFigureInstance((IFigure)verticalMarkFigure, FullLifelineFigure.class) != null;
                TickEditPart tickEditPart = (TickEditPart)((Object)visualPartMap.get(verticalMarkFigure));
                IGraphicalEditPart occurrenceSpecificationEditPart = TickUtils.findOccurrenceSpecificationEditPartFromTickEditPart(tickEditPart, viewer);
                if (occurrenceSpecificationEditPart == null) continue;
                CompartmentEditPart timelineCompartment = EditPartUtils.findParentTimelineCompartment((EditPart)occurrenceSpecificationEditPart);
                InteractionEditPartTN interactionEditPart = (InteractionEditPartTN)EditPartUtils.findParentEditPartWithId((EditPart)timelineCompartment, 2);
                int startX = fullLifeline ? 101 : (compactLifeline ? 1 : timelineCompartment.getFigure().getBounds().x - interactionEditPart.getFigure().getBounds().x);
                Dimension markSize = verticalMarkFigure.getPreferredSize();
                IFigure osFigure = occurrenceSpecificationEditPart.getFigure();
                Rectangle osBounds = osFigure.getBounds();
                verticalMarkFigure.setBounds(new Rectangle(startX + osBounds.x - 1, 0, markSize.width, markSize.height));
            }
            ++i;
        }
    }
}

