/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.DescriptionStyle;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;
import org.eclipse.papyrus.uml.diagram.timing.custom.Messages;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.ChangeLifelineFromCompactToFull;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.ChangeLifelineFromFullToCompact;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.DropUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateDefinitionUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.StateInvariantUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TickUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.TimeRulerUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.Utils;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.CompactLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.timing.providers.UMLViewProvider;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

public class SwitchLifelineCommand
extends GraphicalCommandHandler {
    private Command switchLifeline(IGraphicalEditPart lifelineEditPart) {
        EditPartViewer viewer = lifelineEditPart.getViewer();
        View lifelineView = (View)lifelineEditPart.getModel();
        View timeRulerCompartmentView = ViewUtils.findTimeRulerCompartmentView(lifelineView);
        boolean timeRulerVisible = timeRulerCompartmentView.isVisible();
        Lifeline lifeline = (Lifeline)lifelineView.getElement();
        CompoundCommand cc = new CompoundCommand(Messages.SwitchLifelineCommand_switchLifeline);
        Map<OccurrenceSpecification, List<Node>> ticksAssociations = SwitchLifelineCommand.computeAllTicksAssociations(lifelineView);
        Map<OccurrenceSpecification, String> lifelineTicksAssociations = SwitchLifelineCommand.computeLifelineTicksAssociations(lifelineView);
        if (lifelineEditPart instanceof CompactLifelineEditPartCN) {
            cc.add((Command)new RefreshCommandForUndo((GraphicalEditPart)((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)lifelineEditPart.getParent())));
            cc.add((Command)new ICommandProxy(this.getNameUnnamedStateInvariants(lifeline)));
            ChangeLifelineFromCompactToFull createCommand = new ChangeLifelineFromCompactToFull(this.getEditingDomain(), lifelineEditPart);
            cc.add((Command)new ICommandProxy((ICommand)createCommand));
            cc.add((Command)new ICommandProxy(this.getFreeTimeRulerCreationCommand((ICommand)createCommand, timeRulerVisible)));
            cc.add((Command)new ICommandProxy(this.getStateDefinitionCreationForFullLifelineCommand(lifeline, (ICommand)createCommand)));
            cc.add((Command)new ICommandProxy(this.getFragmentsCreationForFullLifelineCommand(lifeline, (ICommand)createCommand)));
            cc.add((Command)new ICommandProxy(this.getTicksAssociationCommand((ICommand)createCommand, ticksAssociations)));
            cc.add((Command)new ICommandProxy(this.getLifelineTicksCreationCommand((ICommand)createCommand, lifelineTicksAssociations)));
            SwitchLifelineCommand.addDestroyViewsAndEdgesRecursivelyCommand(cc, lifelineView);
            cc.add((Command)new RefreshCommandForDo((GraphicalEditPart)((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)lifelineEditPart.getParent())));
            cc.add((Command)new ICommandProxy(this.getMessagesCreationCommand((ICommand)createCommand, viewer)));
            cc.add((Command)new ICommandProxy(this.getLinkedElementsCreationCommand((ICommand)createCommand, viewer)));
            cc.add((Command)new RefreshCommandForDo((GraphicalEditPart)((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)lifelineEditPart.getParent())));
            return cc;
        }
        if (lifelineEditPart instanceof FullLifelineEditPartCN) {
            cc.add((Command)new RefreshCommandForUndo((GraphicalEditPart)((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)lifelineEditPart.getParent())));
            ChangeLifelineFromFullToCompact createCommand = new ChangeLifelineFromFullToCompact(this.getEditingDomain(), lifelineEditPart);
            cc.add((Command)new ICommandProxy((ICommand)createCommand));
            cc.add((Command)new ICommandProxy(this.getFreeTimeRulerCreationCommand((ICommand)createCommand, timeRulerVisible)));
            cc.add((Command)new ICommandProxy(this.getFragmentsCreationForCompactLifelineCommand(lifeline, (ICommand)createCommand)));
            cc.add((Command)new ICommandProxy(this.getTicksAssociationCommand((ICommand)createCommand, ticksAssociations)));
            cc.add((Command)new ICommandProxy(this.getLifelineTicksCreationCommand((ICommand)createCommand, lifelineTicksAssociations)));
            SwitchLifelineCommand.addDestroyViewsAndEdgesRecursivelyCommand(cc, lifelineView);
            cc.add((Command)new RefreshCommandForDo((GraphicalEditPart)((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)lifelineEditPart.getParent())));
            cc.add((Command)new ICommandProxy(this.getMessagesCreationCommand((ICommand)createCommand, viewer)));
            cc.add((Command)new ICommandProxy(this.getLinkedElementsCreationCommand((ICommand)createCommand, viewer)));
            cc.add((Command)new RefreshCommandForDo((GraphicalEditPart)((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)lifelineEditPart.getParent())));
            return cc;
        }
        throw new IllegalArgumentException("expected a Lifeline edit part");
    }

    private static Map<OccurrenceSpecification, List<Node>> computeAllTicksAssociations(View lifelineView) {
        HashMap<OccurrenceSpecification, List<Node>> map = new HashMap<OccurrenceSpecification, List<Node>>();
        View timelineCompartmentView = ViewUtils.findChildTimelineCompartmentView(lifelineView);
        EList children = timelineCompartmentView.getChildren();
        for (View child : children) {
            if (!ViewUtils.isViewFor(child, UMLPackage.eINSTANCE.getOccurrenceSpecification())) continue;
            OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)child.getElement();
            List<Node> associatedTickViews = TickUtils.getAssociatedTickViews(child);
            map.put(occurrenceSpecification, associatedTickViews);
        }
        return map;
    }

    private static Map<OccurrenceSpecification, String> computeLifelineTicksAssociations(View lifelineView) {
        HashMap<OccurrenceSpecification, String> map = new HashMap<OccurrenceSpecification, String>();
        View timeRulerCompartment = ViewUtils.findFirstChildViewWithId(lifelineView, 80);
        EList children = timeRulerCompartment.getChildren();
        for (View tickView : children) {
            Node associatedOccurrenceView = TickUtils.getAssociatedOccurrenceView(tickView);
            OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)associatedOccurrenceView.getElement();
            String description = SwitchLifelineCommand.getTickLabelDescription(tickView);
            map.put(occurrenceSpecification, description);
        }
        return map;
    }

    protected static void setTickLabelDescription(Node tickNode, String tickName) {
        View labelView = ViewUtils.findFirstChildViewWithId((View)tickNode, 36);
        if (labelView != null) {
            EList styles = labelView.getStyles();
            for (Object style : styles) {
                if (!(style instanceof DescriptionStyle)) continue;
                DescriptionStyle descriptionStyle = (DescriptionStyle)style;
                descriptionStyle.setDescription(tickName);
            }
        }
    }

    private static String getTickLabelDescription(View tickView) {
        View labelView = ViewUtils.findFirstChildViewWithId(tickView, 36);
        if (labelView != null) {
            EList styles = labelView.getStyles();
            for (Object style : styles) {
                if (!(style instanceof DescriptionStyle)) continue;
                DescriptionStyle descriptionStyle = (DescriptionStyle)style;
                return descriptionStyle.getDescription();
            }
        }
        return "";
    }

    private ICommand getTicksAssociationCommand(final ICommand createCommand, final Map<OccurrenceSpecification, List<Node>> ticksAssociations) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SwitchLifelineCommand_ReAssociateTicks, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View lifelineView = (View)createCommand.getCommandResult().getReturnValue();
                if (lifelineView == null) {
                    return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                }
                View timelineCompartmentView = ViewUtils.findChildTimelineCompartmentView(lifelineView);
                EList children = timelineCompartmentView.getChildren();
                for (View child : children) {
                    OccurrenceSpecification occurrenceSpecification;
                    List tickNodes;
                    if (!ViewUtils.isViewFor(child, UMLPackage.eINSTANCE.getOccurrenceSpecification()) || (tickNodes = (List)ticksAssociations.get(occurrenceSpecification = (OccurrenceSpecification)child.getElement())) == null) continue;
                    for (Node tickNode : tickNodes) {
                        TickUtils.associateTickNodeToOccurrenceNode(tickNode, (Node)child, true);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private ICommand getLifelineTicksCreationCommand(final ICommand createCommand, final Map<OccurrenceSpecification, String> lifelineTicksAssociations) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SwitchLifelineCommand_ReAssociateTicks, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View lifelineView = (View)createCommand.getCommandResult().getReturnValue();
                if (lifelineView == null) {
                    return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                }
                View timeRulerCompartment = ViewUtils.findFirstChildViewWithId(lifelineView, 80);
                View timelineCompartmentView = ViewUtils.findChildTimelineCompartmentView(lifelineView);
                UMLViewProvider umlViewProvider = new UMLViewProvider();
                for (Map.Entry entry : lifelineTicksAssociations.entrySet()) {
                    OccurrenceSpecification occurrenceSpecification = (OccurrenceSpecification)entry.getKey();
                    Node occurrenceView = SwitchLifelineCommand.findOccurrenceView(occurrenceSpecification, timelineCompartmentView);
                    String tickName = (String)entry.getValue();
                    Node tickNode = umlViewProvider.createNode_26(null, timeRulerCompartment, -1, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                    SwitchLifelineCommand.setTickLabelDescription(tickNode, tickName);
                    TickUtils.associateTickNodeToOccurrenceNode(tickNode, occurrenceView, false);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    protected static Node findOccurrenceView(OccurrenceSpecification occurrenceSpecification, View timelineCompartmentView) {
        EList children = timelineCompartmentView.getChildren();
        for (View child : children) {
            if (child.getElement() != occurrenceSpecification) continue;
            return (Node)child;
        }
        return null;
    }

    private ICommand getNameUnnamedStateInvariants(final Lifeline lifeline) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SwitchLifelineCommand_NameUnnamedStateInvariants, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                EList coveredBys = lifeline.getCoveredBys();
                boolean containsUnnamedStateInvariants = false;
                for (InteractionFragment interactionFragment : coveredBys) {
                    StateInvariant stateInvariant;
                    if (!(interactionFragment instanceof StateInvariant) || StateInvariantUtils.getInnerStateInvariantName(stateInvariant = (StateInvariant)interactionFragment) != null) continue;
                    containsUnnamedStateInvariants = true;
                    StateInvariantUtils.setInnerStateInvariantName(stateInvariant, Messages.SwitchLifelineCommand_unnamed);
                }
                if (containsUnnamedStateInvariants) {
                    StateDefinitionUtils.updateStateDefinitionNamesForCompactLifeline(lifeline);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private static void addDestroyViewsAndEdgesRecursivelyCommand(CompoundCommand cc, View view) {
        EList children = view.getChildren();
        for (View childView : children) {
            SwitchLifelineCommand.addDestroyViewsAndEdgesRecursivelyCommand(cc, childView);
        }
        EList sourceEdges = view.getSourceEdges();
        EList targetEdges = view.getTargetEdges();
        for (Edge edge : sourceEdges) {
            cc.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(new DestroyElementRequest((EObject)edge, false))));
        }
        for (Edge edge : targetEdges) {
            cc.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(new DestroyElementRequest((EObject)edge, false))));
        }
        cc.add((Command)new ICommandProxy((ICommand)new DestroyElementCommand(new DestroyElementRequest((EObject)view, false))));
    }

    private ICommand getMessagesCreationCommand(final ICommand createCommand, final EditPartViewer viewer) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SwitchLifelineCommand_createMessages, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View lifelineView = (View)createCommand.getCommandResult().getReturnValue();
                if (lifelineView == null) {
                    return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                }
                Lifeline lifeline = (Lifeline)lifelineView.getElement();
                EReference[] references = new EReference[]{UMLPackage.eINSTANCE.getMessage_ReceiveEvent(), UMLPackage.eINSTANCE.getMessage_SendEvent()};
                Class[] expectedClasses = new Class[]{Message.class};
                EList coveredBys = lifeline.getCoveredBys();
                HashSet<EObject> referencingElements = new HashSet<EObject>();
                for (InteractionFragment interactionFragment : coveredBys) {
                    referencingElements.addAll(Utils.findReferencingElements((EObject)interactionFragment, references, expectedClasses));
                }
                for (EObject referencingElement : referencingElements) {
                    Message referencingMessage = (Message)referencingElement;
                    SwitchLifelineCommand.executeCommand(DropUtils.getDropMessageCommand(referencingMessage, lifelineView, viewer));
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private ICommand getLinkedElementsCreationCommand(final ICommand createCommand, final EditPartViewer viewer) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SwitchLifelineCommand_CreateLinkedElements, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View lifelineView = (View)createCommand.getCommandResult().getReturnValue();
                if (lifelineView == null) {
                    return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                }
                EReference[] references = new EReference[]{UMLPackage.eINSTANCE.getGeneralOrdering_Before(), UMLPackage.eINSTANCE.getGeneralOrdering_After(), UMLPackage.eINSTANCE.getDurationObservation_Event(), UMLPackage.eINSTANCE.getTimeObservation_Event(), UMLPackage.eINSTANCE.getConstraint_ConstrainedElement()};
                Class[] expectedClasses = new Class[]{GeneralOrdering.class, TimeObservation.class, DurationObservation.class, TimeConstraint.class, DurationConstraint.class};
                Lifeline lifeline = (Lifeline)lifelineView.getElement();
                EList coveredBys = lifeline.getCoveredBys();
                HashSet<EObject> referencingElements = new HashSet<EObject>();
                for (InteractionFragment interactionFragment : coveredBys) {
                    referencingElements.addAll(Utils.findReferencingElements((EObject)interactionFragment, references, expectedClasses));
                }
                for (EObject eObject : referencingElements) {
                    if (eObject instanceof TimeObservation) {
                        TimeObservation timeObservation = (TimeObservation)eObject;
                        SwitchLifelineCommand.executeCommand(DropUtils.getDropTimeObservationCommand(timeObservation, lifelineView, viewer));
                        continue;
                    }
                    if (eObject instanceof TimeConstraint) {
                        TimeConstraint timeConstraint = (TimeConstraint)eObject;
                        SwitchLifelineCommand.executeCommand(DropUtils.getDropTimeConstraintCommand(timeConstraint, lifelineView, viewer));
                        continue;
                    }
                    if (eObject instanceof DurationObservation) {
                        DurationObservation durationObservation = (DurationObservation)eObject;
                        SwitchLifelineCommand.executeCommand(DropUtils.getDropDurationObservationCommand(durationObservation, lifelineView, viewer));
                        continue;
                    }
                    if (eObject instanceof DurationConstraint) {
                        DurationConstraint durationConstraint = (DurationConstraint)eObject;
                        SwitchLifelineCommand.executeCommand(DropUtils.getDropDurationConstraintCommand(durationConstraint, lifelineView, viewer));
                        continue;
                    }
                    if (!(eObject instanceof GeneralOrdering)) continue;
                    GeneralOrdering generalOrdering = (GeneralOrdering)eObject;
                    SwitchLifelineCommand.executeCommand(DropUtils.getDropGeneralOrderingCommand(generalOrdering, lifelineView, viewer));
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private ICommand getStateDefinitionCreationForFullLifelineCommand(final Lifeline lifeline, final ICommand createCommand) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SwitchLifelineCommand_createStateDefinitions, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View lifelineView = (View)createCommand.getCommandResult().getReturnValue();
                if (lifelineView == null) {
                    return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                }
                View stateDefinitionCompartmentView = ViewUtils.findStateDefinitionCompartmentView(lifelineView);
                List<String> stateDefinitionIds = StateDefinitionUtils.getStateDefinitionIds(lifeline);
                for (String stateDefinitionId : stateDefinitionIds) {
                    String stateDefinitionName = StateDefinitionUtils.getStateDefinitionName(stateDefinitionId, lifeline);
                    UMLViewProvider umlViewProvider = new UMLViewProvider();
                    Node stateDefinitionView = umlViewProvider.createNode_9(null, stateDefinitionCompartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                    StateDefinitionUtils.setStateDefinitionViewID((View)stateDefinitionView, stateDefinitionId);
                    StateDefinitionUtils.setStateDefinitionName((View)stateDefinitionView, stateDefinitionName);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private ICommand getFreeTimeRulerCreationCommand(final ICommand createCommand, final boolean timeRulerVisible) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SwitchLifelineCommand_CreateTimeRuler, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View lifelineView = (View)createCommand.getCommandResult().getReturnValue();
                if (lifelineView == null) {
                    return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                }
                TimeRulerUtils.createFreeTimeRuler(lifelineView);
                View timeRulerCompartmentView = ViewUtils.findTimeRulerCompartmentView(lifelineView);
                timeRulerCompartmentView.setVisible(timeRulerVisible);
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private ICommand getFragmentsCreationForCompactLifelineCommand(final Lifeline lifeline, final ICommand createCommand) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SwitchLifelineCommand_createLifelineFragments, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View lifelineView = (View)createCommand.getCommandResult().getReturnValue();
                if (lifelineView == null) {
                    return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                }
                UMLViewProvider umlViewProvider = new UMLViewProvider();
                View stateInvariantCompartmentView = ViewUtils.findCompactTimelineCompartmentView(lifelineView);
                String previousStateInvariantName = "";
                int indexInCompartment = 0;
                int x = 100;
                for (InteractionFragment fragment : lifeline.getCoveredBys()) {
                    Node occurrenceSpecificationView;
                    DestructionOccurrenceSpecification occurrence;
                    Location loc = NotationFactory.eINSTANCE.createLocation();
                    loc.setX(x);
                    loc.setY(0);
                    if (fragment instanceof StateInvariant) {
                        StateInvariant stateInvariant = (StateInvariant)fragment;
                        String stateInvariantName = StateInvariantUtils.getInnerStateInvariantName(stateInvariant);
                        if (!Utils.safeEquals(stateInvariantName, previousStateInvariantName)) {
                            umlViewProvider.createStateInvariant_28((EObject)stateInvariant, stateInvariantCompartmentView, indexInCompartment, true, PreferencesHint.USE_DEFAULTS);
                            ++indexInCompartment;
                            x += 60;
                        }
                        previousStateInvariantName = stateInvariantName;
                        continue;
                    }
                    if (fragment instanceof DestructionOccurrenceSpecification) {
                        occurrence = (DestructionOccurrenceSpecification)fragment;
                        occurrenceSpecificationView = umlViewProvider.createDestructionOccurrenceSpecification_27((EObject)occurrence, stateInvariantCompartmentView, indexInCompartment, true, PreferencesHint.USE_DEFAULTS);
                        ++indexInCompartment;
                        occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
                        x += 10;
                        continue;
                    }
                    if (fragment instanceof MessageOccurrenceSpecification) {
                        occurrence = (MessageOccurrenceSpecification)fragment;
                        occurrenceSpecificationView = umlViewProvider.createMessageOccurrenceSpecification_13((EObject)occurrence, stateInvariantCompartmentView, indexInCompartment, true, PreferencesHint.USE_DEFAULTS);
                        ++indexInCompartment;
                        occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
                        x += 10;
                        continue;
                    }
                    if (!(fragment instanceof OccurrenceSpecification)) continue;
                    occurrence = (OccurrenceSpecification)fragment;
                    occurrenceSpecificationView = umlViewProvider.createOccurrenceSpecification_12((EObject)occurrence, stateInvariantCompartmentView, indexInCompartment, true, PreferencesHint.USE_DEFAULTS);
                    ++indexInCompartment;
                    occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
                    x += 10;
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    private ICommand getFragmentsCreationForFullLifelineCommand(final Lifeline lifeline, final ICommand createCommand) {
        return new AbstractTransactionalCommand(this.getEditingDomain(), Messages.SwitchLifelineCommand_createLifelineFragments, null, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View lifelineView = (View)createCommand.getCommandResult().getReturnValue();
                if (lifelineView == null) {
                    return CommandResult.newErrorCommandResult((String)"Parent Lifeline not found");
                }
                View timelineCompartmentView = ViewUtils.findFullLifelineCompartmentView(lifelineView);
                EList fragments = lifeline.getCoveredBys();
                UMLViewProvider umlViewProvider = new UMLViewProvider();
                int x = 20;
                boolean firstStateInvariant = true;
                String previousStateInvariantName = "";
                StateInvariant previousStateInvariant = null;
                boolean needStateInvariant = false;
                for (InteractionFragment fragment : fragments) {
                    MessageOccurrenceSpecification occurrenceSpecification;
                    Node occurrenceSpecificationView;
                    Location loc = NotationFactory.eINSTANCE.createLocation();
                    loc.setX(x);
                    loc.setY(0);
                    if (!(fragment instanceof StateInvariant) && needStateInvariant && previousStateInvariant != null) {
                        umlViewProvider.createStateInvariant_11((EObject)previousStateInvariant, timelineCompartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                    }
                    if (fragment instanceof StateInvariant) {
                        StateInvariant stateInvariant;
                        String stateInvariantName;
                        if (!firstStateInvariant) {
                            umlViewProvider.createNode_39(null, timelineCompartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                        }
                        x = Utils.safeEquals(stateInvariantName = StateInvariantUtils.getInnerStateInvariantName(stateInvariant = (StateInvariant)fragment), previousStateInvariantName) ? (x += 10) : (x += 25);
                        umlViewProvider.createStateInvariant_11((EObject)stateInvariant, timelineCompartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                        firstStateInvariant = false;
                        previousStateInvariantName = stateInvariantName;
                        previousStateInvariant = stateInvariant;
                        needStateInvariant = false;
                        continue;
                    }
                    if (fragment instanceof DestructionOccurrenceSpecification) {
                        DestructionOccurrenceSpecification destructionOccurrenceSpecification = (DestructionOccurrenceSpecification)fragment;
                        occurrenceSpecificationView = umlViewProvider.createDestructionOccurrenceSpecification_27((EObject)destructionOccurrenceSpecification, timelineCompartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                        occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
                        needStateInvariant = false;
                        x += 10;
                        continue;
                    }
                    if (fragment instanceof MessageOccurrenceSpecification) {
                        occurrenceSpecification = (MessageOccurrenceSpecification)fragment;
                        occurrenceSpecificationView = umlViewProvider.createMessageOccurrenceSpecification_13((EObject)occurrenceSpecification, timelineCompartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                        occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
                        needStateInvariant = true;
                        x += 10;
                        continue;
                    }
                    if (!(fragment instanceof OccurrenceSpecification)) continue;
                    occurrenceSpecification = (OccurrenceSpecification)fragment;
                    occurrenceSpecificationView = umlViewProvider.createOccurrenceSpecification_12((EObject)occurrenceSpecification, timelineCompartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                    occurrenceSpecificationView.setLayoutConstraint((LayoutConstraint)loc);
                    needStateInvariant = true;
                    x += 10;
                }
                if (needStateInvariant && previousStateInvariant != null) {
                    umlViewProvider.createStateInvariant_11((EObject)previousStateInvariant, timelineCompartmentView, -1, true, PreferencesHint.USE_DEFAULTS);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    protected Command getCommand() {
        CompoundCommand cmd = new CompoundCommand(Messages.SwitchLifelineCommand_switchLifeline);
        List selectedElements = this.getSelectedElements();
        for (IGraphicalEditPart selectedElement : selectedElements) {
            if (!(selectedElement instanceof FullLifelineEditPartCN) && !(selectedElement instanceof CompactLifelineEditPartCN)) continue;
            cmd.add(this.switchLifeline(selectedElement));
        }
        return cmd;
    }

    protected static void executeCommand(ICommand command) throws ExecutionException {
        if (command.canExecute()) {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        } else {
            Activator.log.warn("Cannot execute command for lifeline switch: " + command.getLabel());
        }
    }
}

