/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.internal.interpreter.IMonomorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.IPolymorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.MonomorphicService;

class PolymorphicService
implements IPolymorphicService {
    private final String name;
    private final Set<IMonomorphicService> implementers = Sets.newLinkedHashSet();

    public PolymorphicService(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addImplementer(MonomorphicService svc) {
        Preconditions.checkNotNull((Object)svc);
        Preconditions.checkArgument((boolean)this.name.equals(svc.getName()));
        this.implementers.add(svc);
    }

    @Override
    public boolean appliesTo(Object[] target) {
        return Iterables.any(this.implementers, this.getCompatibilityChecker(target));
    }

    @Override
    public Object call(Object[] target) throws EvaluationException {
        ArrayList candidates = Lists.newArrayList((Iterable)Iterables.filter(this.implementers, this.getCompatibilityChecker(target)));
        if (!candidates.isEmpty()) {
            return ((IMonomorphicService)candidates.get(0)).call(target);
        }
        throw new EvaluationException("No compatible implementation of service " + this.getName() + " found for " + target);
    }

    private Predicate<IMonomorphicService> getCompatibilityChecker(final Object[] target) {
        Predicate<IMonomorphicService> isCompatible = new Predicate<IMonomorphicService>(){

            public boolean apply(IMonomorphicService svc) {
                return svc.appliesTo(target);
            }
        };
        return isCompatible;
    }

    public String toString() {
        return "Polymorphic service " + this.getName() + " (" + this.implementers.size() + " implementations).";
    }

    @Override
    public Set<IMonomorphicService> getImplementers() {
        return this.implementers;
    }
}

