/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.util;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;

public class LazyCrossReferencer
extends ECrossReferenceAdapter {
    private boolean resolveEnabled = true;
    private boolean initialized;
    private ECrossReferenceAdapter adapter = new InternalCrossReferencer();

    protected void initialize() {
        this.initialized = true;
    }

    public void dump() {
        if (!this.initialized) {
            this.initialize();
        }
        this.adapter.dump();
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject object, boolean resolve) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.adapter.getInverseReferences(object, resolve);
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject object) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.adapter.getInverseReferences(object);
    }

    public Collection<EStructuralFeature.Setting> getNonNavigableInverseReferences(EObject object, boolean resolve) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.adapter.getNonNavigableInverseReferences(object, resolve);
    }

    public Collection<EStructuralFeature.Setting> getNonNavigableInverseReferences(EObject object) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.adapter.getNonNavigableInverseReferences(object);
    }

    public Notifier getTarget() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.adapter.getTarget();
    }

    public boolean isAdapterForType(Object type) {
        if (!this.initialized) {
            this.initialize();
        }
        return this.adapter.isAdapterForType(type);
    }

    public void notifyChanged(Notification notification) {
        if (!this.initialized) {
            this.initialize();
        }
        this.adapter.notifyChanged(notification);
    }

    public void setTarget(Notifier target) {
        if (!this.initialized) {
            this.initialize();
        }
        this.adapter.setTarget(target);
    }

    public void unsetTarget(Notifier target) {
        if (!this.initialized) {
            this.initialize();
        }
        this.adapter.unsetTarget(target);
    }

    public void disableResolve() {
        this.resolveEnabled = false;
    }

    public void enableResolve() {
        this.resolveEnabled = true;
    }

    private class InternalCrossReferencer
    extends ECrossReferenceAdapter {
        private InternalCrossReferencer() {
        }

        protected boolean resolve() {
            if (LazyCrossReferencer.this.resolveEnabled) {
                return super.resolve();
            }
            return false;
        }

        protected void handleContainment(Notification notification) {
            this.deregisterDeletedElements(notification);
            super.handleContainment(notification);
        }

        private void deregisterDeletedElements(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 4: {
                    Object oldValue = notification.getOldValue();
                    if (!(oldValue instanceof Notifier)) break;
                    this.removeAdapter((Notifier)oldValue);
                    break;
                }
                case 6: {
                    for (Notifier oldVal : Iterables.filter((Iterable)((Collection)notification.getOldValue()), Notifier.class)) {
                        this.removeAdapter(oldVal);
                    }
                    break;
                }
            }
        }
    }
}

