/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.ecore;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;

public class WorkspaceEPackageRegistry
extends HashMap<String, Object>
implements IResourceChangeListener,
EPackage.Registry {
    private static final long serialVersionUID = -6543542780952654086L;
    private EPackage.Registry delegated;

    public WorkspaceEPackageRegistry(boolean delegate) {
        if (delegate) {
            this.delegated = EPackage.Registry.INSTANCE;
        }
    }

    public void init(IWorkspace ws) {
        List<IFile> files = EclipseUtil.getFilesFromWorkspace(null, ".ecore");
        for (IFile file : files) {
            this.newEcore((IResource)file);
        }
        ws.addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose(IWorkspace ws) {
        this.clear();
        ws.removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                this.processDelta(delta);
            }
        }
        catch (CoreException e) {
            DslCommonPlugin.getDefault().error("Error while refresing the workspace EPackage registry", e);
        }
    }

    private void processDelta(IResourceDelta resourceDelta) throws CoreException {
        if (this.deltaIsAboutEcorefile(resourceDelta)) {
            switch (resourceDelta.getKind()) {
                case 1: 
                case 4: 
                case 256: 
                case 262144: {
                    this.newEcore(resourceDelta.getResource());
                    break;
                }
                case 2: {
                    this.deletedEcore(resourceDelta.getResource());
                    break;
                }
            }
        }
        IResourceDelta[] iResourceDeltaArray = resourceDelta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            this.processDelta(child);
            ++n2;
        }
    }

    private void deletedEcore(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            Collection<EPackage> packages = this.collectEPackages(file);
            for (EPackage package1 : packages) {
                this.deleteEPackage(package1);
            }
        }
    }

    private void deleteEPackage(EPackage package1) {
        if (this.containsKey(package1.getNsURI())) {
            this.remove(package1.getNsURI());
        }
    }

    private boolean deltaIsAboutEcorefile(IResourceDelta resourceDelta) {
        return resourceDelta.getResource().getFileExtension() != null && "ecore".equals(resourceDelta.getResource().getFileExtension());
    }

    private void newEcore(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            Collection<EPackage> packages = this.collectEPackages(file);
            for (EPackage package1 : packages) {
                this.newEPackage(package1);
            }
        }
    }

    private Collection<EPackage> collectEPackages(IFile file) {
        ArrayList<EPackage> packages = new ArrayList<EPackage>();
        try {
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toOSString(), (boolean)true);
            Resource ecoreRes = new ResourceSetImpl().getResource(fileURI, true);
            TreeIterator it = ecoreRes.getAllContents();
            while (it.hasNext()) {
                EObject cur = (EObject)it.next();
                if (!(cur instanceof EPackage)) continue;
                packages.add((EPackage)cur);
            }
        }
        catch (Exception exception) {}
        return packages;
    }

    private void newEPackage(EPackage ePackage) {
        if (ePackage.getNsURI() != null && !this.containsAlreadyEPackage(ePackage)) {
            this.put(ePackage.getNsURI(), ePackage);
        }
    }

    private boolean containsAlreadyEPackage(EPackage ePackage) {
        String ePackageURIFragment;
        String alreadyRegistredEPackageURIFragment;
        URI ePackageResourceURI;
        EPackage alreadyRegistredEPackage;
        URI alreadyRegistredEPackageResourceURI;
        boolean containsAlreadyEPackage = false;
        if (this.containsKey(ePackage.getNsURI()) && (alreadyRegistredEPackageResourceURI = (alreadyRegistredEPackage = (EPackage)this.get(ePackage.getNsURI())).eResource().getURI()).equals(ePackageResourceURI = ePackage.eResource().getURI()) && (alreadyRegistredEPackageURIFragment = alreadyRegistredEPackage.eResource().getURIFragment((EObject)alreadyRegistredEPackage)).equals(ePackageURIFragment = ePackage.eResource().getURIFragment((EObject)ePackage))) {
            containsAlreadyEPackage = true;
        }
        return containsAlreadyEPackage;
    }

    public EFactory getEFactory(String arg0) {
        EPackage pak = this.getEPackage(arg0);
        if (pak != null) {
            return pak.getEFactoryInstance();
        }
        return null;
    }

    @Override
    public Object get(Object arg0) {
        Object value = super.get(arg0);
        if (value == null) {
            return this.delegated.get(arg0);
        }
        return value;
    }

    @Override
    public Collection<Object> values() {
        return Sets.union((Set)Sets.newLinkedHashSet(super.values()), (Set)Sets.newLinkedHashSet((Iterable)this.delegated.values()));
    }

    public EPackage getEPackage(String arg0) {
        EPackage workspace = (EPackage)this.get(arg0);
        if (workspace == null) {
            workspace = this.delegated.getEPackage(arg0);
        }
        return workspace;
    }
}

