/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.propertytab;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.BlockPropertyCompositeEditPart;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.PropertyPartEditPartCN;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.polarsys.chess.contracts.profile.chesscontract.ComponentInstance;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.DataTypes.ContractTypes;

public class BlockPropertyCompositeEditPartSection
extends AbstractPropertySection {
    private static final String CONTRACT_PROP = "CHESSContract::ContractProperty";
    private static final String COMP_INST = "CHESSContract::ComponentInstance";
    private Text propertyText;
    private Label propertyLabel;
    private Property currentProperty;
    private Class currentClassType;
    private Table weakTable;
    private Table strongTable;
    private SelectionListener weakTableListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.detail == 32) {
                final TableItem item = (TableItem)e.item;
                final ContractProperty dataContrProp = (ContractProperty)item.getData();
                Stereotype compInstStereo = BlockPropertyCompositeEditPartSection.this.currentProperty.getAppliedStereotype(BlockPropertyCompositeEditPartSection.COMP_INST);
                if (compInstStereo != null) {
                    final ComponentInstance compInst = (ComponentInstance)BlockPropertyCompositeEditPartSection.this.currentProperty.getStereotypeApplication(compInstStereo);
                    TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)dataContrProp.eResource());
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            if (item.getChecked() && !compInst.getWeakGuarantees().contains((Object)dataContrProp)) {
                                compInst.getWeakGuarantees().add((Object)dataContrProp);
                            } else if (!item.getChecked() && compInst.getWeakGuarantees().contains((Object)dataContrProp)) {
                                compInst.getWeakGuarantees().remove((Object)dataContrProp);
                            }
                        }
                    });
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        this.propertyText = this.getWidgetFactory().createText(composite, "no Property selected");
        this.propertyText.setEditable(false);
        this.propertyText.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        this.propertyLabel = this.getWidgetFactory().createLabel(composite, "Selected Property", 0);
        this.propertyLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        Label weakLabel = this.getWidgetFactory().createLabel(composite, "Weak Contracts", 0);
        weakLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        Label strongLabel = this.getWidgetFactory().createLabel(composite, "Strong Contracts", 0);
        strongLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        this.weakTable = this.getWidgetFactory().createTable(composite, 2594);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 25;
        this.weakTable.addSelectionListener(this.weakTableListener);
        this.weakTable.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        this.strongTable = this.getWidgetFactory().createTable(composite, 2562);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 25;
        this.strongTable.setLayoutData((Object)gd);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        List selectionList = ((IStructuredSelection)selection).toList();
        if (selectionList.size() == 1) {
            Property prop;
            Object selected = selectionList.get(0);
            if (selected instanceof BlockPropertyCompositeEditPart) {
                prop = (Property)((BlockPropertyCompositeEditPart)selected).resolveSemanticElement();
                this.initContractLists(prop);
            }
            if (selected instanceof PropertyPartEditPartCN) {
                prop = (Property)((PropertyPartEditPartCN)selected).resolveSemanticElement();
                this.initContractLists(prop);
            }
        }
    }

    private void initContractLists(Property prop) {
        Class classType;
        this.currentProperty = prop;
        ArrayList<ContractProperty> weakList = new ArrayList<ContractProperty>();
        ArrayList<ContractProperty> strongList = new ArrayList<ContractProperty>();
        this.propertyText.setText(this.currentProperty.getQualifiedName());
        Type type = this.currentProperty.getType();
        if (type != null && type instanceof Class && (classType = (Class)type) != this.currentClassType) {
            TableItem tabItem;
            this.weakTable.removeAll();
            this.strongTable.removeAll();
            this.currentClassType = classType;
            for (Property attr : this.currentClassType.getOwnedAttributes()) {
                Stereotype stereo = attr.getAppliedStereotype(CONTRACT_PROP);
                if (stereo == null) continue;
                ContractProperty contrProp = (ContractProperty)attr.getStereotypeApplication(stereo);
                ContractTypes contractType = contrProp.getContractType();
                if (contractType.equals((Object)ContractTypes.STRONG)) {
                    strongList.add(contrProp);
                    continue;
                }
                weakList.add(contrProp);
            }
            for (ContractProperty strongProp : strongList) {
                tabItem = new TableItem(this.strongTable, 0);
                tabItem.setData((Object)strongProp);
                tabItem.setText(strongProp.getBase_Property().getName());
            }
            for (ContractProperty weakProp : weakList) {
                tabItem = new TableItem(this.weakTable, 0);
                tabItem.setData((Object)weakProp);
                tabItem.setText(weakProp.getBase_Property().getName());
            }
            Stereotype compInstStereo = this.currentProperty.getAppliedStereotype(COMP_INST);
            if (compInstStereo != null) {
                ComponentInstance compInst = (ComponentInstance)this.currentProperty.getStereotypeApplication(compInstStereo);
                for (ContractProperty weakProp : compInst.getWeakGuarantees()) {
                    TableItem[] tableItemArray = this.weakTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tItem = tableItemArray[n2];
                        if (tItem.getData().equals(weakProp)) {
                            tItem.setChecked(true);
                        }
                        ++n2;
                    }
                }
            }
        }
    }
}

