/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.listeners;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.polarsys.chess.contracts.chessextension.managers.CHESSContractProfileManager;
import org.polarsys.chess.contracts.profile.chesscontract.FormalProperty;

public class PapyrusModelListener
implements IPapyrusListener {
    private static final String CONTRACT = "CHESSContract::Contract";
    private static final String ASSUME = "Assume";
    private static final String GUARANTEE = "Guarantee";
    private static final Object FEATURE_NAME = "name";

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof Class) {
            EAttribute attr;
            Class cblock = (Class)notifier;
            if (notification.getEventType() == 20 && cblock.getAppliedStereotype(CONTRACT) != null) {
                System.out.println(cblock.getName());
                Constraint assumeConst = cblock.createOwnedRule(String.valueOf(cblock.getName()) + "_" + ASSUME);
                Constraint guaranteeConst = cblock.createOwnedRule(String.valueOf(cblock.getName()) + "_" + GUARANTEE);
                LiteralString assumeValue = UMLFactory.eINSTANCE.createLiteralString();
                assumeValue.setName(assumeConst.getName());
                assumeConst.setSpecification((ValueSpecification)assumeValue);
                LiteralString guaranteeValue = UMLFactory.eINSTANCE.createLiteralString();
                guaranteeValue.setName(guaranteeConst.getName());
                guaranteeConst.setSpecification((ValueSpecification)guaranteeValue);
                Stereotype fpStereotype = CHESSContractProfileManager.getFormalProperty();
                FormalProperty assume = (FormalProperty)assumeConst.applyStereotype(fpStereotype);
                FormalProperty guarantee = (FormalProperty)guaranteeConst.applyStereotype(fpStereotype);
                Stereotype contrStereo = cblock.getAppliedStereotype(CONTRACT);
                cblock.setValue(contrStereo, ASSUME, (Object)assume);
                cblock.setValue(contrStereo, GUARANTEE, (Object)guarantee);
            }
            if (notification.getEventType() == 1 && notification.getFeature() instanceof EAttribute && cblock.getAppliedStereotype(CONTRACT) != null && (attr = (EAttribute)notification.getFeature()).getName().equals(FEATURE_NAME)) {
                EList rules = cblock.getOwnedRules();
                for (Constraint constraint : rules) {
                    if (constraint.getName().contains(ASSUME)) {
                        constraint.setName(String.valueOf(notification.getNewStringValue()) + "_" + ASSUME);
                    }
                    if (constraint.getName().contains(GUARANTEE)) {
                        constraint.setName(String.valueOf(notification.getNewStringValue()) + "_" + GUARANTEE);
                    }
                    constraint.getSpecification().setName(constraint.getName());
                }
            }
        }
    }
}

