/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.monitoring.traceanalyser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.polarsys.chess.monitoring.traceanalyser.Event;
import org.polarsys.chess.monitoring.traceanalyser.ThreadEvents;
import org.polarsys.chess.monitoring.traceanalyser.TraceReader;

public class Parameters {
    private TraceReader trace;
    private ArrayList<String> threadIDs;
    private ArrayList<ArrayList<Event>> threadSpecificEvents;
    private ArrayList<Long> wcetOfAllThreads;
    private ArrayList<Long> bcetOfAllThreads;
    private ArrayList<Double> acetOfAllThreads;
    private ArrayList<Long> minimumInterArrivalTimeOfAllThreads;
    private ArrayList<Long> maximumInterArrivalTimeOfAllThreads;
    private ArrayList<Double> averageInterArrivalTimeOfAllThreads;
    private ArrayList<Long> releaseJitterOfAllThreads;
    private ArrayList<Long> minimumBlockingOfAllThreads;
    private ArrayList<Long> maximumBlockingOfAllThreads;
    private ArrayList<Double> averageBlockingOfAllThreads;
    private ArrayList<Long> worstCaseResponseTimetOfAllThreads;
    private ArrayList<Long> bestCaseResponseTimetOfAllThreads;
    private ArrayList<Long> jitterInResponseTimetOfAllThreads;
    private ArrayList<Double> averageCaseResponseTimetOfAllThreads;
    private ArrayList<Double> varianceInExecutionTimeOfAllThreads;
    private ArrayList<Double> varianceInArrivalTimeOfAllThreads;
    private ArrayList<Double> varianceInBlockingOfAllThreads;
    private ArrayList<Double> varianceInResponseTimeOfAllThreads;
    private double clockRate;
    private IFolder traceExtractionPath;
    private int noOfThreads;

    public Parameters(TraceReader inTrace, IFolder inTraceExtractionPath) {
        this.trace = inTrace;
        this.threadSpecificEvents = this.trace.GetThreadSpecificEvents();
        this.threadIDs = this.trace.GetThreadIDs();
        this.noOfThreads = this.threadIDs.size();
        this.clockRate = this.trace.GetClockRate();
        this.traceExtractionPath = inTraceExtractionPath;
        this.wcetOfAllThreads = new ArrayList(this.noOfThreads);
        this.bcetOfAllThreads = new ArrayList(this.noOfThreads);
        this.acetOfAllThreads = new ArrayList(this.noOfThreads);
        this.minimumInterArrivalTimeOfAllThreads = new ArrayList(this.noOfThreads);
        this.maximumInterArrivalTimeOfAllThreads = new ArrayList(this.noOfThreads);
        this.averageInterArrivalTimeOfAllThreads = new ArrayList(this.noOfThreads);
        this.releaseJitterOfAllThreads = new ArrayList(this.noOfThreads);
        this.minimumBlockingOfAllThreads = new ArrayList(this.noOfThreads);
        this.maximumBlockingOfAllThreads = new ArrayList(this.noOfThreads);
        this.averageBlockingOfAllThreads = new ArrayList(this.noOfThreads);
        this.worstCaseResponseTimetOfAllThreads = new ArrayList(this.noOfThreads);
        this.bestCaseResponseTimetOfAllThreads = new ArrayList(this.noOfThreads);
        this.jitterInResponseTimetOfAllThreads = new ArrayList(this.noOfThreads);
        this.averageCaseResponseTimetOfAllThreads = new ArrayList(this.noOfThreads);
        this.varianceInExecutionTimeOfAllThreads = new ArrayList(this.noOfThreads);
        this.varianceInArrivalTimeOfAllThreads = new ArrayList(this.noOfThreads);
        this.varianceInBlockingOfAllThreads = new ArrayList(this.noOfThreads);
        this.varianceInResponseTimeOfAllThreads = new ArrayList(this.noOfThreads);
    }

    public void ComputeParameters() {
        this.ComputeArrivalTimeRelatedParameters();
        this.ComputeExecutionTimeRelatedParameters();
    }

    private void ComputeArrivalTimeRelatedParameters() {
        ArrayList<Long> arrivalTimeOfThread = new ArrayList<Long>();
        ArrayList<Long> responseTimeOfThread = new ArrayList<Long>();
        long previousWakeupTime = -1L;
        long currentWakeupTime = -1L;
        long lastSleepTime = -1L;
        String threadID = null;
        for (ArrayList<Event> threadEvents : this.threadSpecificEvents) {
            threadID = this.threadIDs.get(this.threadSpecificEvents.indexOf(threadEvents));
            ThreadEvents events = new ThreadEvents(threadID, threadEvents);
            for (Event event : events.GetWakeupEvents()) {
                currentWakeupTime = event.GetTimeStamp();
                if (previousWakeupTime != -1L) {
                    arrivalTimeOfThread.add(currentWakeupTime - previousWakeupTime);
                    lastSleepTime = events.GetLastSleepEventInGivenInterval(previousWakeupTime, currentWakeupTime);
                    if (lastSleepTime != -1L) {
                        responseTimeOfThread.add(lastSleepTime - previousWakeupTime);
                        if (events.GetWakeupEvents().indexOf(event) == events.GetWakeupEvents().size() - 1 && (lastSleepTime = events.FindLastSleepIfAnyAvailable(currentWakeupTime)) != -1L) {
                            responseTimeOfThread.add(lastSleepTime - currentWakeupTime);
                        }
                    } else {
                        System.out.println("Warning: No Ready event and/or sleep event exists between two wakeup events \t " + previousWakeupTime + "\t" + currentWakeupTime);
                    }
                }
                previousWakeupTime = currentWakeupTime;
            }
            try {
                this.WriteAllValuesInFile(arrivalTimeOfThread, this.traceExtractionPath, "InterArrivalTime_" + threadID + ".txt");
                this.WriteAllValuesInFile(responseTimeOfThread, this.traceExtractionPath, "ResponseTime_" + threadID + ".txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (arrivalTimeOfThread.isEmpty()) {
                this.minimumInterArrivalTimeOfAllThreads.add(0L);
                this.maximumInterArrivalTimeOfAllThreads.add(0L);
                this.averageInterArrivalTimeOfAllThreads.add(0.0);
                this.releaseJitterOfAllThreads.add(0L);
                this.varianceInArrivalTimeOfAllThreads.add(0.0);
            } else {
                this.minimumInterArrivalTimeOfAllThreads.add((Long)Collections.min(arrivalTimeOfThread));
                this.maximumInterArrivalTimeOfAllThreads.add(Collections.max(arrivalTimeOfThread));
                this.averageInterArrivalTimeOfAllThreads.add((double)this.Sum(arrivalTimeOfThread) / (double)arrivalTimeOfThread.size());
                this.releaseJitterOfAllThreads.add(Collections.max(arrivalTimeOfThread) - Collections.min(arrivalTimeOfThread));
                this.varianceInArrivalTimeOfAllThreads.add(this.ComputeVariance(arrivalTimeOfThread));
            }
            if (responseTimeOfThread.isEmpty()) {
                this.worstCaseResponseTimetOfAllThreads.add(0L);
                this.bestCaseResponseTimetOfAllThreads.add(0L);
                this.averageCaseResponseTimetOfAllThreads.add(0.0);
                this.jitterInResponseTimetOfAllThreads.add(0L);
                this.varianceInResponseTimeOfAllThreads.add(0.0);
            } else {
                this.worstCaseResponseTimetOfAllThreads.add(Collections.max(responseTimeOfThread));
                this.bestCaseResponseTimetOfAllThreads.add(Collections.min(responseTimeOfThread));
                this.averageCaseResponseTimetOfAllThreads.add((double)this.Sum(responseTimeOfThread) / (double)responseTimeOfThread.size());
                this.jitterInResponseTimetOfAllThreads.add(Collections.max(responseTimeOfThread) - Collections.min(responseTimeOfThread));
                this.varianceInResponseTimeOfAllThreads.add(this.ComputeVariance(responseTimeOfThread));
            }
            previousWakeupTime = -1L;
            currentWakeupTime = -1L;
            arrivalTimeOfThread.clear();
            responseTimeOfThread.clear();
        }
    }

    private void ComputeExecutionTimeRelatedParameters() {
        boolean flag = false;
        long blockedTime = 0L;
        long executionTime = 0L;
        Event currentEvent = null;
        Event previousEvent = null;
        ArrayList<Long> executionTimeOfThread = new ArrayList<Long>();
        ArrayList<Long> blockingTimeOfThread = new ArrayList<Long>();
        for (ArrayList<Event> threadEvents : this.threadSpecificEvents) {
            for (Event event : threadEvents) {
                currentEvent = event;
                if (currentEvent.GetEventID() == 4 || currentEvent.GetEventID() == 1 && !flag) {
                    flag = true;
                    blockedTime = 0L;
                    executionTime = 0L;
                } else if (currentEvent.GetEventID() == 0 && flag) {
                    if (previousEvent.GetEventID() == 1 || previousEvent.GetEventID() == 2 || previousEvent.GetEventID() == 4) {
                        blockedTime += currentEvent.GetTimeStamp() - previousEvent.GetTimeStamp();
                    } else if (previousEvent.GetEventID() == 0) {
                        executionTime += currentEvent.GetTimeStamp() - previousEvent.GetTimeStamp();
                    } else if (blockedTime != 0L) {
                        System.out.print("Warning: Strange previous event: \t");
                        previousEvent.PrintEvent();
                        System.out.print("before current event: \t");
                        currentEvent.PrintEvent();
                    }
                } else if ((currentEvent.GetEventID() == 1 || currentEvent.GetEventID() == 2) && flag) {
                    if (previousEvent.GetEventID() == 0) {
                        executionTime += currentEvent.GetTimeStamp() - previousEvent.GetTimeStamp();
                    } else if (previousEvent.GetEventID() == 1 || previousEvent.GetEventID() == 2 || previousEvent.GetEventID() == 4) {
                        blockedTime += currentEvent.GetTimeStamp() - previousEvent.GetTimeStamp();
                    } else {
                        System.out.print("Warning: Strange previous event:");
                        previousEvent.PrintEvent();
                        System.out.print("before current event:");
                        currentEvent.PrintEvent();
                    }
                } else if (currentEvent.GetEventID() == 3 && flag) {
                    if (previousEvent.GetEventID() == 0) {
                        executionTime += currentEvent.GetTimeStamp() - previousEvent.GetTimeStamp();
                    } else if (executionTime == 0L || previousEvent.GetEventID() != 1 && previousEvent.GetEventID() != 2) {
                        System.out.print("Warning: Strange previous event:");
                        previousEvent.PrintEvent();
                        System.out.print("before current event:");
                        currentEvent.PrintEvent();
                    }
                    executionTimeOfThread.add(executionTime);
                    blockingTimeOfThread.add(blockedTime);
                    blockedTime = 0L;
                    executionTime = 0L;
                    flag = false;
                }
                previousEvent = currentEvent;
            }
            try {
                this.WriteAllValuesInFile(blockingTimeOfThread, this.traceExtractionPath, "BlockingTime_" + this.threadIDs.get(this.threadSpecificEvents.indexOf(threadEvents)) + ".txt");
                this.WriteAllValuesInFile(executionTimeOfThread, this.traceExtractionPath, "Executiontime_" + this.threadIDs.get(this.threadSpecificEvents.indexOf(threadEvents)) + ".txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (executionTimeOfThread.isEmpty()) {
                this.wcetOfAllThreads.add(0L);
                this.bcetOfAllThreads.add(0L);
                this.acetOfAllThreads.add(0.0);
                this.varianceInExecutionTimeOfAllThreads.add(0.0);
            } else {
                this.wcetOfAllThreads.add((Long)Collections.max(executionTimeOfThread));
                this.bcetOfAllThreads.add((Long)Collections.min(executionTimeOfThread));
                this.acetOfAllThreads.add((double)this.Sum(executionTimeOfThread) / (double)executionTimeOfThread.size());
                this.varianceInExecutionTimeOfAllThreads.add(this.ComputeVariance(executionTimeOfThread));
            }
            if (blockingTimeOfThread.isEmpty()) {
                this.maximumBlockingOfAllThreads.add(0L);
                this.minimumBlockingOfAllThreads.add(0L);
                this.averageBlockingOfAllThreads.add(0.0);
                this.varianceInBlockingOfAllThreads.add(0.0);
            } else {
                this.maximumBlockingOfAllThreads.add(Collections.max(blockingTimeOfThread));
                this.minimumBlockingOfAllThreads.add(Collections.min(blockingTimeOfThread));
                this.averageBlockingOfAllThreads.add((double)this.Sum(blockingTimeOfThread) / (double)blockingTimeOfThread.size());
                this.varianceInBlockingOfAllThreads.add(this.ComputeVariance(blockingTimeOfThread));
            }
            executionTimeOfThread.clear();
            blockingTimeOfThread.clear();
            blockedTime = -1L;
            executionTime = -1L;
            currentEvent = null;
            previousEvent = null;
            flag = false;
        }
    }

    private double ComputeVariance(ArrayList<Long> listOfValues) {
        double variance = 0.0;
        double sumOfSquaredValues = 0.0;
        double sumValues = 0.0;
        double size = listOfValues.size();
        Iterator<Long> iterator = listOfValues.iterator();
        while (iterator.hasNext()) {
            double x = iterator.next().longValue();
            sumOfSquaredValues += Math.pow(x, 2.0);
            sumValues += x;
        }
        variance = 1.0 / size * sumOfSquaredValues - Math.pow(1.0 / size * sumValues, 2.0);
        return variance;
    }

    private long Sum(ArrayList<Long> values) {
        long total = 0L;
        for (long v : values) {
            total += v;
        }
        return total;
    }

    public void WriteAllValuesInFile(ArrayList<Long> parameter, IFolder path, String fileName) throws IOException {
        IFile outputFile = path.getProject().getFile(path.getProjectRelativePath() + File.separator + fileName);
        FileWriter fstream = new FileWriter(outputFile.getLocation().toOSString());
        BufferedWriter out = new BufferedWriter(fstream);
        for (long element : parameter) {
            out.write(String.valueOf((double)element / this.clockRate) + "\n");
        }
        out.close();
    }

    public ArrayList<Long> GetMinimumInterArrivalTimeOfAllThreads() {
        return this.minimumInterArrivalTimeOfAllThreads;
    }

    public ArrayList<Long> GetMaximumInterArrivalTimeOfAllThreads() {
        return this.maximumInterArrivalTimeOfAllThreads;
    }

    public ArrayList<Long> GetReleaseJitterOfAllThreads() {
        return this.releaseJitterOfAllThreads;
    }

    public ArrayList<Long> GetWCETOfAllThreads() {
        return this.wcetOfAllThreads;
    }

    public ArrayList<Long> GetBCETOfAllThreads() {
        return this.bcetOfAllThreads;
    }

    public ArrayList<Double> GetACETOfAllThreads() {
        return this.acetOfAllThreads;
    }

    public ArrayList<Long> GetWorstCaseResponseTimeOfAllThreads() {
        return this.worstCaseResponseTimetOfAllThreads;
    }

    public ArrayList<Long> GetBestCaseResponseTimeOfAllThreads() {
        return this.bestCaseResponseTimetOfAllThreads;
    }

    public ArrayList<Double> GetAverageCaseResponseTimeOfAllThreads() {
        return this.averageCaseResponseTimetOfAllThreads;
    }

    public ArrayList<Long> GetMaximumBlockingTimeOfAllThreads() {
        return this.maximumBlockingOfAllThreads;
    }

    public ArrayList<Long> GetMinimumBlockingTimeOfAllThreads() {
        return this.minimumBlockingOfAllThreads;
    }

    public ArrayList<Double> GetAverageBlockingTimeOfAllThreads() {
        return this.averageBlockingOfAllThreads;
    }

    public ArrayList<Double> GetVarianceInBlockingTimeOfAllThreads() {
        return this.varianceInBlockingOfAllThreads;
    }

    public ArrayList<Double> GetVarianceInExecutionTimeOfAllThreads() {
        return this.varianceInExecutionTimeOfAllThreads;
    }

    public ArrayList<Double> GetVarianceInArrivalTimeOfAllThreads() {
        return this.varianceInArrivalTimeOfAllThreads;
    }

    public ArrayList<Double> GetVarianceInResponseTimeOfAllThreads() {
        return this.varianceInResponseTimeOfAllThreads;
    }

    public ArrayList<Long> GetJitterInResponseTimetOfAllThreads() {
        return this.jitterInResponseTimetOfAllThreads;
    }

    public ArrayList<Double> GetAverageInterArrivalTimeOfAllThreads() {
        return this.averageInterArrivalTimeOfAllThreads;
    }
}

