/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.validation;

import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.resource.ASResource;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.validation.LoadableConstraintProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteOCLConstraintProvider
extends LoadableConstraintProvider {
    private static final Logger logger = Logger.getLogger(CompleteOCLConstraintProvider.class);

    public CompleteOCLConstraintProvider() {
        System.out.println("new CompleteOCLConstraintProvider");
    }

    protected boolean load(@NonNull MetaModelManager metaModelManager, @NonNull URI uri, @NonNull Set<Category> categories) {
        ResourceSet resourceSet = metaModelManager.getExternalResourceSet();
        BaseResource xtextResource = null;
        try {
            xtextResource = (BaseResource)resourceSet.getResource(uri, true);
        }
        catch (WrappedException e) {
            logger.error((Object)("Failed to load '" + uri), (Throwable)e);
            throw e;
        }
        EList errors = xtextResource.getErrors();
        assert (errors != null);
        String message = PivotUtil.formatResourceDiagnostics((List)errors, (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load '" + uri + message));
            return false;
        }
        ASResource asResource = xtextResource.getASResource(metaModelManager);
        return this.installResource((Resource)asResource, categories);
    }
}

