/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.synchronizer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.sirius.synchronizer.ChildCreationSupport;
import org.eclipse.sirius.synchronizer.CreatedOutput;
import org.eclipse.sirius.synchronizer.MappingHiearchyTable;
import org.eclipse.sirius.synchronizer.OutputDescriptor;
import org.eclipse.sirius.synchronizer.PreRefreshStatus;
import org.eclipse.sirius.synchronizer.RefreshPlan;
import org.eclipse.sirius.synchronizer.RefreshPlanner;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.synchronizer.SignatureProvider;

public class ModelToModelSynchronizer {
    private SemanticPartitionInvalidator evaluator;
    private MappingHiearchyTable table;
    private PreRefreshStatus pre;
    private SignatureProvider signatureProvider;

    public ModelToModelSynchronizer(SemanticPartitionInvalidator evaluator, MappingHiearchyTable table, PreRefreshStatus pre, SignatureProvider signProvider) {
        this.evaluator = evaluator;
        this.table = table;
        this.pre = pre;
        this.signatureProvider = signProvider;
    }

    public void update(CreatedOutput container) {
        RefreshPlan plan = new RefreshPlanner(this.table, this.evaluator, this.pre, this.signatureProvider).computePlan(container);
        if (container.getChildSupport().some()) {
            ChildCreationSupport containerChildSupport = (ChildCreationSupport)container.getChildSupport().get();
            for (CreatedOutput outDesc : plan.getDescriptorsToDelete()) {
                containerChildSupport.deleteChild(outDesc);
            }
            ArrayList newlyCreated = Lists.newArrayList();
            for (OutputDescriptor outDesc : plan.getDescriptorsToCreate()) {
                CreatedOutput newOne = containerChildSupport.createChild(outDesc);
                newOne.refresh();
                newlyCreated.add(newOne);
            }
            Iterable createdOrRefreshed = Iterables.concat(plan.getDescriptorsToRefresh(), (Iterable)newlyCreated);
            containerChildSupport.reorderChilds(createdOrRefreshed);
            for (CreatedOutput createdOutput : createdOrRefreshed) {
                this.update(createdOutput);
            }
        }
        for (CreatedOutput outDesc : plan.getDescriptorToUpdateMapping()) {
            outDesc.updateMapping();
            outDesc.refresh();
        }
        for (CreatedOutput outDesc : plan.getDescriptorsToRefresh()) {
            outDesc.refresh();
        }
    }
}

