/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.symbols.provider;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.AbstractShapeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ProviderNotificationManager;
import org.eclipse.papyrus.uml.diagram.symbols.Activator;
import org.eclipse.papyrus.uml.tools.listeners.PapyrusStereotypeListener;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.w3c.dom.svg.SVGDocument;

public class TypedElementShapeProvider
extends AbstractShapeProvider {
    public List<RenderedImage> getShapes(EObject view) {
        block10: {
            Type type = this.getType(view);
            String path = this.getSymbolPath(type);
            if (path != null && path.length() > 0) {
                URL url;
                List<SVGDocument> documents = this.getSVGDocument(view);
                if (documents != null && !documents.isEmpty()) {
                    LinkedList<RenderedImage> result = new LinkedList<RenderedImage>();
                    for (SVGDocument document : documents) {
                        if (document == null) continue;
                        try {
                            result.add(this.renderSVGDocument(view, document));
                        }
                        catch (IOException ex) {
                            Activator.log.error((Throwable)ex);
                        }
                    }
                    if (!result.isEmpty()) {
                        return result;
                    }
                }
                try {
                    url = new URL(path);
                    return Arrays.asList(RenderedImageFactory.getInstance((URL)url));
                }
                catch (MalformedURLException e) {
                    URI typeResourceURI = type.eResource().getURI();
                    if (typeResourceURI == null) break block10;
                    String workspaceRelativeFolderPath = typeResourceURI.trimSegments(1).toPlatformString(true);
                    try {
                        url = new URL("platform:/resource/" + workspaceRelativeFolderPath + File.separatorChar + path);
                        return Arrays.asList(RenderedImageFactory.getInstance((URL)url));
                    }
                    catch (MalformedURLException e1) {
                        Activator.log.error((Throwable)e1);
                    }
                }
            }
        }
        return null;
    }

    public List<SVGDocument> getSVGDocument(EObject view) {
        block4: {
            Type type = this.getType(view);
            String path = this.getSymbolPath(type);
            if (path != null && path.length() > 0) {
                try {
                    new URL(path);
                    SVGDocument document = this.getSVGDocument(path);
                    if (document != null) {
                        return Arrays.asList(document);
                    }
                    return null;
                }
                catch (MalformedURLException e) {
                    String workspaceRelativeFolderPath;
                    String newPath;
                    SVGDocument document;
                    URI typeResourceURI = EcoreUtil.getURI((EObject)type).trimFragment();
                    if (typeResourceURI == null || (document = this.getSVGDocument(newPath = URI.createPlatformResourceURI((String)(String.valueOf(workspaceRelativeFolderPath = typeResourceURI.trimSegments(1).toPlatformString(true)) + File.separatorChar + path), (boolean)false).toString())) == null) break block4;
                    return Arrays.asList(document);
                }
            }
        }
        return null;
    }

    public boolean providesShapes(EObject view) {
        Type type = this.getType(view);
        String path = this.getSymbolPath(type);
        return path != null && path.length() > 0;
    }

    protected Type getType(EObject view) {
        if (!(view instanceof View)) {
            return null;
        }
        EObject element = ((View)view).getElement();
        if (element instanceof Type) {
            return (Type)element;
        }
        if (element instanceof TypedElement) {
            return ((TypedElement)element).getType();
        }
        return null;
    }

    protected String getSymbolPath(Type type) {
        if (type == null) {
            return null;
        }
        Stereotype stereotype = type.getAppliedStereotype("PapyrusInternal::Symbols::TypeSymbolDefinition");
        if (stereotype == null) {
            return null;
        }
        Object path = type.getValue(stereotype, "symbolPath");
        if (path instanceof String && ((String)path).length() > 0) {
            return path.toString();
        }
        return null;
    }

    public ProviderNotificationManager createProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
        if (view == null || !(view instanceof View)) {
            return null;
        }
        TypedElementShapeProviderNotificationManager notificationManager = new TypedElementShapeProviderNotificationManager(diagramEventBroker, view, listener);
        return notificationManager;
    }

    public class TypedElementShapeProviderNotificationManager
    extends ProviderNotificationManager
    implements NotificationListener {
        public TypedElementShapeProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
            super(diagramEventBroker, view, listener);
        }

        protected void registerListeners() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            EObject semanticElement = ((View)this.view).getElement();
            if (semanticElement instanceof Type) {
                this.diagramEventBroker.addNotificationListener((EObject)((Type)semanticElement), (NotificationListener)this);
            } else if (semanticElement instanceof TypedElement) {
                this.diagramEventBroker.addNotificationListener((EObject)((TypedElement)semanticElement), (NotificationListener)this);
                Type type = ((TypedElement)semanticElement).getType();
                if (type != null) {
                    this.diagramEventBroker.addNotificationListener((EObject)type, (NotificationListener)this);
                }
            }
        }

        public void dispose() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            EObject semanticElement = ((View)this.view).getElement();
            if (semanticElement instanceof Type) {
                this.diagramEventBroker.removeNotificationListener((EObject)((Type)semanticElement), (NotificationListener)this);
            } else if (semanticElement instanceof TypedElement) {
                this.diagramEventBroker.removeNotificationListener((EObject)((TypedElement)semanticElement), (NotificationListener)this);
                Type type = ((TypedElement)semanticElement).getType();
                if (type != null) {
                    this.diagramEventBroker.removeNotificationListener((EObject)type, (NotificationListener)this);
                }
            }
            super.dispose();
        }

        public void notifyChanged(Notification notification) {
            if (this.listener == null) {
                return;
            }
            if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(notification.getFeature())) {
                Object newValue;
                this.listener.notifyChanged(notification);
                Object oldValue = notification.getOldValue();
                if (oldValue instanceof Type) {
                    this.diagramEventBroker.removeNotificationListener((EObject)((Type)oldValue), (NotificationListener)this);
                }
                if ((newValue = notification.getNewValue()) instanceof Type) {
                    this.diagramEventBroker.removeNotificationListener((EObject)((Type)newValue), (NotificationListener)this);
                }
            } else if (notification instanceof PapyrusStereotypeListener.StereotypeCustomNotification) {
                this.listener.notifyChanged(notification);
            }
        }
    }
}

