/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.symbols.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.AbstractShapeProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.service.shape.ProviderNotificationManager;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.symbols.Activator;
import org.eclipse.papyrus.uml.tools.utils.ElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.Stereotype;
import org.w3c.dom.svg.SVGDocument;

public class StereotypedElementShapeProvider
extends AbstractShapeProvider {
    private static final String SHAPE_CONSTANT = "shape";

    public List<RenderedImage> getShapes(EObject view) {
        if (!(view instanceof View)) {
            return null;
        }
        EObject element = ((View)view).getElement();
        if (element instanceof Element) {
            ArrayList<RenderedImage> images = new ArrayList<RenderedImage>();
            String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)view));
            StringTokenizer tokenizer = new StringTokenizer(stereotypesToDisplay, ",");
            while (tokenizer.hasMoreTokens()) {
                try {
                    String stereotypeName = tokenizer.nextToken();
                    Stereotype stereotype = ((Element)element).getAppliedStereotype(stereotypeName);
                    Image icon = ElementUtil.getStereotypeImage((Element)((Element)element), (Stereotype)stereotype, (String)SHAPE_CONSTANT);
                    if (icon == null || "".equals(icon.getLocation()) || icon.getLocation() == null) continue;
                    SVGDocument document = this.getSVGDocument(icon.getLocation());
                    if (document != null) {
                        images.add(this.renderSVGDocument(view, document));
                        continue;
                    }
                    URL url = new URL(icon.getLocation());
                    images.add(RenderedImageFactory.getInstance((URL)url));
                }
                catch (Exception ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
            return images;
        }
        return null;
    }

    public boolean providesShapes(EObject view) {
        String firstStereotypeName;
        Stereotype stereotype;
        Image icon;
        String stereotypesToDisplay;
        StringTokenizer tokenizer;
        if (!(view instanceof View)) {
            return false;
        }
        EObject element = ((View)view).getElement();
        return element instanceof Element && (tokenizer = new StringTokenizer(stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)view)), ",")).hasMoreTokens() && (icon = ElementUtil.getStereotypeImage((Element)((Element)element), (Stereotype)(stereotype = ((Element)element).getAppliedStereotype(firstStereotypeName = tokenizer.nextToken())), (String)SHAPE_CONSTANT)) != null && icon.getLocation() != "" && icon.getLocation() != null;
    }

    public List<SVGDocument> getSVGDocument(EObject view) {
        if (!(view instanceof View)) {
            return null;
        }
        EObject element = ((View)view).getElement();
        if (element instanceof Element) {
            ArrayList<SVGDocument> images = new ArrayList<SVGDocument>();
            String stereotypesToDisplay = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)((View)view));
            StringTokenizer tokenizer = new StringTokenizer(stereotypesToDisplay, ",");
            while (tokenizer.hasMoreTokens()) {
                SVGDocument document;
                String stereotypeName = tokenizer.nextToken();
                Stereotype stereotype = ((Element)element).getAppliedStereotype(stereotypeName);
                Image icon = ElementUtil.getStereotypeImage((Element)((Element)element), (Stereotype)stereotype, (String)SHAPE_CONSTANT);
                if (icon == null || icon.getLocation() == "" || icon.getLocation() == null || (document = this.getSVGDocument(icon.getLocation())) == null) continue;
                images.add(document);
            }
            return images;
        }
        return null;
    }

    public ProviderNotificationManager createProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
        if (view == null || !(view instanceof View)) {
            return null;
        }
        StereotypedElementShapeProviderNotificationManager notificationManager = new StereotypedElementShapeProviderNotificationManager(diagramEventBroker, view, listener);
        return notificationManager;
    }

    public class StereotypedElementShapeProviderNotificationManager
    extends ProviderNotificationManager
    implements NotificationListener {
        public StereotypedElementShapeProviderNotificationManager(DiagramEventBroker diagramEventBroker, EObject view, NotificationListener listener) {
            super(diagramEventBroker, view, listener);
        }

        protected void registerListeners() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            this.diagramEventBroker.addNotificationListener(this.view, (NotificationListener)this);
        }

        public void dispose() {
            if (this.view == null || !(this.view instanceof View)) {
                return;
            }
            this.diagramEventBroker.removeNotificationListener(this.view, (NotificationListener)this);
            super.dispose();
        }

        public void notifyChanged(Notification notification) {
            Object newValue;
            if (this.listener == null) {
                return;
            }
            if (EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(notification.getFeature()) && (newValue = notification.getNewValue()) instanceof EAnnotation && "Stereotype_Annotation".equals(((EAnnotation)newValue).getSource())) {
                this.listener.notifyChanged(notification);
            }
        }
    }
}

