/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.query.DCellQuery;
import org.eclipse.sirius.table.business.api.query.DTableElementStyleQuery;
import org.eclipse.sirius.table.business.api.query.StyleUpdaterQuery;
import org.eclipse.sirius.table.business.internal.color.TableStyleColorUpdater;
import org.eclipse.sirius.table.business.internal.refresh.StyleWithDefaultStatus;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DCellStyle;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.DTableElementStyle;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.TableFactory;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.metamodel.table.description.BackgroundConditionalStyle;
import org.eclipse.sirius.table.metamodel.table.description.BackgroundStyleDescription;
import org.eclipse.sirius.table.metamodel.table.description.CellUpdater;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.FeatureColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.ForegroundConditionalStyle;
import org.eclipse.sirius.table.metamodel.table.description.ForegroundStyleDescription;
import org.eclipse.sirius.table.metamodel.table.description.IntersectionMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.StyleUpdater;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.metamodel.table.impl.DTableElementSynchronizerImpl;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.description.ColorDescription;
import org.eclipse.sirius.viewpoint.description.FixedColor;

public class DTableElementSynchronizerSpec
extends DTableElementSynchronizerImpl {
    private final ModelAccessor accessor;
    private final IInterpreter interpreter;
    private final AdapterFactory pluginRegisteredAdapterFactory;

    public DTableElementSynchronizerSpec(ModelAccessor accessor, IInterpreter interpreter) {
        this.interpreter = interpreter;
        this.accessor = accessor;
        this.pluginRegisteredAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    }

    @Override
    public void refresh(DLine line) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)line)) {
            LineMapping mapping = line.getOriginMapping();
            if (!StringUtil.isEmpty((String)mapping.getHeaderLabelExpression())) {
                try {
                    String label = this.interpreter.evaluateString(line.getTarget(), mapping.getHeaderLabelExpression());
                    if (this.isDifferent(line.getLabel(), label)) {
                        line.setLabel(label);
                    }
                }
                catch (EvaluationException evaluationException) {}
            } else {
                String label = this.getLabelProvider(line.getTarget()).getText((Object)line.getTarget());
                if (this.isDifferent(line.getLabel(), label)) {
                    line.setLabel(label);
                }
            }
            this.refreshStyle(line);
        }
    }

    @Override
    public void refresh(DCell cell) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)cell) && this.refreshTarget(cell) && this.refreshLabel(cell)) {
            this.refreshStyle(cell);
            this.refreshSemanticElements(cell);
        }
    }

    @Override
    public void refresh(DColumn column) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)column)) {
            if (column instanceof DTargetColumn) {
                this.refresh((DTargetColumn)column);
            } else {
                super.refresh(column);
            }
        }
    }

    private void refresh(DTargetColumn column) {
        ColumnMapping mapping = column.getOriginMapping();
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)column)) {
            if (!StringUtil.isEmpty((String)mapping.getHeaderLabelExpression())) {
                try {
                    String label = this.interpreter.evaluateString(column.getTarget(), mapping.getHeaderLabelExpression());
                    if (this.isDifferent(column.getLabel(), label)) {
                        column.setLabel(label);
                    }
                }
                catch (EvaluationException evaluationException) {}
            } else {
                String label = this.getLabelProvider(column.getTarget()).getText((Object)column.getTarget());
                if (this.isDifferent(column.getLabel(), label)) {
                    column.setLabel(label);
                }
            }
            if (mapping.getInitialWidth() != 0 && column.getWidth() == 0) {
                column.setWidth(mapping.getInitialWidth());
            }
            this.refreshStyle(column);
        }
    }

    public void refresh(DFeatureColumn column) {
        ColumnMapping mapping = column.getOriginMapping();
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)column)) {
            if (this.isDifferent(column.getLabel(), mapping.getHeaderLabelExpression())) {
                column.setLabel(mapping.getHeaderLabelExpression());
            }
            if (mapping.getInitialWidth() != 0 && column.getWidth() == 0) {
                column.setWidth(mapping.getInitialWidth());
            }
            this.refreshStyle(column);
        }
    }

    public boolean refreshTarget(DCell cell) {
        boolean deletedCell = false;
        if (cell.getLine() != null) {
            EObject featureParent = cell.getLine().getTarget();
            if (cell.getColumn() instanceof DFeatureColumn) {
                FeatureColumnMapping featureColumnMapping = (FeatureColumnMapping)cell.getColumn().getMapping();
                String featureParentExpression = featureColumnMapping.getFeatureParentExpression();
                if (featureParentExpression != null && featureParentExpression.length() > 0) {
                    DTable table = TableHelper.getTable(cell);
                    this.interpreter.setVariable("container", (Object)cell.getLine().getTarget());
                    if (table != null) {
                        this.interpreter.setVariable("root", (Object)table.getTarget());
                    }
                    if (TableHelper.hasTableDescriptionOnlyOneLineMapping(cell)) {
                        featureParent = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateEObject(cell.getLine().getTarget(), (EObject)featureColumnMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getFeatureColumnMapping_FeatureParentExpression());
                    } else {
                        try {
                            featureParent = this.interpreter.evaluateEObject(cell.getLine().getTarget(), featureParentExpression);
                        }
                        catch (EvaluationException evaluationException) {}
                    }
                    this.interpreter.unSetVariable("container");
                    if (table != null) {
                        this.interpreter.unSetVariable("root");
                    }
                }
                if (featureParent == null) {
                    this.removeUneededCell(cell);
                    deletedCell = true;
                } else if (!featureParent.equals(cell.getTarget())) {
                    if (this.accessor.eValid(featureParent, featureColumnMapping.getFeatureName())) {
                        cell.setTarget(featureParent);
                    } else {
                        this.removeUneededCell(cell);
                        deletedCell = true;
                    }
                }
            }
        }
        return !deletedCell;
    }

    public boolean refreshLabel(DCell cell) {
        CellUpdater updater;
        boolean cellStillExists = false;
        if (cell.getColumn() != null && (updater = cell.getUpdater()) != null) {
            String labelExpression = updater.getLabelComputationExpression();
            cellStillExists = updater instanceof IntersectionMapping && cell.getLabel() != null ? this.refreshLabelIntersectionMapping(cell, labelExpression) : this.refreshLabel(cell, labelExpression);
        }
        if (!cellStillExists) {
            this.removeUneededCell(cell);
        }
        return cellStillExists;
    }

    protected void removeUneededCell(DCell cell) {
        ECrossReferenceAdapter xref;
        cell.deactivate();
        Session session = SessionManager.INSTANCE.getSession(cell.getTarget());
        ECrossReferenceAdapter eCrossReferenceAdapter = xref = session != null ? session.getSemanticCrossReferencer() : null;
        if (this.accessor.getPermissionAuthority().canDeleteInstance((EObject)cell)) {
            this.accessor.eDelete((EObject)cell, xref);
        }
    }

    private boolean refreshLabelIntersectionMapping(DCell cell, String labelExpression) {
        Collection<EObject> foundColumnTargets;
        boolean cellNeeded = false;
        DLine line = cell.getLine();
        DColumn column = cell.getColumn();
        if (line != null && line.getTarget() != null && column != null && column.getTarget() != null && (foundColumnTargets = this.evaluateColumnFinderExpression(cell, cell.getIntersectionMapping())) != null && foundColumnTargets.contains(column.getTarget()) && this.evaluateIntersectionPrecondition(cell.getColumn().getTarget(), cell.getLine(), cell.getColumn(), cell.getIntersectionMapping().getPreconditionExpression())) {
            cellNeeded = this.refreshLabel(cell, labelExpression);
        }
        return cellNeeded;
    }

    private Collection<EObject> evaluateColumnFinderExpression(DCell cell, IntersectionMapping iMapping) {
        EObject preconditionContext = iMapping.isUseDomainClass() ? cell.getTarget() : cell.getLine().getTarget();
        try {
            return this.interpreter.evaluateCollection(preconditionContext, iMapping.getColumnFinderExpression());
        }
        catch (EvaluationException evaluationException) {
            return new ArrayList<EObject>(0);
        }
    }

    private boolean evaluateIntersectionPrecondition(EObject semanticElement, DLine line, DColumn column, String preconditionExpression) {
        DslCommonPlugin.PROFILER.startWork("Check precondition expressions");
        boolean result = true;
        if (!StringUtil.isEmpty((String)preconditionExpression)) {
            this.interpreter.setVariable("line", (Object)line);
            this.interpreter.setVariable("lineSemantic", (Object)line.getTarget());
            this.interpreter.setVariable("column", (Object)column);
            this.interpreter.setVariable("columnSemantic", (Object)column.getTarget());
            this.interpreter.setVariable("table", (Object)TableHelper.getTable(line));
            try {
                result = this.interpreter.evaluateBoolean(semanticElement, preconditionExpression);
            }
            catch (EvaluationException evaluationException) {}
            this.interpreter.unSetVariable("line");
            this.interpreter.unSetVariable("lineSemantic");
            this.interpreter.unSetVariable("column");
            this.interpreter.unSetVariable("columnSemantic");
            this.interpreter.unSetVariable("table");
        }
        DslCommonPlugin.PROFILER.stopWork("Check precondition expressions");
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean refreshLabel(DCell cell, String labelExpression) {
        boolean cellNeeded = false;
        if (!StringUtil.isEmpty((String)labelExpression)) {
            if (cell.getTarget() == null) return cellNeeded;
            try {
                try {
                    DTable table;
                    if (cell.getLine() != null) {
                        this.interpreter.setVariable("line", (Object)cell.getLine());
                        this.interpreter.setVariable("lineSemantic", (Object)cell.getLine().getTarget());
                        this.interpreter.setVariable("container", (Object)cell.getLine().getTarget());
                    }
                    if (cell.getColumn() != null) {
                        this.interpreter.setVariable("column", (Object)cell.getColumn());
                        this.interpreter.setVariable("columnSemantic", (Object)cell.getColumn().getTarget());
                    }
                    if ((table = TableHelper.getTable(cell)) != null) {
                        this.interpreter.setVariable("root", (Object)table.getTarget());
                    }
                    String label = this.interpreter.evaluateString(cell.getTarget(), labelExpression);
                    cellNeeded = true;
                    if (!this.isDifferent(cell.getLabel(), label)) return cellNeeded;
                    cell.setLabel(label);
                    return cellNeeded;
                }
                catch (EvaluationException e) {
                    if (TableHelper.hasTableDescriptionOnlyOneLineMapping(cell)) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)cell.getUpdater(), (EStructuralFeature)TablePackage.eINSTANCE.getDCell_Label(), (Throwable)e);
                    }
                    if (cell.getLine() != null) {
                        this.interpreter.unSetVariable("container");
                        this.interpreter.unSetVariable("line");
                        this.interpreter.unSetVariable("lineSemantic");
                    }
                    if (cell.getColumn() != null) {
                        this.interpreter.unSetVariable("column");
                        this.interpreter.unSetVariable("columnSemantic");
                    }
                    this.interpreter.unSetVariable("root");
                }
                return cellNeeded;
            }
            finally {
                if (cell.getLine() != null) {
                    this.interpreter.unSetVariable("container");
                    this.interpreter.unSetVariable("line");
                    this.interpreter.unSetVariable("lineSemantic");
                }
                if (cell.getColumn() != null) {
                    this.interpreter.unSetVariable("column");
                    this.interpreter.unSetVariable("columnSemantic");
                }
                this.interpreter.unSetVariable("root");
            }
        } else {
            ColumnMapping columnMapping = cell.getColumn().getOriginMapping();
            if (columnMapping instanceof FeatureColumnMapping) {
                if (cell.getTarget() == null) return cellNeeded;
                String featureName = ((FeatureColumnMapping)columnMapping).getFeatureName();
                if (!StringUtil.isEmpty((String)featureName)) {
                    return this.setLabelWithFeatureValue(cell, columnMapping, featureName);
                }
                cell.setLabel("");
                return cellNeeded;
            } else {
                cellNeeded = true;
                if (!this.isDifferent(cell.getLabel(), null)) return cellNeeded;
                cell.setLabel(null);
            }
        }
        return cellNeeded;
    }

    private boolean setLabelWithFeatureValue(DCell cell, ColumnMapping columnMapping, String featureName) {
        IItemPropertyDescriptor itemPropertyDescriptor = this.getPropertyDescriptor(cell.getTarget(), featureName);
        boolean init = false;
        try {
            Object featureObject = this.accessor.eGet(cell.getTarget(), featureName);
            if (itemPropertyDescriptor != null && itemPropertyDescriptor.getLabelProvider(featureObject) != null) {
                String label = itemPropertyDescriptor.getLabelProvider(featureObject).getText(featureObject);
                init = true;
                if (this.isDifferent(cell.getLabel(), label)) {
                    cell.setLabel(label);
                }
            }
        }
        catch (FeatureNotFoundException e) {
            RuntimeLoggerManager.INSTANCE.error((EObject)columnMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getFeatureColumnMapping_FeatureName(), (Throwable)e);
        }
        return init;
    }

    public void refreshStyle(DCell cell) {
        DCellStyle style = cell.getCurrentStyle();
        if (style == null) {
            style = TableFactory.eINSTANCE.createDCellStyle();
        }
        this.doUpdateStyle(cell, style);
        if (cell.getCurrentStyle() == null && new DTableElementStyleQuery(style).isSet()) {
            cell.setCurrentStyle(style);
        }
    }

    private void doUpdateStyle(DCell cell, DCellStyle style) {
        TableStyleColorUpdater colorUpdater = new TableStyleColorUpdater();
        StyleWithDefaultStatus bestBackgroundStyle = this.getBestBackgroundColor(cell);
        if (bestBackgroundStyle != null) {
            colorUpdater.updateBackgroundColor(style, ((BackgroundStyleDescription)bestBackgroundStyle.getStyle()).getBackgroundColor(), bestBackgroundStyle.isDefaultStyle(), cell.getTarget());
            if (new DCellQuery(cell).isStyleDescriptionInIntersectionMapping(bestBackgroundStyle.getStyle())) {
                style.setBackgroundStyleOrigin(cell.getIntersectionMapping());
            } else {
                style.setBackgroundStyleOrigin(cell.getColumn().getOriginMapping());
            }
        } else {
            this.reset(style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_BackgroundColor());
            this.reset(style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultBackgroundStyle());
        }
        StyleWithDefaultStatus bestForegroundStyle = this.getBestForegroundStyle(cell);
        if (bestForegroundStyle != null) {
            ForegroundStyleDescription bestForegroundStyleDesc = (ForegroundStyleDescription)bestForegroundStyle.getStyle();
            colorUpdater.updateForegroundColor(style, ((ForegroundStyleDescription)bestForegroundStyle.getStyle()).getForeGroundColor(), bestForegroundStyle.isDefaultStyle(), cell.getTarget());
            if (new DCellQuery(cell).isStyleDescriptionInIntersectionMapping(bestForegroundStyle.getStyle())) {
                style.setForegroundStyleOrigin(cell.getIntersectionMapping());
            } else {
                style.setForegroundStyleOrigin(cell.getColumn().getOriginMapping());
            }
            if (bestForegroundStyleDesc.getLabelFormat() != null && !this.isEqual(style.getLabelFormat(), bestForegroundStyleDesc.getLabelFormat())) {
                style.setLabelFormat(bestForegroundStyleDesc.getLabelFormat());
            }
            if (bestForegroundStyleDesc.getLabelSize() != -1 && style.getLabelSize() != bestForegroundStyleDesc.getLabelSize()) {
                style.setLabelSize(bestForegroundStyleDesc.getLabelSize());
            }
        } else {
            this.reset(style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_ForegroundColor());
            this.reset(style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelFormat());
            this.reset(style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize());
            this.reset(style, (EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultForegroundStyle());
        }
    }

    protected void refreshStyle(DLine line) {
        DTableElementStyle style = line.getCurrentStyle();
        if (style == null) {
            style = TableFactory.eINSTANCE.createDTableElementStyle();
        }
        this.doUpdateStyle(line, style);
        if (line.getCurrentStyle() == null && new DTableElementStyleQuery(style).isSet()) {
            line.setCurrentStyle(style);
        }
    }

    private void doUpdateStyle(DLine line, DTableElementStyle style) {
        TableStyleColorUpdater colorUpdater = new TableStyleColorUpdater();
        ColorDescription bestBackgroundColor = this.getBestBackgroundColor(line);
        if (bestBackgroundColor != null) {
            colorUpdater.updateBackgroundColor(style, bestBackgroundColor, new StyleUpdaterQuery(line.getOriginMapping()).isDefaultBackgroundColor(bestBackgroundColor), line.getTarget());
        } else {
            if (style.getBackgroundColor() != null) {
                style.setBackgroundColor(null);
            }
            if (style.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultBackgroundStyle())) {
                style.eUnset((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultBackgroundStyle());
            }
        }
        ForegroundStyleDescription bestForegroundStyle = this.getBestForegroundStyle(line);
        if (bestForegroundStyle != null) {
            boolean defaultStyleDescription = new StyleUpdaterQuery(line.getOriginMapping()).isDefaultForegroundColor(bestForegroundStyle.getForeGroundColor());
            colorUpdater.updateForegroundColor(style, bestForegroundStyle.getForeGroundColor(), defaultStyleDescription, line.getTarget());
            if (bestForegroundStyle.getLabelFormat() != null && !this.isEqual(style.getLabelFormat(), bestForegroundStyle.getLabelFormat())) {
                style.setLabelFormat(bestForegroundStyle.getLabelFormat());
            }
            if (bestForegroundStyle.getLabelSize() != -1 && style.getLabelSize() != bestForegroundStyle.getLabelSize()) {
                style.setLabelSize(bestForegroundStyle.getLabelSize());
            }
            style.setDefaultForegroundStyle(defaultStyleDescription);
        } else {
            if (style.getForegroundColor() != null) {
                style.setForegroundColor(null);
            }
            if (style.getLabelFormat() != null) {
                style.setLabelFormat(null);
            }
            if (style.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize())) {
                style.eUnset((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize());
            }
            if (style.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultForegroundStyle())) {
                style.eUnset((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultForegroundStyle());
            }
        }
    }

    protected void refreshStyle(DColumn column) {
        DTableElementStyle style = column.getCurrentStyle();
        if (style == null) {
            style = TableFactory.eINSTANCE.createDTableElementStyle();
        }
        this.doUpdateStyle(column, style);
        if (column.getCurrentStyle() == null && new DTableElementStyleQuery(style).isSet()) {
            column.setCurrentStyle(style);
        }
    }

    private void doUpdateStyle(DColumn column, DTableElementStyle style) {
        StyleUpdater styleUpdater = null;
        if (column.getOriginMapping() instanceof FeatureColumnMapping || column.getOriginMapping() instanceof ElementColumnMapping) {
            styleUpdater = (StyleUpdater)((Object)column.getOriginMapping());
        }
        TableStyleColorUpdater colorUpdater = new TableStyleColorUpdater();
        ColorDescription bestBackgroundColor = this.getBestBackgroundColor(column);
        if (bestBackgroundColor != null) {
            colorUpdater.updateBackgroundColor(style, bestBackgroundColor, new StyleUpdaterQuery(styleUpdater).isDefaultBackgroundColor(bestBackgroundColor), column.getTarget());
        } else {
            if (style.getBackgroundColor() != null) {
                style.setBackgroundColor(null);
            }
            if (style.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultBackgroundStyle())) {
                style.eUnset((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultBackgroundStyle());
            }
        }
        ForegroundStyleDescription bestForegroundStyle = this.getBestForegroundStyle(column);
        if (bestForegroundStyle != null) {
            boolean defaultStyleDescription = new StyleUpdaterQuery(styleUpdater).isDefaultForegroundColor(bestForegroundStyle.getForeGroundColor());
            colorUpdater.updateForegroundColor(style, bestForegroundStyle.getForeGroundColor(), defaultStyleDescription, column.getTarget());
            if (bestForegroundStyle.getLabelFormat() != null && !this.isEqual(style.getLabelFormat(), bestForegroundStyle.getLabelFormat())) {
                style.setLabelFormat(bestForegroundStyle.getLabelFormat());
            }
            if (bestForegroundStyle.getLabelSize() != -1 && style.getLabelSize() != bestForegroundStyle.getLabelSize()) {
                style.setLabelSize(bestForegroundStyle.getLabelSize());
            }
            style.setDefaultForegroundStyle(defaultStyleDescription);
        } else {
            if (style.getForegroundColor() != null) {
                style.setForegroundColor(null);
            }
            if (style.getLabelFormat() != null) {
                style.setLabelFormat(null);
            }
            if (style.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize())) {
                style.eUnset((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_LabelSize());
            }
            if (style.eIsSet((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultForegroundStyle())) {
                style.eUnset((EStructuralFeature)TablePackage.eINSTANCE.getDTableElementStyle_DefaultForegroundStyle());
            }
        }
    }

    private boolean isEqual(FontFormat labelFormat, FontFormat labelFormat2) {
        if (labelFormat != null && labelFormat2 != null) {
            return labelFormat.getLiteral().equals(labelFormat2.getLiteral());
        }
        return false;
    }

    private StyleWithDefaultStatus getBestBackgroundColor(DCell cell) {
        RuntimeLoggerInterpreter safeInterpreter;
        boolean predicate;
        BackgroundStyleDescription bestBackgroundStyleDesc = null;
        boolean bestBackgroundColorIsConditonal = false;
        IntersectionMapping cellStyleUpdater = cell.getIntersectionMapping();
        StyleUpdater columnStyleUpdater = null;
        if (cell.getColumn() != null && (cell.getColumn().getOriginMapping() instanceof FeatureColumnMapping || cell.getColumn().getOriginMapping() instanceof ElementColumnMapping)) {
            columnStyleUpdater = (StyleUpdater)((Object)cell.getColumn().getOriginMapping());
        }
        if (cellStyleUpdater != null && cellStyleUpdater.getDefaultBackground() != null && cellStyleUpdater.getDefaultBackground().getBackgroundColor() != null) {
            bestBackgroundStyleDesc = cellStyleUpdater.getDefaultBackground();
        }
        if (columnStyleUpdater != null && bestBackgroundStyleDesc == null && columnStyleUpdater.getDefaultBackground() != null && !(columnStyleUpdater.getDefaultBackground().getBackgroundColor() instanceof FixedColor)) {
            bestBackgroundStyleDesc = columnStyleUpdater.getDefaultBackground();
        }
        if (cellStyleUpdater != null) {
            for (BackgroundConditionalStyle condStyle : cellStyleUpdater.getBackgroundConditionalStyle()) {
                if (bestBackgroundColorIsConditonal || condStyle.getStyle() == null || cell.getTarget() == null || !(predicate = (safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter)).evaluateBoolean(cell.getTarget(), (EObject)condStyle, (EStructuralFeature)DescriptionPackage.eINSTANCE.getBackgroundConditionalStyle_PredicateExpression()))) continue;
                bestBackgroundStyleDesc = condStyle.getStyle();
                bestBackgroundColorIsConditonal = true;
            }
        }
        if (columnStyleUpdater != null) {
            for (BackgroundConditionalStyle condStyle : columnStyleUpdater.getBackgroundConditionalStyle()) {
                if (bestBackgroundColorIsConditonal || condStyle.getStyle() == null || cell.getTarget() == null || !(predicate = (safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter)).evaluateBoolean(cell.getTarget(), (EObject)condStyle, (EStructuralFeature)DescriptionPackage.eINSTANCE.getBackgroundConditionalStyle_PredicateExpression()))) continue;
                bestBackgroundStyleDesc = condStyle.getStyle();
                bestBackgroundColorIsConditonal = true;
            }
        }
        if (bestBackgroundStyleDesc != null) {
            return new StyleWithDefaultStatus(bestBackgroundStyleDesc, !bestBackgroundColorIsConditonal);
        }
        return null;
    }

    private ColorDescription getBestBackgroundColor(DLine line) {
        ColorDescription bestBackgroundColor = null;
        boolean bestBackgroundColorIsConditonal = false;
        LineMapping styleUpdater = line.getOriginMapping();
        if (styleUpdater.getDefaultBackground() != null && styleUpdater.getDefaultBackground().getBackgroundColor() != null) {
            bestBackgroundColor = styleUpdater.getDefaultBackground().getBackgroundColor();
        }
        for (BackgroundConditionalStyle condStyle : styleUpdater.getBackgroundConditionalStyle()) {
            RuntimeLoggerInterpreter safeInterpreter;
            boolean predicate;
            if (bestBackgroundColorIsConditonal || condStyle.getStyle() == null || line.getTarget() == null || !(predicate = (safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter)).evaluateBoolean(line.getTarget(), (EObject)condStyle, (EStructuralFeature)DescriptionPackage.eINSTANCE.getBackgroundConditionalStyle_PredicateExpression()))) continue;
            bestBackgroundColor = condStyle.getStyle().getBackgroundColor();
            bestBackgroundColorIsConditonal = true;
        }
        return bestBackgroundColor;
    }

    private ColorDescription getBestBackgroundColor(DColumn column) {
        ColorDescription bestBackgroundColor = null;
        StyleUpdater styleUpdater = null;
        if (column.getOriginMapping() instanceof FeatureColumnMapping || column.getOriginMapping() instanceof ElementColumnMapping) {
            styleUpdater = (StyleUpdater)((Object)column.getOriginMapping());
        }
        if (styleUpdater.getDefaultBackground() != null && styleUpdater.getDefaultBackground().getBackgroundColor() instanceof FixedColor) {
            bestBackgroundColor = styleUpdater.getDefaultBackground().getBackgroundColor();
        }
        return bestBackgroundColor;
    }

    private StyleWithDefaultStatus getBestForegroundStyle(DCell cell) {
        RuntimeLoggerInterpreter safeInterpreter;
        boolean predicate;
        ForegroundStyleDescription bestForegroundStyleDesc = null;
        boolean bestForegroundColorIsConditonal = false;
        IntersectionMapping cellStyleUpdater = cell.getIntersectionMapping();
        StyleUpdater columnStyleUpdater = null;
        if (cell.getColumn() != null && (cell.getColumn().getOriginMapping() instanceof FeatureColumnMapping || cell.getColumn().getOriginMapping() instanceof ElementColumnMapping)) {
            columnStyleUpdater = (StyleUpdater)((Object)cell.getColumn().getOriginMapping());
        }
        if (cellStyleUpdater != null && cellStyleUpdater.getDefaultForeground() != null && cellStyleUpdater.getDefaultForeground().getForeGroundColor() != null) {
            bestForegroundStyleDesc = cellStyleUpdater.getDefaultForeground();
        }
        if (columnStyleUpdater != null && bestForegroundStyleDesc == null && columnStyleUpdater.getDefaultForeground() != null && !(columnStyleUpdater.getDefaultForeground().getForeGroundColor() instanceof FixedColor)) {
            bestForegroundStyleDesc = columnStyleUpdater.getDefaultForeground();
        }
        if (cellStyleUpdater != null) {
            for (ForegroundConditionalStyle condStyle : cellStyleUpdater.getForegroundConditionalStyle()) {
                if (bestForegroundColorIsConditonal || condStyle.getStyle() == null || cell.getTarget() == null || !(predicate = (safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter)).evaluateBoolean(cell.getTarget(), (EObject)condStyle, (EStructuralFeature)DescriptionPackage.eINSTANCE.getForegroundConditionalStyle_PredicateExpression()))) continue;
                bestForegroundStyleDesc = condStyle.getStyle();
                bestForegroundColorIsConditonal = true;
            }
        }
        if (columnStyleUpdater != null) {
            for (ForegroundConditionalStyle condStyle : columnStyleUpdater.getForegroundConditionalStyle()) {
                if (bestForegroundColorIsConditonal || condStyle.getStyle() == null || cell.getTarget() == null || !(predicate = (safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter)).evaluateBoolean(cell.getTarget(), (EObject)condStyle, (EStructuralFeature)DescriptionPackage.eINSTANCE.getForegroundConditionalStyle_PredicateExpression()))) continue;
                bestForegroundStyleDesc = condStyle.getStyle();
                bestForegroundColorIsConditonal = true;
            }
        }
        if (bestForegroundStyleDesc != null) {
            return new StyleWithDefaultStatus(bestForegroundStyleDesc, !bestForegroundColorIsConditonal);
        }
        return null;
    }

    private ForegroundStyleDescription getBestForegroundStyle(DLine line) {
        ForegroundStyleDescription bestForegroundStyleDescription = null;
        boolean bestStyleIsConditonalStyle = false;
        LineMapping styleUpdater = line.getOriginMapping();
        if (styleUpdater.getDefaultForeground() != null) {
            bestForegroundStyleDescription = styleUpdater.getDefaultForeground();
        }
        for (ForegroundConditionalStyle condStyle : styleUpdater.getForegroundConditionalStyle()) {
            RuntimeLoggerInterpreter safeInterpreter;
            boolean predicate;
            if (bestStyleIsConditonalStyle || condStyle.getStyle() == null || line.getTarget() == null || !(predicate = (safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter)).evaluateBoolean(line.getTarget(), (EObject)condStyle, (EStructuralFeature)DescriptionPackage.eINSTANCE.getForegroundConditionalStyle_PredicateExpression()))) continue;
            bestForegroundStyleDescription = condStyle.getStyle();
            bestStyleIsConditonalStyle = true;
        }
        return bestForegroundStyleDescription;
    }

    private ForegroundStyleDescription getBestForegroundStyle(DColumn column) {
        ForegroundStyleDescription bestForegroundStyleDescription = null;
        StyleUpdater styleUpdater = null;
        if (column.getOriginMapping() instanceof FeatureColumnMapping || column.getOriginMapping() instanceof ElementColumnMapping) {
            styleUpdater = (StyleUpdater)((Object)column.getOriginMapping());
        }
        if (styleUpdater.getDefaultForeground() != null && styleUpdater.getDefaultForeground().getForeGroundColor() instanceof FixedColor) {
            bestForegroundStyleDescription = styleUpdater.getDefaultForeground();
        }
        return bestForegroundStyleDescription;
    }

    private boolean isDifferent(Object oldObject, Object newObject) {
        if (newObject == null && oldObject == null) {
            return false;
        }
        return newObject != null && !newObject.equals(oldObject) || newObject == null && oldObject != null;
    }

    public void refreshSemanticElements(DCell newCell) {
        ArrayList newElements = Lists.newArrayList();
        if (newCell.getIntersectionMapping() != null) {
            this.refreshSemanticElements(newCell, newCell.getIntersectionMapping());
        } else {
            if (newCell.getColumn().getOriginMapping() instanceof FeatureColumnMapping) {
                if (newCell.getTarget() != null) {
                    newElements.add(newCell.getTarget());
                }
                if (newCell.getLine() != null) {
                    newElements.addAll(newCell.getLine().getSemanticElements());
                }
            } else if (newCell.getColumn() instanceof DTargetColumn) {
                if (newCell.getTarget() != null) {
                    newElements.add(newCell.getTarget());
                }
                if (newCell.getLine() != null) {
                    newElements.add(newCell.getLine().getTarget());
                    newElements.addAll(newCell.getLine().getSemanticElements());
                    newElements.add(((DTargetColumn)newCell.getColumn()).getTarget());
                    newElements.addAll(((DTargetColumn)newCell.getColumn()).getSemanticElements());
                }
            }
            this.synchronizeLists((EList<EObject>)newCell.getSemanticElements(), newElements);
        }
        newCell.deactivate();
        newCell.activate(this);
    }

    private void synchronizeLists(EList<EObject> semanticElements, Collection<EObject> newElements) {
        if (!semanticElements.containsAll(newElements) || !newElements.containsAll((Collection<?>)semanticElements)) {
            Iterator it = semanticElements.iterator();
            while (it.hasNext()) {
                EObject cur = (EObject)it.next();
                if (newElements.contains(cur)) continue;
                it.remove();
            }
            semanticElements.addAll(newElements);
        }
    }

    public void refreshSemanticElements(DTableElement tableElement, TableMapping mapping) {
        if (mapping.getSemanticElements() != null && !StringUtil.isEmpty((String)mapping.getSemanticElements())) {
            List<EObject> elements;
            if (tableElement.eContainer() != null) {
                this.interpreter.setVariable("containerView", (Object)tableElement.eContainer());
                if (tableElement.eContainer() instanceof DSemanticDecorator) {
                    this.interpreter.setVariable("container", (Object)((DSemanticDecorator)tableElement.eContainer()).getTarget());
                }
            }
            this.interpreter.setVariable("view", (Object)tableElement);
            if (mapping instanceof LineMapping || TableHelper.hasTableDescriptionOnlyOneLineMapping(mapping)) {
                elements = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateCollection(tableElement.getTarget(), (EObject)mapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getTableMapping_SemanticElements());
            } else {
                try {
                    elements = this.interpreter.evaluateCollection(tableElement.getTarget(), mapping.getSemanticElements());
                }
                catch (EvaluationException evaluationException) {
                    elements = Collections.emptyList();
                }
            }
            this.synchronizeLists((EList<EObject>)tableElement.getSemanticElements(), elements);
            if (tableElement.eContainer() != null) {
                this.interpreter.unSetVariable("containerView");
                if (tableElement.eContainer() instanceof DSemanticDecorator) {
                    this.interpreter.unSetVariable("container");
                }
            }
            this.interpreter.unSetVariable("view");
        } else if (tableElement.getTarget() != null) {
            this.synchronizeLists((EList<EObject>)tableElement.getSemanticElements(), Collections.singletonList(tableElement.getTarget()));
        } else {
            List<EObject> elements = Collections.emptyList();
            this.synchronizeLists((EList<EObject>)tableElement.getSemanticElements(), elements);
        }
    }

    private ILabelProvider getLabelProvider(EObject element) {
        final IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.pluginRegisteredAdapterFactory.adapt((Notifier)element, IItemLabelProvider.class);
        return new LabelProvider(){

            public String getText(Object element) {
                if (itemLabelProvider != null) {
                    return itemLabelProvider.getText(element);
                }
                return super.getText(element);
            }
        };
    }

    private IItemPropertyDescriptor getPropertyDescriptor(EObject instance, String featureName) {
        EStructuralFeature structuralFeature = instance.eClass().getEStructuralFeature(featureName);
        IItemPropertySource propertySource = (IItemPropertySource)this.pluginRegisteredAdapterFactory.adapt((Notifier)instance, IItemPropertySource.class);
        IItemPropertyDescriptor propertyDescriptor = null;
        if (propertySource != null) {
            Iterator iterDescriptors = propertySource.getPropertyDescriptors((Object)instance).iterator();
            while (iterDescriptors.hasNext() && propertyDescriptor == null) {
                IItemPropertyDescriptor currentPropertyDescriptor = (IItemPropertyDescriptor)iterDescriptors.next();
                Object currentFeature = currentPropertyDescriptor.getFeature((Object)instance);
                if (currentFeature == null || !currentFeature.equals(structuralFeature)) continue;
                propertyDescriptor = currentPropertyDescriptor;
            }
        }
        return propertyDescriptor;
    }

    private void reset(EObject target, EStructuralFeature feature) {
        if (target.eIsSet(feature)) {
            target.eUnset(feature);
        }
    }
}

