/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.databinding;

import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.uml.tools.utils.ImageUtil;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Image;

public class ImageKindObservableValue
extends AbstractObservableValue
implements IObserving {
    public static final String KIND_UNDEFINED = "undefined";
    public static final String KIND_ICON = "icon";
    public static final String KIND_SHAPE = "shape";
    private Image image;
    private EditingDomain domain;

    public ImageKindObservableValue(Image image, EditingDomain domain) {
        this.image = image;
        this.domain = domain;
    }

    public Object getValueType() {
        return String.class;
    }

    protected String doGetValue() {
        return ImageUtil.getKind((Image)this.image);
    }

    protected void doSetValue(Object value) {
        if (value instanceof String) {
            final String kind = (String)value;
            Runnable runnable = new Runnable(){

                public void run() {
                    ImageUtil.setKind((Image)ImageKindObservableValue.this.image, (String)kind);
                }
            };
            ChangeCommand emfCommand = new ChangeCommand(this.domain, runnable);
            this.domain.getCommandStack().execute((Command)emfCommand);
        }
    }

    public Object getObserved() {
        return this.image;
    }
}

