/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.commands.internal.expressions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;

public class UMLPropertyTester
extends PropertyTester {
    public static final String IS_ROOT = "isRoot";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_ROOT.equals(property)) {
            return Boolean.valueOf(this.isRoot(receiver)).equals(this.asBoolean(expectedValue));
        }
        return false;
    }

    protected Boolean asBoolean(Object value) {
        return value == null ? Boolean.TRUE : (value instanceof Boolean ? (Boolean)value : Boolean.FALSE);
    }

    protected boolean isRoot(Object object) {
        boolean result = false;
        EObject eObject = EMFHelper.getEObject((Object)object);
        if (eObject != null) {
            try {
                ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)eObject);
                UmlModel uml = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                try {
                    result = uml != null && uml.lookupRoot() == eObject;
                }
                catch (NotFoundException e) {
                    result = false;
                }
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return result;
    }
}

