/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.runtime.logger;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Location;
import org.eclipse.ant.internal.launching.debug.AntDebugState;
import org.eclipse.ant.internal.launching.debug.IAntDebugController;
import org.eclipse.ant.internal.launching.debug.IDebugBuildLogger;
import org.eclipse.ant.internal.launching.debug.model.AntDebugTarget;
import org.eclipse.ant.internal.launching.debug.model.AntThread;
import org.eclipse.ant.internal.launching.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.launching.runtime.logger.AntProcessBuildLogger;
import org.eclipse.ant.internal.launching.runtime.logger.RuntimeMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IProcess;

public class AntProcessDebugBuildLogger
extends AntProcessBuildLogger
implements IAntDebugController,
IDebugBuildLogger {
    private AntDebugState fDebugState = null;
    private List<IBreakpoint> fBreakpoints = null;
    private AntDebugTarget fAntDebugTarget;
    private boolean fResumed = false;

    @Override
    public void buildStarted(BuildEvent event) {
        this.fDebugState = new AntDebugState((IDebugBuildLogger)this);
        super.buildStarted(event);
        AntProcess process = this.getAntProcess(this.fProcessId);
        ILaunch launch = process.getLaunch();
        this.fAntDebugTarget = new AntDebugTarget(launch, (IProcess)process, (IAntDebugController)this);
        launch.addDebugTarget((IDebugTarget)this.fAntDebugTarget);
        this.fAntDebugTarget.buildStarted();
        this.fDebugState.buildStarted();
    }

    @Override
    public void buildFinished(BuildEvent event) {
        super.buildFinished(event);
        this.cleanup();
    }

    void cleanup() {
        AntProcess process;
        if (this.fAntDebugTarget != null && (process = this.getAntProcess(this.fProcessId)) != null) {
            ILaunch launch = process.getLaunch();
            launch.removeDebugTarget((IDebugTarget)this.fAntDebugTarget);
        }
        if (this.fDebugState != null) {
            this.fDebugState.buildFinished();
        }
        if (this.fBreakpoints != null) {
            this.fBreakpoints.clear();
        }
    }

    @Override
    public void taskFinished(BuildEvent event) {
        super.taskFinished(event);
        this.fDebugState.taskFinished();
    }

    @Override
    public void taskStarted(BuildEvent event) {
        super.taskStarted(event);
        this.fDebugState.taskStarted(event);
    }

    public synchronized void waitIfSuspended() {
        this.fResumed = false;
        IBreakpoint breakpoint = this.breakpointAtLineNumber(this.fDebugState.getBreakpointLocation());
        if (breakpoint != null) {
            this.fAntDebugTarget.breakpointHit(breakpoint);
            try {
                while (!this.fResumed) {
                    ((Object)((Object)this)).wait(500L);
                    this.checkCancelled();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (this.fDebugState.getCurrentTask() != null) {
            int detail = -1;
            boolean shouldSuspend = true;
            if (this.fDebugState.isStepIntoSuspend()) {
                detail = 8;
                this.fDebugState.setStepIntoSuspend(false);
            } else if (this.fDebugState.getLastTaskFinished() != null && this.fDebugState.getLastTaskFinished() == this.fDebugState.getStepOverTask() || this.fDebugState.shouldSuspend()) {
                detail = 8;
                this.fDebugState.setShouldSuspend(false);
                this.fDebugState.setStepOverTask(null);
            } else if (this.fDebugState.isClientSuspend()) {
                detail = 32;
                this.fDebugState.setClientSuspend(false);
            } else {
                shouldSuspend = false;
            }
            if (shouldSuspend) {
                this.fAntDebugTarget.suspended(detail);
                try {
                    while (!this.fResumed) {
                        ((Object)((Object)this)).wait(500L);
                        this.checkCancelled();
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private void checkCancelled() {
        AntProcess process = this.getAntProcess(this.fProcessId);
        if (process != null && process.isCanceled()) {
            throw new OperationCanceledException(RuntimeMessages.AntProcessDebugBuildLogger_1);
        }
    }

    public synchronized void resume() {
        this.fResumed = true;
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized void suspend() {
        this.fDebugState.setClientSuspend(true);
    }

    public synchronized void stepInto() {
        this.fDebugState.setStepIntoSuspend(true);
        this.fResumed = true;
        ((Object)((Object)this)).notifyAll();
    }

    public void terminate() {
        this.cleanup();
    }

    public synchronized void stepOver() {
        this.fResumed = true;
        this.fDebugState.stepOver();
    }

    public void handleBreakpoint(IBreakpoint breakpoint, boolean added) {
        if (added) {
            if (this.fBreakpoints == null) {
                this.fBreakpoints = new ArrayList<IBreakpoint>();
            }
            if (!this.fBreakpoints.contains(breakpoint)) {
                this.fBreakpoints.add(breakpoint);
            }
        } else if (this.fBreakpoints != null) {
            this.fBreakpoints.remove(breakpoint);
        }
    }

    public void getProperties() {
        if (this.fAntDebugTarget == null || !this.fAntDebugTarget.isSuspended()) {
            return;
        }
        StringBuffer propertiesRepresentation = new StringBuffer();
        this.fDebugState.marshallProperties(propertiesRepresentation, false);
        if (this.fAntDebugTarget.getThreads().length > 0) {
            ((AntThread)this.fAntDebugTarget.getThreads()[0]).newProperties(propertiesRepresentation.toString());
        }
    }

    public void getStackFrames() {
        StringBuffer stackRepresentation = new StringBuffer();
        this.fDebugState.marshalStack(stackRepresentation);
        ((AntThread)this.fAntDebugTarget.getThreads()[0]).buildStack(stackRepresentation.toString());
    }

    private IBreakpoint breakpointAtLineNumber(Location location) {
        if (this.fBreakpoints == null || location == null || location == Location.UNKNOWN_LOCATION) {
            return null;
        }
        int lineNumber = this.fDebugState.getLineNumber(location);
        File locationFile = new File(this.fDebugState.getFileName(location));
        int i = 0;
        while (i < this.fBreakpoints.size()) {
            block5: {
                int breakpointLineNumber;
                ILineBreakpoint breakpoint = (ILineBreakpoint)this.fBreakpoints.get(i);
                try {
                    if (!breakpoint.isEnabled()) break block5;
                    breakpointLineNumber = breakpoint.getLineNumber();
                }
                catch (CoreException coreException) {
                    return null;
                }
                IFile resource = (IFile)breakpoint.getMarker().getResource();
                if (breakpointLineNumber == lineNumber && resource.getLocation().toFile().equals(locationFile)) {
                    return breakpoint;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public void targetStarted(BuildEvent event) {
        this.fDebugState.targetStarted(event);
        this.waitIfSuspended();
        super.targetStarted(event);
    }

    @Override
    public void targetFinished(BuildEvent event) {
        super.targetFinished(event);
        if (this.fDebugState != null) {
            this.fDebugState.setTargetExecuting(null);
        }
    }

    public StringBuffer unescapeString(StringBuffer propertyValue) {
        return propertyValue;
    }
}

