/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.interpreter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.acceleo.common.interpreter.CompilationResult;
import org.eclipse.acceleo.internal.parser.AcceleoParserMessages;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.parser.AcceleoParser;
import org.eclipse.acceleo.parser.AcceleoParserInfo;
import org.eclipse.acceleo.parser.AcceleoParserInfos;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.acceleo.parser.AcceleoParserWarning;
import org.eclipse.acceleo.parser.AcceleoParserWarnings;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.acceleo.parser.interpreter.ModuleDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoCompilationTask
implements Callable<CompilationResult> {
    private static final String PARSER_PLUGIN_ID = "org.eclipse.acceleo.parser";
    private final Set<URI> dependencies;
    private final ModuleDescriptor moduleDescriptor;
    private final String queryName;
    private ResourceSet resourceSet;

    public AcceleoCompilationTask(ModuleDescriptor descriptor, Set<URI> dependencies) {
        this(descriptor, dependencies, null);
    }

    public AcceleoCompilationTask(ModuleDescriptor descriptor, Set<URI> dependencies, String queryName) {
        this(descriptor, dependencies, queryName, null);
    }

    public AcceleoCompilationTask(ModuleDescriptor descriptor, Set<URI> dependencies, String queryName, ResourceSet resourceSet) {
        this.moduleDescriptor = descriptor;
        this.dependencies = dependencies != null ? dependencies : Collections.emptySet();
        this.queryName = queryName;
        this.resourceSet = resourceSet;
    }

    private static IStatus parseProblems(AcceleoParserProblems errors, AcceleoParserWarnings warnings, AcceleoParserInfos infos) {
        ArrayList<Status> problems = new ArrayList<Status>();
        for (AcceleoParserProblem error : errors.getList()) {
            problems.add(new Status(4, PARSER_PLUGIN_ID, error.getMessage()));
        }
        for (AcceleoParserWarning warning : warnings.getList()) {
            problems.add(new Status(2, PARSER_PLUGIN_ID, warning.getMessage()));
        }
        for (AcceleoParserInfo info : infos.getList()) {
            problems.add(new Status(1, PARSER_PLUGIN_ID, info.getMessage()));
        }
        if (problems.isEmpty()) {
            return null;
        }
        MultiStatus status = new MultiStatus(PARSER_PLUGIN_ID, 1, AcceleoParserMessages.getString("AcceleoCompilationTask.CompilationIssues"), null);
        for (IStatus iStatus : problems) {
            status.add(iStatus);
        }
        return status;
    }

    @Override
    public CompilationResult call() throws Exception {
        Resource old;
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        if ((old = this.resourceSet.getResource(this.moduleDescriptor.getModuleURI(), false)) != null) {
            this.resourceSet.getResources().remove((Object)old);
        }
        Resource resource = this.resourceSet.createResource(this.moduleDescriptor.getModuleURI());
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(new StringBuffer(this.moduleDescriptor.getModuleContent()));
        this.loadImports();
        AcceleoParser parser = new AcceleoParser();
        parser.parse(source, resource, (List<URI>)Lists.newArrayList(this.dependencies));
        EObject resultNode = null;
        if (!resource.getContents().isEmpty() && resource.getContents().get(0) instanceof Module) {
            resultNode = (EObject)resource.getContents().get(0);
            if (this.queryName != null) {
                Iterator queries = Iterables.filter((Iterable)((Module)resultNode).getOwnedModuleElement(), Query.class).iterator();
                while (!(resultNode instanceof Query) && queries.hasNext()) {
                    Query query = (Query)queries.next();
                    if (!this.queryName.equals(query.getName())) continue;
                    resultNode = query;
                }
            }
        }
        IStatus problems = AcceleoCompilationTask.parseProblems(source.getProblems(), source.getWarnings(), source.getInfos());
        return new CompilationResult((Object)resultNode, problems);
    }

    private void loadImports() {
        for (URI dependency : this.dependencies) {
            this.resourceSet.getResource(dependency, true);
        }
    }
}

