/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectionMenu {
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    private Shell parentShell;
    private Point location;
    private Object input;
    private Shell shell;
    private final ISelectionChangedListener selectionChangedListener;
    private final List<ISelectionChangedListener> selectionChangedListeners;

    public SelectionMenu(Shell parentShell) {
        this(parentShell, parentShell.getDisplay().getCursorLocation());
    }

    public SelectionMenu(Shell parentShell, Point location) {
        ++location.x;
        ++location.y;
        this.parentShell = parentShell;
        this.location = location;
        this.labelProvider = new LabelProvider();
        this.selectionChangedListeners = new LinkedList<ISelectionChangedListener>();
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                for (ISelectionChangedListener listener : SelectionMenu.this.selectionChangedListeners) {
                    listener.selectionChanged(event);
                }
            }
        };
    }

    public void open() {
        this.shell = new Shell(this.parentShell, 0);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.setBackgroundMode(1);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        this.shell.setLayout((Layout)gridLayout);
        this.shell.setLayout((Layout)new GridLayout(1, false));
        TableViewer tableViewer = new TableViewer((Composite)this.shell, 16);
        tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        tableViewer.setInput(this.input);
        tableViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.shell.setLocation(this.location);
        this.shell.pack();
        this.shell.open();
    }

    public void dispose() {
        if (this.shell != null) {
            this.shell.dispose();
        }
    }

    public void setContentProvider(IStructuredContentProvider provider) {
        this.contentProvider = provider;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }
}

