/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.dataproviders;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.papyrus.xwt.IDataProvider;
import org.eclipse.papyrus.xwt.core.IBinding;

public abstract class AbstractDataProvider
implements IDataProvider {
    private HashMap<String, Object> properties = new HashMap();

    public Object getProperty(String property) {
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    public boolean hasProperty(String property) {
        return this.properties.containsKey(property);
    }

    public void removeProperty(String property) {
        this.properties.remove(property);
    }

    public boolean isPropertyReadOnly(String path) {
        return false;
    }

    public IObservable observe(Object data, String path, Object elementType, int observeKind) {
        Object type = null;
        type = elementType == null ? this.getModelService().toModelType(data) : elementType;
        Object propertyType = this.getModelService().toModelPropertyType(type, path);
        Class propertyTypeClass = null;
        if (propertyType instanceof Class && IBinding.class.isAssignableFrom(propertyTypeClass = (Class)propertyType)) {
            return null;
        }
        switch (observeKind) {
            case 0: {
                if (propertyTypeClass != null && (propertyTypeClass.isArray() || List.class.isAssignableFrom(propertyTypeClass))) {
                    if (data instanceof IObservableValue) {
                        IObservableValue observable = (IObservableValue)data;
                        return this.observeDetailList(observable, type, path, propertyType);
                    }
                    return this.observeList(data, path);
                }
                if (propertyTypeClass != null && Set.class.isAssignableFrom(propertyTypeClass)) {
                    if (data instanceof IObservableValue) {
                        IObservableValue observable = (IObservableValue)data;
                        return this.observeDetailSet(observable, type, path, propertyType);
                    }
                    return this.observeSet(data, path);
                }
                if (data instanceof IObservableValue) {
                    IObservableValue observable = (IObservableValue)data;
                    return this.observeDetailValue(observable, type, path, propertyType);
                }
                return this.observeValue(data, path);
            }
            case 1: {
                if (data instanceof IObservableValue) {
                    IObservableValue observable = (IObservableValue)data;
                    return this.observeDetailValue(observable, type, path, propertyType);
                }
                return this.observeValue(data, path);
            }
            case 4: {
                if (propertyTypeClass != null && Set.class.isAssignableFrom(propertyTypeClass)) {
                    if (data instanceof IObservableValue) {
                        IObservableValue observable = (IObservableValue)data;
                        return this.observeDetailSet(observable, type, path, propertyType);
                    }
                    return this.observeSet(data, path);
                }
                if (data instanceof IObservableValue) {
                    IObservableValue observable = (IObservableValue)data;
                    return this.observeDetailList(observable, type, path, propertyType);
                }
                return this.observeList(data, path);
            }
            case 2: {
                if (data instanceof IObservableValue) {
                    IObservableValue observable = (IObservableValue)data;
                    return this.observeDetailSet(observable, type, path, propertyType);
                }
                return this.observeSet(data, path);
            }
            case 3: {
                if (data instanceof IObservableValue) {
                    IObservableValue observable = (IObservableValue)data;
                    return this.observeDetailList(observable, type, path, propertyType);
                }
                return this.observeList(data, path);
            }
        }
        return null;
    }

    protected abstract IObservableValue observeValue(Object var1, String var2);

    protected IObservableList observeList(Object bean, String propertyName) {
        return null;
    }

    protected IObservableSet observeSet(Object bean, String propertyName) {
        return null;
    }

    protected IObservableList observeDetailList(IObservableValue bean, Object elementType, String propertyName, Object propertyType) {
        return null;
    }

    protected IObservableSet observeDetailSet(IObservableValue bean, Object elementType, String propertyName, Object propertyType) {
        return null;
    }

    protected abstract IObservableValue observeDetailValue(IObservableValue var1, Object var2, String var3, Object var4);

    public IValueProperty createValueProperty(Object type, String fullPath) {
        throw new UnsupportedOperationException("to remove this method");
    }
}

