/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.ConditionalNode;
import org.eclipse.uml2.uml.ExpansionRegion;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.SequenceNode;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLPackage;

public class StructuredActivityNodeKeywordParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String KEYWORD_FORMAT = "<<%s>>";
    private static final Object STRUCTURED_KEYWORD = "structured";
    private static final Object LOOP_NODE_KEYWORD = "loop node";
    private static final Object CONDITIONAL_NODE_KEYWORD = "conditional";
    private static final Object SEQUENCE_NODE_KEYWORD = "sequence";
    private final IPreferenceStore preferenceStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();

    public StructuredActivityNodeKeywordParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public StructuredActivityNodeKeywordParser(EAttribute[] features) {
        super(features);
    }

    public StructuredActivityNodeKeywordParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof StructuredActivityNode) {
            boolean displayNameName;
            if (obj instanceof ExpansionRegion) {
                ExpansionRegion region = (ExpansionRegion)obj;
                return String.format(KEYWORD_FORMAT, region.getMode().getName());
            }
            if (obj instanceof LoopNode) {
                boolean displayNameName2 = this.preferenceStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.StructuredActivityNode.specificLabel.loopNode");
                if (displayNameName2) {
                    return String.format(KEYWORD_FORMAT, LOOP_NODE_KEYWORD);
                }
            } else if (obj instanceof ConditionalNode) {
                boolean displayNameName3 = this.preferenceStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.StructuredActivityNode.specificLabel.conditionalNode");
                if (displayNameName3) {
                    return String.format(KEYWORD_FORMAT, CONDITIONAL_NODE_KEYWORD);
                }
            } else if (obj instanceof SequenceNode && (displayNameName = this.preferenceStore.getBoolean("org.eclipse.papyrus.uml.diagram.activity.StructuredActivityNode.specificLabel.sequenceNode"))) {
                return String.format(KEYWORD_FORMAT, SEQUENCE_NODE_KEYWORD);
            }
            return String.format(KEYWORD_FORMAT, STRUCTURED_KEYWORD);
        }
        return "";
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<StructuredActivityNode> semanticElementsBeingParsed = new ArrayList<StructuredActivityNode>();
        if (element instanceof StructuredActivityNode) {
            StructuredActivityNode node = (StructuredActivityNode)element;
            semanticElementsBeingParsed.add(node);
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getExpansionRegion_Mode().equals(feature);
    }
}

