/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.helper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.ConfirmActivityParameterNodeAndParameterSyncDialog;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.WarningAndLinkDialog;
import org.eclipse.papyrus.uml.diagram.activity.helper.SafeDialogOpenerDuringValidation;
import org.eclipse.papyrus.uml.diagram.activity.part.CustomMessages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityParameterAndParameterSynchronizer
extends AbstractModelConstraint {
    private static final ILabelProvider labelProvider = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
    private Set<ActivityParameterNode> nodesToRemove = new HashSet<ActivityParameterNode>();

    public IStatus validate(IValidationContext ctx) {
        try {
            EObject eObject = ctx.getTarget();
            if (eObject instanceof Activity) {
                return this.handleActivityModification((Activity)eObject, ctx);
            }
            if (eObject instanceof ActivityParameterNode) {
                return this.handleActivityParameterNodeModification((ActivityParameterNode)eObject, ctx);
            }
            if (eObject instanceof Parameter) {
                return this.handleParameterModification((Parameter)eObject, ctx);
            }
            return ctx.createSuccessStatus();
        }
        catch (RuntimeException rte) {
            Log.warning((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"Unexpected exception during Activity Parameter Node and Parameter synchronization : ", (Throwable)rte);
            return ctx.createSuccessStatus();
        }
    }

    private IStatus handleActivityParameterNodeModification(ActivityParameterNode eObject, IValidationContext ctx) {
        Parameter parameter;
        if (EMFEventType.SET.equals(ctx.getEventType()) && UMLPackage.eINSTANCE.getTypedElement_Type().equals(ctx.getFeature()) && (parameter = eObject.getParameter()) != null) {
            final String elementLabel = labelProvider.getText((Object)parameter);
            final String message = NLS.bind((String)CustomMessages.ActivityParameterAndParameterSynchronizer_UnauthorizedModificationRedirection, (Object)elementLabel);
            SafeDialogOpenerDuringValidation<Void> opener = new SafeDialogOpenerDuringValidation<Void>(){

                @Override
                protected Void openDialog() {
                    WarningAndLinkDialog dialog = new WarningAndLinkDialog(new Shell(Display.getDefault()), CustomMessages.ActivityParameterAndParameterSynchronizer_UnauthorizedModificationTitle, message, (NamedElement)parameter, elementLabel);
                    dialog.open();
                    return null;
                }
            };
            opener.execute();
            return ctx.createFailureStatus(new Object[0]);
        }
        return ctx.createSuccessStatus();
    }

    private IStatus handleParameterModification(Parameter eObject, IValidationContext ctx) {
        block3: {
            block2: {
                if (!EMFEventType.SET.equals(ctx.getEventType()) || !UMLPackage.eINSTANCE.getTypedElement_Type().equals(ctx.getFeature())) break block2;
                for (ActivityParameterNode node : this.getActivityParameterNodesFromParameter(eObject)) {
                    node.setType(node.getParameter().getType());
                }
                break block3;
            }
            if (!EMFEventType.SET.equals(ctx.getEventType()) || !UMLPackage.eINSTANCE.getNamedElement_Name().equals(ctx.getFeature())) break block3;
            for (ActivityParameterNode node : this.getActivityParameterNodesFromParameter(eObject)) {
                if (node.getName() != null && !"".equals(node.getName())) continue;
                node.setName(eObject.getName());
            }
        }
        return ctx.createSuccessStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus handleActivityModification(Activity eObject, IValidationContext ctx) {
        if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof ActivityParameterNode) {
            ActivityParameterNode activityParameterNode = (ActivityParameterNode)ctx.getFeatureNewValue();
            activityParameterNode.setType(activityParameterNode.getParameter().getType());
        }
        if ((EMFEventType.ADD.equals(ctx.getEventType()) || EMFEventType.ADD_MANY.equals(ctx.getEventType())) && ctx.getFeatureNewValue() instanceof Parameter) {
            Parameter parameter = (Parameter)ctx.getFeatureNewValue();
            if (!this.getActivityParameterNodesFromParameter(parameter).isEmpty()) return ctx.createSuccessStatus();
            ActivityParameterNode apn = UMLFactory.eINSTANCE.createActivityParameterNode();
            apn.setParameter(parameter);
            apn.setName(parameter.getName());
            apn.setType(parameter.getType());
            Command cmd = this.getAddActivityParameterNodesCmd(eObject, apn);
            if (!cmd.canExecute()) return ctx.createFailureStatus(new Object[0]);
            cmd.execute();
            return ctx.createSuccessStatus();
        } else {
            if ((!EMFEventType.REMOVE.equals(ctx.getEventType()) || !(ctx.getFeatureNewValue() instanceof Parameter)) && !EMFEventType.REMOVE_MANY.equals(ctx.getEventType())) return ctx.createSuccessStatus();
            this.nodesToRemove.clear();
            for (Notification n : ctx.getAllEvents()) {
                if (1 == n.getEventType() && UMLPackage.eINSTANCE.getActivityParameterNode_Parameter().equals(n.getFeature()) && n.getNotifier() instanceof ActivityParameterNode) {
                    this.nodesToRemove.add((ActivityParameterNode)n.getNotifier());
                }
                if (4 != n.getEventType() || !(n.getOldValue() instanceof ActivityParameterNode)) continue;
                this.nodesToRemove.remove(n.getOldValue());
            }
            if (this.nodesToRemove.isEmpty()) return ctx.createSuccessStatus();
            if (!this.askForValidation(this.nodesToRemove)) return ctx.createFailureStatus(new Object[0]);
            Command cmd = this.getRemoveActivityParameterNodesCmd(eObject, this.nodesToRemove);
            if (!cmd.canExecute()) return ctx.createFailureStatus(new Object[0]);
            cmd.execute();
        }
        return ctx.createSuccessStatus();
    }

    private Set<ActivityParameterNode> getActivityParameterNodesFromParameter(Parameter parameter) {
        HashSet<ActivityParameterNode> references = new HashSet<ActivityParameterNode>();
        if (parameter != null) {
            Collection inverseReferences = CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)parameter);
            for (EStructuralFeature.Setting ref : inverseReferences) {
                if (!UMLPackage.eINSTANCE.getActivityParameterNode_Parameter().equals(ref.getEStructuralFeature()) || ref.getEObject().eContainer() == null) continue;
                references.add((ActivityParameterNode)ref.getEObject());
            }
        }
        return references;
    }

    private Command getRemoveActivityParameterNodesCmd(Activity owner, Set<ActivityParameterNode> nodes) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        return RemoveCommand.create((EditingDomain)editingdomain, (Object)owner, (Object)UMLPackage.eINSTANCE.getActivity_Node(), nodes);
    }

    private Command getAddActivityParameterNodesCmd(Activity owner, ActivityParameterNode node) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        return AddCommand.create((EditingDomain)editingdomain, (Object)owner, (Object)UMLPackage.eINSTANCE.getActivity_Node(), (Object)node);
    }

    protected boolean askForValidation(final Set<? extends NamedElement> parameterNodes) {
        SafeDialogOpenerDuringValidation<Boolean> opener = new SafeDialogOpenerDuringValidation<Boolean>(){

            @Override
            protected Boolean openDialog() {
                return ConfirmActivityParameterNodeAndParameterSyncDialog.openConfirmFromParameter(Display.getDefault().getActiveShell(), parameterNodes, labelProvider);
            }
        };
        return (Boolean)opener.execute();
    }
}

