/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.viewpoints.policy.ModelAddData;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.uml.diagram.activity.providers.ElementInitializers;
import org.eclipse.uml2.uml.DestroyObjectAction;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class InputPinInDestroyObjectActionCreateCommand
extends EditElementCommand {
    private Diagram diagram = null;
    private EObject eObject = null;

    public InputPinInDestroyObjectActionCreateCommand(CreateElementRequest req, EObject eObject, Diagram diagram) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.eObject = eObject;
        this.diagram = diagram;
    }

    public static InputPinInDestroyObjectActionCreateCommand create(CreateElementRequest req, EObject eObject, Diagram diagram) {
        return new InputPinInDestroyObjectActionCreateCommand(req, eObject, diagram);
    }

    public InputPinInDestroyObjectActionCreateCommand(CreateElementRequest req, Diagram diagram) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.diagram = diagram;
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        if (container != null) {
            return container;
        }
        return this.eObject;
    }

    public boolean canExecute() {
        DestroyObjectAction container = (DestroyObjectAction)this.getElementToEdit();
        if (container.getTarget() != null) {
            return false;
        }
        EObject target = this.getElementToEdit();
        ModelAddData data = PolicyChecker.getCurrent().getChildAddData(this.diagram, target.eClass(), UMLPackage.eINSTANCE.getInputPin());
        return data.isPermitted();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        InputPin newElement = UMLFactory.eINSTANCE.createInputPin();
        EObject target = this.getElementToEdit();
        ModelAddData data = PolicyChecker.getCurrent().getChildAddData(this.diagram, target, (EObject)newElement);
        if (data.isPermitted()) {
            if (data.isPathDefined()) {
                if (!data.execute(target, (EObject)newElement)) {
                    return CommandResult.newErrorCommandResult((String)"Failed to follow the policy-specified for the insertion of the new element");
                }
            } else {
                DestroyObjectAction qualifiedTarget = (DestroyObjectAction)target;
                qualifiedTarget.setTarget(newElement);
            }
        } else {
            return CommandResult.newErrorCommandResult((String)"The active policy restricts the addition of this element");
        }
        ElementInitializers.getInstance().init_InputPin_3096(newElement);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(InputPin newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

