/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.description;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TreeDragSource implements Enumerator
{
    TREE(1, "TREE", "TREE"),
    PROJECT_EXPLORER(2, "PROJECT_EXPLORER", "PROJECT_EXPLORER"),
    BOTH(3, "BOTH", "BOTH");

    public static final int TREE_VALUE = 1;
    public static final int PROJECT_EXPLORER_VALUE = 2;
    public static final int BOTH_VALUE = 3;
    private static final TreeDragSource[] VALUES_ARRAY;
    public static final List<TreeDragSource> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TreeDragSource[]{TREE, PROJECT_EXPLORER, BOTH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TreeDragSource get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TreeDragSource result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TreeDragSource getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TreeDragSource result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TreeDragSource get(int value) {
        switch (value) {
            case 1: {
                return TREE;
            }
            case 2: {
                return PROJECT_EXPLORER;
            }
            case 3: {
                return BOTH;
            }
        }
        return null;
    }

    private TreeDragSource(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

