/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.preferences.utils;

import java.util.StringTokenizer;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.swt.graphics.RGB;

public class GradientPreferenceConverter {
    private static final int GRADIENT_COLOR1 = 0;
    private static final int GRADIENT_COLOR2 = 1;
    private static final int GRADIENT_STYLE = 2;
    private static final int GRADIENT_TRANSPARENCY = 3;
    private int fStyle = 1;
    private int fTransparency = 0;
    private RGB fColor1;
    private RGB fColor2;

    public GradientPreferenceConverter(String pPreference) {
        this.initFieldFromPreference(pPreference);
    }

    public GradientPreferenceConverter(RGB pColor1, RGB pColor2, int pStyle, int pTransparency) {
        this.fColor1 = pColor1;
        this.fColor2 = pColor2;
        this.fStyle = pStyle;
        this.fTransparency = pTransparency;
    }

    public GradientPreferenceConverter(int pColor1, int pColor2, int pStyle, int pTransparency) {
        this.fColor1 = FigureUtilities.integerToRGB((Integer)pColor1);
        this.fColor2 = FigureUtilities.integerToRGB((Integer)pColor2);
        this.fStyle = pStyle;
        this.fTransparency = pTransparency;
    }

    private void initFieldFromPreference(String pPreference) {
        String[] values = pPreference.split(";");
        if (values.length == 4) {
            this.fColor1 = GradientPreferenceConverter.getRGBColor(values[0]);
            this.fColor2 = GradientPreferenceConverter.getRGBColor(values[1]);
            this.fStyle = Integer.parseInt(values[2]);
            this.fTransparency = Integer.parseInt(values[3]);
        }
    }

    public int getTransparency() {
        return this.fTransparency;
    }

    public GradientData getGradientData() {
        GradientData gd = GradientData.getDefaultGradientData();
        if (this.fColor1 != null && this.fColor2 != null) {
            gd = new GradientData(FigureUtilities.RGBToInteger((RGB)this.fColor1).intValue(), FigureUtilities.RGBToInteger((RGB)this.fColor2).intValue(), this.fStyle);
        }
        return gd;
    }

    public RGB getColor1() {
        RGB color = this.fColor1 != null ? this.fColor1 : FigureUtilities.integerToRGB((Integer)GradientData.getDefaultGradientData().getGradientColor1());
        return color;
    }

    public RGB getColor2() {
        RGB color = this.fColor1 != null ? this.fColor2 : FigureUtilities.integerToRGB((Integer)GradientData.getDefaultGradientData().getGradientColor2());
        return color;
    }

    public int getStyle() {
        return this.fStyle;
    }

    private static RGB getRGBColor(String string) {
        StringTokenizer st = new StringTokenizer(string, "RGB ,{}");
        int red = Integer.parseInt(st.nextToken());
        int green = Integer.parseInt(st.nextToken());
        int blue = Integer.parseInt(st.nextToken());
        return new RGB(red, green, blue);
    }

    public String getPreferenceValue() {
        StringBuffer sb = new StringBuffer(30);
        sb.append(this.fColor1.toString());
        sb.append(";");
        sb.append(this.fColor2.toString());
        sb.append(";");
        sb.append(this.fStyle);
        sb.append(";");
        sb.append(this.fTransparency);
        return sb.toString().trim();
    }
}

