/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.style.impl;

import java.util.Arrays;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.DoubleValueStyle;
import org.eclipse.gmf.runtime.notation.IntValueStyle;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.StringListValueStyle;
import org.eclipse.gmf.runtime.notation.StringValueStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.ParserHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSStyles;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSView;
import org.w3c.dom.css.CSSValue;

public class CSSViewDelegate
implements CSSView {
    private View view;
    private ExtendedCSSEngine engine;
    private boolean lookupStyle = false;

    public CSSViewDelegate(View view, ExtendedCSSEngine engine) {
        this.view = view;
        this.engine = engine;
    }

    @Override
    public boolean isCSSVisible() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.view, "visible");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getView_Visible().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NamedStyle getCSSNamedStyle(EClass eClass, String name) {
        CSSValue cssValue;
        if (!NotationPackage.eINSTANCE.getNamedStyle().isSuperTypeOf(eClass)) {
            return null;
        }
        if (CSSStyles.RESERVED_KEYWORDS.contains(name)) {
            return null;
        }
        CSSViewDelegate cSSViewDelegate = this;
        synchronized (cSSViewDelegate) {
            if (this.lookupStyle) {
                return null;
            }
            try {
                this.lookupStyle = true;
                cssValue = this.engine.retrievePropertyValue(this.view, name);
                if (cssValue == null) {
                    return null;
                }
            }
            finally {
                this.lookupStyle = false;
            }
        }
        try {
            switch (eClass.getClassifierID()) {
                case 44: {
                    Boolean booleanValue = (Boolean)this.engine.convert(cssValue, Boolean.class, null);
                    BooleanValueStyle booleanStyle = NotationFactory.eINSTANCE.createBooleanValueStyle();
                    booleanStyle.setBooleanValue(booleanValue.booleanValue());
                    booleanStyle.setName(name);
                    return booleanStyle;
                }
                case 47: {
                    String stringValue = (String)this.engine.convert(cssValue, String.class, null);
                    StringValueStyle stringStyle = NotationFactory.eINSTANCE.createStringValueStyle();
                    stringStyle.setName(name);
                    stringStyle.setStringValue(stringValue);
                    return stringStyle;
                }
                case 42: {
                    Integer intValue = (Integer)this.engine.convert(cssValue, Integer.class, null);
                    IntValueStyle intStyle = NotationFactory.eINSTANCE.createIntValueStyle();
                    intStyle.setName(name);
                    intStyle.setIntValue(intValue.intValue());
                    return intStyle;
                }
                case 45: {
                    Double doubleValue = (Double)this.engine.convert(cssValue, Double.class, null);
                    DoubleValueStyle doubleStyle = NotationFactory.eINSTANCE.createDoubleValueStyle();
                    doubleStyle.setName(name);
                    doubleStyle.setDoubleValue(doubleValue.doubleValue());
                    return doubleStyle;
                }
                case 48: {
                    String[] values = ParserHelper.parseValues((CSSEngine)this.engine, cssValue);
                    StringListValueStyle stringListStyle = NotationFactory.eINSTANCE.createStringListValueStyle();
                    stringListStyle.setName(name);
                    stringListStyle.getStringListValue().addAll(Arrays.asList(values));
                    return stringListStyle;
                }
            }
            return null;
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }
}

